; APX CCMPSCC testcases

%macro testcase 2
 %ifdef BIN
  db %1
 %endif
 %ifdef SRC
  %2
 %endif
%endmacro

bits 64

; ----- ccmpscc instructions -----
; --- ccmpb instruction ---
testcase	{0x62, 0xF4, 0x04, 0x02, 0x38, 0x0A},	{ccmpb{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x02, 0x39, 0x0A},	{ccmpb{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x02, 0x39, 0x0A},	{ccmpb{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x02, 0x39, 0x0A},	{ccmpb{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x02, 0x38, 0x0A},	{ccmpb{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x02, 0x39, 0x0A},	{ccmpb{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x02, 0x39, 0x0A},	{ccmpb{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x02, 0x39, 0x0A},	{ccmpb{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x02, 0x3A, 0x0A},	{ccmpb{dfv=} cl, [rdx]}
testcase	{0x62, 0xF4, 0x05, 0x02, 0x3B, 0x0A},	{ccmpb{dfv=} cx, [rdx]}
testcase	{0x62, 0xF4, 0x04, 0x02, 0x3B, 0x0A},	{ccmpb{dfv=} ecx, [rdx]}
testcase	{0x62, 0xF4, 0x84, 0x02, 0x3B, 0x0A},	{ccmpb{dfv=} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x04, 0x02, 0x3A, 0x0A},	{ccmpb{dfv=} cl, [r26]}
testcase	{0x62, 0xDC, 0x05, 0x02, 0x3B, 0x0A},	{ccmpb{dfv=} cx, [r26]}
testcase	{0x62, 0xDC, 0x04, 0x02, 0x3B, 0x0A},	{ccmpb{dfv=} ecx, [r26]}
testcase	{0x62, 0xDC, 0x84, 0x02, 0x3B, 0x0A},	{ccmpb{dfv=} rcx, [r26]}
testcase	{0x62, 0xF4, 0x04, 0x02, 0x80, 0x3A, 0x05},	{ccmpb{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x02, 0x81, 0x3A, 0x05, 0x00},	{ccmpb{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x02, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpb{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x02, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpb{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x02, 0x80, 0x3A, 0x05},	{ccmpb{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x02, 0x81, 0x3A, 0x05, 0x00},	{ccmpb{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x02, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpb{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x02, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpb{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x05, 0x02, 0x83, 0x3A, 0x05},	{ccmpb{dfv=} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x04, 0x02, 0x83, 0x3A, 0x05},	{ccmpb{dfv=} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x84, 0x02, 0x83, 0x3A, 0x05},	{ccmpb{dfv=} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x02, 0x83, 0x3A, 0x05},	{ccmpb{dfv=} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x04, 0x02, 0x83, 0x3A, 0x05},	{ccmpb{dfv=} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x84, 0x02, 0x83, 0x3A, 0x05},	{ccmpb{dfv=} qword [r26], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x02, 0x38, 0x0A},	{ccmpb{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x02, 0x39, 0x0A},	{ccmpb{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x02, 0x39, 0x0A},	{ccmpb{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x02, 0x39, 0x0A},	{ccmpb{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x02, 0x38, 0x0A},	{ccmpb{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x02, 0x39, 0x0A},	{ccmpb{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x02, 0x39, 0x0A},	{ccmpb{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x02, 0x39, 0x0A},	{ccmpb{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x02, 0x3A, 0x0A},	{ccmpb{dfv=cf,zf,sf,of} cl, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x02, 0x3B, 0x0A},	{ccmpb{dfv=cf,zf,sf,of} cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x02, 0x3B, 0x0A},	{ccmpb{dfv=cf,zf,sf,of} ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x02, 0x3B, 0x0A},	{ccmpb{dfv=cf,zf,sf,of} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7C, 0x02, 0x3A, 0x0A},	{ccmpb{dfv=cf,zf,sf,of} cl, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x02, 0x3B, 0x0A},	{ccmpb{dfv=cf,zf,sf,of} cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x02, 0x3B, 0x0A},	{ccmpb{dfv=cf,zf,sf,of} ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x02, 0x3B, 0x0A},	{ccmpb{dfv=cf,zf,sf,of} rcx, [r26]}
testcase	{0x62, 0xF4, 0x7C, 0x02, 0x80, 0x3A, 0x05},	{ccmpb{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x02, 0x81, 0x3A, 0x05, 0x00},	{ccmpb{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x02, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpb{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x02, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpb{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x02, 0x80, 0x3A, 0x05},	{ccmpb{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x02, 0x81, 0x3A, 0x05, 0x00},	{ccmpb{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x02, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpb{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x02, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpb{dfv=cf,zf,sf,of} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x02, 0x83, 0x3A, 0x05},	{ccmpb{dfv=cf,zf,sf,of} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x02, 0x83, 0x3A, 0x05},	{ccmpb{dfv=cf,zf,sf,of} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x02, 0x83, 0x3A, 0x05},	{ccmpb{dfv=cf,zf,sf,of} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x02, 0x83, 0x3A, 0x05},	{ccmpb{dfv=cf,zf,sf,of} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x02, 0x83, 0x3A, 0x05},	{ccmpb{dfv=cf,zf,sf,of} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x02, 0x83, 0x3A, 0x05},	{ccmpb{dfv=cf,zf,sf,of} qword [r26], byte 0x05}

; --- ccmpbe instruction ---
testcase	{0x62, 0xF4, 0x04, 0x06, 0x38, 0x0A},	{ccmpbe{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x06, 0x39, 0x0A},	{ccmpbe{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x06, 0x39, 0x0A},	{ccmpbe{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x06, 0x39, 0x0A},	{ccmpbe{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x06, 0x38, 0x0A},	{ccmpbe{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x06, 0x39, 0x0A},	{ccmpbe{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x06, 0x39, 0x0A},	{ccmpbe{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x06, 0x39, 0x0A},	{ccmpbe{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x06, 0x3A, 0x0A},	{ccmpbe{dfv=} cl, [rdx]}
testcase	{0x62, 0xF4, 0x05, 0x06, 0x3B, 0x0A},	{ccmpbe{dfv=} cx, [rdx]}
testcase	{0x62, 0xF4, 0x04, 0x06, 0x3B, 0x0A},	{ccmpbe{dfv=} ecx, [rdx]}
testcase	{0x62, 0xF4, 0x84, 0x06, 0x3B, 0x0A},	{ccmpbe{dfv=} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x04, 0x06, 0x3A, 0x0A},	{ccmpbe{dfv=} cl, [r26]}
testcase	{0x62, 0xDC, 0x05, 0x06, 0x3B, 0x0A},	{ccmpbe{dfv=} cx, [r26]}
testcase	{0x62, 0xDC, 0x04, 0x06, 0x3B, 0x0A},	{ccmpbe{dfv=} ecx, [r26]}
testcase	{0x62, 0xDC, 0x84, 0x06, 0x3B, 0x0A},	{ccmpbe{dfv=} rcx, [r26]}
testcase	{0x62, 0xF4, 0x04, 0x06, 0x80, 0x3A, 0x05},	{ccmpbe{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x06, 0x81, 0x3A, 0x05, 0x00},	{ccmpbe{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x06, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpbe{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x06, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpbe{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x06, 0x80, 0x3A, 0x05},	{ccmpbe{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x06, 0x81, 0x3A, 0x05, 0x00},	{ccmpbe{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x06, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpbe{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x06, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpbe{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x05, 0x06, 0x83, 0x3A, 0x05},	{ccmpbe{dfv=} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x04, 0x06, 0x83, 0x3A, 0x05},	{ccmpbe{dfv=} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x84, 0x06, 0x83, 0x3A, 0x05},	{ccmpbe{dfv=} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x06, 0x83, 0x3A, 0x05},	{ccmpbe{dfv=} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x04, 0x06, 0x83, 0x3A, 0x05},	{ccmpbe{dfv=} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x84, 0x06, 0x83, 0x3A, 0x05},	{ccmpbe{dfv=} qword [r26], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x06, 0x38, 0x0A},	{ccmpbe{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x06, 0x39, 0x0A},	{ccmpbe{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x06, 0x39, 0x0A},	{ccmpbe{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x06, 0x39, 0x0A},	{ccmpbe{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x06, 0x38, 0x0A},	{ccmpbe{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x06, 0x39, 0x0A},	{ccmpbe{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x06, 0x39, 0x0A},	{ccmpbe{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x06, 0x39, 0x0A},	{ccmpbe{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x06, 0x3A, 0x0A},	{ccmpbe{dfv=cf,zf,sf,of} cl, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x06, 0x3B, 0x0A},	{ccmpbe{dfv=cf,zf,sf,of} cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x06, 0x3B, 0x0A},	{ccmpbe{dfv=cf,zf,sf,of} ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x06, 0x3B, 0x0A},	{ccmpbe{dfv=cf,zf,sf,of} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7C, 0x06, 0x3A, 0x0A},	{ccmpbe{dfv=cf,zf,sf,of} cl, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x06, 0x3B, 0x0A},	{ccmpbe{dfv=cf,zf,sf,of} cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x06, 0x3B, 0x0A},	{ccmpbe{dfv=cf,zf,sf,of} ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x06, 0x3B, 0x0A},	{ccmpbe{dfv=cf,zf,sf,of} rcx, [r26]}
testcase	{0x62, 0xF4, 0x7C, 0x06, 0x80, 0x3A, 0x05},	{ccmpbe{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x06, 0x81, 0x3A, 0x05, 0x00},	{ccmpbe{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x06, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpbe{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x06, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpbe{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x06, 0x80, 0x3A, 0x05},	{ccmpbe{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x06, 0x81, 0x3A, 0x05, 0x00},	{ccmpbe{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x06, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpbe{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x06, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpbe{dfv=cf,zf,sf,of} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x06, 0x83, 0x3A, 0x05},	{ccmpbe{dfv=cf,zf,sf,of} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x06, 0x83, 0x3A, 0x05},	{ccmpbe{dfv=cf,zf,sf,of} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x06, 0x83, 0x3A, 0x05},	{ccmpbe{dfv=cf,zf,sf,of} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x06, 0x83, 0x3A, 0x05},	{ccmpbe{dfv=cf,zf,sf,of} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x06, 0x83, 0x3A, 0x05},	{ccmpbe{dfv=cf,zf,sf,of} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x06, 0x83, 0x3A, 0x05},	{ccmpbe{dfv=cf,zf,sf,of} qword [r26], byte 0x05}

; --- ccmpf instruction ---
testcase	{0x62, 0xF4, 0x04, 0x0B, 0x38, 0x0A},	{ccmpf{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x0B, 0x39, 0x0A},	{ccmpf{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x0B, 0x39, 0x0A},	{ccmpf{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x0B, 0x39, 0x0A},	{ccmpf{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x0B, 0x38, 0x0A},	{ccmpf{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x0B, 0x39, 0x0A},	{ccmpf{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x0B, 0x39, 0x0A},	{ccmpf{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x0B, 0x39, 0x0A},	{ccmpf{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x0B, 0x3A, 0x0A},	{ccmpf{dfv=} cl, [rdx]}
testcase	{0x62, 0xF4, 0x05, 0x0B, 0x3B, 0x0A},	{ccmpf{dfv=} cx, [rdx]}
testcase	{0x62, 0xF4, 0x04, 0x0B, 0x3B, 0x0A},	{ccmpf{dfv=} ecx, [rdx]}
testcase	{0x62, 0xF4, 0x84, 0x0B, 0x3B, 0x0A},	{ccmpf{dfv=} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x04, 0x0B, 0x3A, 0x0A},	{ccmpf{dfv=} cl, [r26]}
testcase	{0x62, 0xDC, 0x05, 0x0B, 0x3B, 0x0A},	{ccmpf{dfv=} cx, [r26]}
testcase	{0x62, 0xDC, 0x04, 0x0B, 0x3B, 0x0A},	{ccmpf{dfv=} ecx, [r26]}
testcase	{0x62, 0xDC, 0x84, 0x0B, 0x3B, 0x0A},	{ccmpf{dfv=} rcx, [r26]}
testcase	{0x62, 0xF4, 0x04, 0x0B, 0x80, 0x3A, 0x05},	{ccmpf{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x0B, 0x81, 0x3A, 0x05, 0x00},	{ccmpf{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x0B, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpf{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x0B, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpf{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0B, 0x80, 0x3A, 0x05},	{ccmpf{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x0B, 0x81, 0x3A, 0x05, 0x00},	{ccmpf{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0B, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpf{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x0B, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpf{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x05, 0x0B, 0x83, 0x3A, 0x05},	{ccmpf{dfv=} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x04, 0x0B, 0x83, 0x3A, 0x05},	{ccmpf{dfv=} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x84, 0x0B, 0x83, 0x3A, 0x05},	{ccmpf{dfv=} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x0B, 0x83, 0x3A, 0x05},	{ccmpf{dfv=} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0B, 0x83, 0x3A, 0x05},	{ccmpf{dfv=} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x84, 0x0B, 0x83, 0x3A, 0x05},	{ccmpf{dfv=} qword [r26], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0B, 0x38, 0x0A},	{ccmpf{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x0B, 0x39, 0x0A},	{ccmpf{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0B, 0x39, 0x0A},	{ccmpf{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0B, 0x39, 0x0A},	{ccmpf{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x0B, 0x38, 0x0A},	{ccmpf{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x0B, 0x39, 0x0A},	{ccmpf{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0B, 0x39, 0x0A},	{ccmpf{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0B, 0x39, 0x0A},	{ccmpf{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x0B, 0x3A, 0x0A},	{ccmpf{dfv=cf,zf,sf,of} cl, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0B, 0x3B, 0x0A},	{ccmpf{dfv=cf,zf,sf,of} cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x0B, 0x3B, 0x0A},	{ccmpf{dfv=cf,zf,sf,of} ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x0B, 0x3B, 0x0A},	{ccmpf{dfv=cf,zf,sf,of} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7C, 0x0B, 0x3A, 0x0A},	{ccmpf{dfv=cf,zf,sf,of} cl, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x0B, 0x3B, 0x0A},	{ccmpf{dfv=cf,zf,sf,of} cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x0B, 0x3B, 0x0A},	{ccmpf{dfv=cf,zf,sf,of} ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x0B, 0x3B, 0x0A},	{ccmpf{dfv=cf,zf,sf,of} rcx, [r26]}
testcase	{0x62, 0xF4, 0x7C, 0x0B, 0x80, 0x3A, 0x05},	{ccmpf{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x0B, 0x81, 0x3A, 0x05, 0x00},	{ccmpf{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0B, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpf{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x0B, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpf{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0B, 0x80, 0x3A, 0x05},	{ccmpf{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x0B, 0x81, 0x3A, 0x05, 0x00},	{ccmpf{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0B, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpf{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x0B, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpf{dfv=cf,zf,sf,of} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x0B, 0x83, 0x3A, 0x05},	{ccmpf{dfv=cf,zf,sf,of} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0B, 0x83, 0x3A, 0x05},	{ccmpf{dfv=cf,zf,sf,of} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x0B, 0x83, 0x3A, 0x05},	{ccmpf{dfv=cf,zf,sf,of} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x0B, 0x83, 0x3A, 0x05},	{ccmpf{dfv=cf,zf,sf,of} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0B, 0x83, 0x3A, 0x05},	{ccmpf{dfv=cf,zf,sf,of} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x0B, 0x83, 0x3A, 0x05},	{ccmpf{dfv=cf,zf,sf,of} qword [r26], byte 0x05}

; --- ccmpl instruction ---
testcase	{0x62, 0xF4, 0x04, 0x0C, 0x38, 0x0A},	{ccmpl{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x0C, 0x39, 0x0A},	{ccmpl{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x0C, 0x39, 0x0A},	{ccmpl{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x0C, 0x39, 0x0A},	{ccmpl{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x0C, 0x38, 0x0A},	{ccmpl{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x0C, 0x39, 0x0A},	{ccmpl{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x0C, 0x39, 0x0A},	{ccmpl{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x0C, 0x39, 0x0A},	{ccmpl{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x0C, 0x3A, 0x0A},	{ccmpl{dfv=} cl, [rdx]}
testcase	{0x62, 0xF4, 0x05, 0x0C, 0x3B, 0x0A},	{ccmpl{dfv=} cx, [rdx]}
testcase	{0x62, 0xF4, 0x04, 0x0C, 0x3B, 0x0A},	{ccmpl{dfv=} ecx, [rdx]}
testcase	{0x62, 0xF4, 0x84, 0x0C, 0x3B, 0x0A},	{ccmpl{dfv=} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x04, 0x0C, 0x3A, 0x0A},	{ccmpl{dfv=} cl, [r26]}
testcase	{0x62, 0xDC, 0x05, 0x0C, 0x3B, 0x0A},	{ccmpl{dfv=} cx, [r26]}
testcase	{0x62, 0xDC, 0x04, 0x0C, 0x3B, 0x0A},	{ccmpl{dfv=} ecx, [r26]}
testcase	{0x62, 0xDC, 0x84, 0x0C, 0x3B, 0x0A},	{ccmpl{dfv=} rcx, [r26]}
testcase	{0x62, 0xF4, 0x04, 0x0C, 0x80, 0x3A, 0x05},	{ccmpl{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x0C, 0x81, 0x3A, 0x05, 0x00},	{ccmpl{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x0C, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpl{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x0C, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpl{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0C, 0x80, 0x3A, 0x05},	{ccmpl{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x0C, 0x81, 0x3A, 0x05, 0x00},	{ccmpl{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0C, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpl{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x0C, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpl{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x05, 0x0C, 0x83, 0x3A, 0x05},	{ccmpl{dfv=} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x04, 0x0C, 0x83, 0x3A, 0x05},	{ccmpl{dfv=} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x84, 0x0C, 0x83, 0x3A, 0x05},	{ccmpl{dfv=} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x0C, 0x83, 0x3A, 0x05},	{ccmpl{dfv=} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0C, 0x83, 0x3A, 0x05},	{ccmpl{dfv=} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x84, 0x0C, 0x83, 0x3A, 0x05},	{ccmpl{dfv=} qword [r26], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x38, 0x0A},	{ccmpl{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x39, 0x0A},	{ccmpl{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x39, 0x0A},	{ccmpl{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x39, 0x0A},	{ccmpl{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x38, 0x0A},	{ccmpl{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x39, 0x0A},	{ccmpl{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x39, 0x0A},	{ccmpl{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x39, 0x0A},	{ccmpl{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x3A, 0x0A},	{ccmpl{dfv=cf,zf,sf,of} cl, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x3B, 0x0A},	{ccmpl{dfv=cf,zf,sf,of} cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x3B, 0x0A},	{ccmpl{dfv=cf,zf,sf,of} ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x3B, 0x0A},	{ccmpl{dfv=cf,zf,sf,of} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x3A, 0x0A},	{ccmpl{dfv=cf,zf,sf,of} cl, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x3B, 0x0A},	{ccmpl{dfv=cf,zf,sf,of} cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x3B, 0x0A},	{ccmpl{dfv=cf,zf,sf,of} ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x3B, 0x0A},	{ccmpl{dfv=cf,zf,sf,of} rcx, [r26]}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x80, 0x3A, 0x05},	{ccmpl{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x81, 0x3A, 0x05, 0x00},	{ccmpl{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpl{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpl{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x80, 0x3A, 0x05},	{ccmpl{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x81, 0x3A, 0x05, 0x00},	{ccmpl{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpl{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpl{dfv=cf,zf,sf,of} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x0C, 0x83, 0x3A, 0x05},	{ccmpl{dfv=cf,zf,sf,of} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0C, 0x83, 0x3A, 0x05},	{ccmpl{dfv=cf,zf,sf,of} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x0C, 0x83, 0x3A, 0x05},	{ccmpl{dfv=cf,zf,sf,of} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x0C, 0x83, 0x3A, 0x05},	{ccmpl{dfv=cf,zf,sf,of} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0C, 0x83, 0x3A, 0x05},	{ccmpl{dfv=cf,zf,sf,of} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x0C, 0x83, 0x3A, 0x05},	{ccmpl{dfv=cf,zf,sf,of} qword [r26], byte 0x05}

; --- ccmple instruction ---
testcase	{0x62, 0xF4, 0x04, 0x0E, 0x38, 0x0A},	{ccmple{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x0E, 0x39, 0x0A},	{ccmple{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x0E, 0x39, 0x0A},	{ccmple{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x0E, 0x39, 0x0A},	{ccmple{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x0E, 0x38, 0x0A},	{ccmple{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x0E, 0x39, 0x0A},	{ccmple{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x0E, 0x39, 0x0A},	{ccmple{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x0E, 0x39, 0x0A},	{ccmple{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x0E, 0x3A, 0x0A},	{ccmple{dfv=} cl, [rdx]}
testcase	{0x62, 0xF4, 0x05, 0x0E, 0x3B, 0x0A},	{ccmple{dfv=} cx, [rdx]}
testcase	{0x62, 0xF4, 0x04, 0x0E, 0x3B, 0x0A},	{ccmple{dfv=} ecx, [rdx]}
testcase	{0x62, 0xF4, 0x84, 0x0E, 0x3B, 0x0A},	{ccmple{dfv=} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x04, 0x0E, 0x3A, 0x0A},	{ccmple{dfv=} cl, [r26]}
testcase	{0x62, 0xDC, 0x05, 0x0E, 0x3B, 0x0A},	{ccmple{dfv=} cx, [r26]}
testcase	{0x62, 0xDC, 0x04, 0x0E, 0x3B, 0x0A},	{ccmple{dfv=} ecx, [r26]}
testcase	{0x62, 0xDC, 0x84, 0x0E, 0x3B, 0x0A},	{ccmple{dfv=} rcx, [r26]}
testcase	{0x62, 0xF4, 0x04, 0x0E, 0x80, 0x3A, 0x05},	{ccmple{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x0E, 0x81, 0x3A, 0x05, 0x00},	{ccmple{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x0E, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmple{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x0E, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmple{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0E, 0x80, 0x3A, 0x05},	{ccmple{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x0E, 0x81, 0x3A, 0x05, 0x00},	{ccmple{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0E, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmple{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x0E, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmple{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x05, 0x0E, 0x83, 0x3A, 0x05},	{ccmple{dfv=} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x04, 0x0E, 0x83, 0x3A, 0x05},	{ccmple{dfv=} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x84, 0x0E, 0x83, 0x3A, 0x05},	{ccmple{dfv=} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x0E, 0x83, 0x3A, 0x05},	{ccmple{dfv=} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0E, 0x83, 0x3A, 0x05},	{ccmple{dfv=} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x84, 0x0E, 0x83, 0x3A, 0x05},	{ccmple{dfv=} qword [r26], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0E, 0x38, 0x0A},	{ccmple{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x0E, 0x39, 0x0A},	{ccmple{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0E, 0x39, 0x0A},	{ccmple{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0E, 0x39, 0x0A},	{ccmple{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x0E, 0x38, 0x0A},	{ccmple{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x0E, 0x39, 0x0A},	{ccmple{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0E, 0x39, 0x0A},	{ccmple{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0E, 0x39, 0x0A},	{ccmple{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x0E, 0x3A, 0x0A},	{ccmple{dfv=cf,zf,sf,of} cl, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0E, 0x3B, 0x0A},	{ccmple{dfv=cf,zf,sf,of} cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x0E, 0x3B, 0x0A},	{ccmple{dfv=cf,zf,sf,of} ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x0E, 0x3B, 0x0A},	{ccmple{dfv=cf,zf,sf,of} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7C, 0x0E, 0x3A, 0x0A},	{ccmple{dfv=cf,zf,sf,of} cl, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x0E, 0x3B, 0x0A},	{ccmple{dfv=cf,zf,sf,of} cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x0E, 0x3B, 0x0A},	{ccmple{dfv=cf,zf,sf,of} ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x0E, 0x3B, 0x0A},	{ccmple{dfv=cf,zf,sf,of} rcx, [r26]}
testcase	{0x62, 0xF4, 0x7C, 0x0E, 0x80, 0x3A, 0x05},	{ccmple{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x0E, 0x81, 0x3A, 0x05, 0x00},	{ccmple{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0E, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmple{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x0E, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmple{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0E, 0x80, 0x3A, 0x05},	{ccmple{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x0E, 0x81, 0x3A, 0x05, 0x00},	{ccmple{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0E, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmple{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x0E, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmple{dfv=cf,zf,sf,of} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x0E, 0x83, 0x3A, 0x05},	{ccmple{dfv=cf,zf,sf,of} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0E, 0x83, 0x3A, 0x05},	{ccmple{dfv=cf,zf,sf,of} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x0E, 0x83, 0x3A, 0x05},	{ccmple{dfv=cf,zf,sf,of} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x0E, 0x83, 0x3A, 0x05},	{ccmple{dfv=cf,zf,sf,of} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0E, 0x83, 0x3A, 0x05},	{ccmple{dfv=cf,zf,sf,of} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x0E, 0x83, 0x3A, 0x05},	{ccmple{dfv=cf,zf,sf,of} qword [r26], byte 0x05}

; --- ccmpnb instruction ---
testcase	{0x62, 0xF4, 0x04, 0x03, 0x38, 0x0A},	{ccmpnb{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x03, 0x39, 0x0A},	{ccmpnb{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x03, 0x39, 0x0A},	{ccmpnb{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x03, 0x39, 0x0A},	{ccmpnb{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x03, 0x38, 0x0A},	{ccmpnb{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x03, 0x39, 0x0A},	{ccmpnb{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x03, 0x39, 0x0A},	{ccmpnb{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x03, 0x39, 0x0A},	{ccmpnb{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x03, 0x3A, 0x0A},	{ccmpnb{dfv=} cl, [rdx]}
testcase	{0x62, 0xF4, 0x05, 0x03, 0x3B, 0x0A},	{ccmpnb{dfv=} cx, [rdx]}
testcase	{0x62, 0xF4, 0x04, 0x03, 0x3B, 0x0A},	{ccmpnb{dfv=} ecx, [rdx]}
testcase	{0x62, 0xF4, 0x84, 0x03, 0x3B, 0x0A},	{ccmpnb{dfv=} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x04, 0x03, 0x3A, 0x0A},	{ccmpnb{dfv=} cl, [r26]}
testcase	{0x62, 0xDC, 0x05, 0x03, 0x3B, 0x0A},	{ccmpnb{dfv=} cx, [r26]}
testcase	{0x62, 0xDC, 0x04, 0x03, 0x3B, 0x0A},	{ccmpnb{dfv=} ecx, [r26]}
testcase	{0x62, 0xDC, 0x84, 0x03, 0x3B, 0x0A},	{ccmpnb{dfv=} rcx, [r26]}
testcase	{0x62, 0xF4, 0x04, 0x03, 0x80, 0x3A, 0x05},	{ccmpnb{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x03, 0x81, 0x3A, 0x05, 0x00},	{ccmpnb{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x03, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnb{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x03, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnb{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x03, 0x80, 0x3A, 0x05},	{ccmpnb{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x03, 0x81, 0x3A, 0x05, 0x00},	{ccmpnb{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x03, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnb{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x03, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnb{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x05, 0x03, 0x83, 0x3A, 0x05},	{ccmpnb{dfv=} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x04, 0x03, 0x83, 0x3A, 0x05},	{ccmpnb{dfv=} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x84, 0x03, 0x83, 0x3A, 0x05},	{ccmpnb{dfv=} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x03, 0x83, 0x3A, 0x05},	{ccmpnb{dfv=} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x04, 0x03, 0x83, 0x3A, 0x05},	{ccmpnb{dfv=} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x84, 0x03, 0x83, 0x3A, 0x05},	{ccmpnb{dfv=} qword [r26], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x03, 0x38, 0x0A},	{ccmpnb{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x03, 0x39, 0x0A},	{ccmpnb{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x03, 0x39, 0x0A},	{ccmpnb{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x03, 0x39, 0x0A},	{ccmpnb{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x03, 0x38, 0x0A},	{ccmpnb{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x03, 0x39, 0x0A},	{ccmpnb{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x03, 0x39, 0x0A},	{ccmpnb{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x03, 0x39, 0x0A},	{ccmpnb{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x03, 0x3A, 0x0A},	{ccmpnb{dfv=cf,zf,sf,of} cl, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x03, 0x3B, 0x0A},	{ccmpnb{dfv=cf,zf,sf,of} cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x03, 0x3B, 0x0A},	{ccmpnb{dfv=cf,zf,sf,of} ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x03, 0x3B, 0x0A},	{ccmpnb{dfv=cf,zf,sf,of} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7C, 0x03, 0x3A, 0x0A},	{ccmpnb{dfv=cf,zf,sf,of} cl, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x03, 0x3B, 0x0A},	{ccmpnb{dfv=cf,zf,sf,of} cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x03, 0x3B, 0x0A},	{ccmpnb{dfv=cf,zf,sf,of} ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x03, 0x3B, 0x0A},	{ccmpnb{dfv=cf,zf,sf,of} rcx, [r26]}
testcase	{0x62, 0xF4, 0x7C, 0x03, 0x80, 0x3A, 0x05},	{ccmpnb{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x03, 0x81, 0x3A, 0x05, 0x00},	{ccmpnb{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x03, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnb{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x03, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnb{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x03, 0x80, 0x3A, 0x05},	{ccmpnb{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x03, 0x81, 0x3A, 0x05, 0x00},	{ccmpnb{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x03, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnb{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x03, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnb{dfv=cf,zf,sf,of} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x03, 0x83, 0x3A, 0x05},	{ccmpnb{dfv=cf,zf,sf,of} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x03, 0x83, 0x3A, 0x05},	{ccmpnb{dfv=cf,zf,sf,of} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x03, 0x83, 0x3A, 0x05},	{ccmpnb{dfv=cf,zf,sf,of} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x03, 0x83, 0x3A, 0x05},	{ccmpnb{dfv=cf,zf,sf,of} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x03, 0x83, 0x3A, 0x05},	{ccmpnb{dfv=cf,zf,sf,of} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x03, 0x83, 0x3A, 0x05},	{ccmpnb{dfv=cf,zf,sf,of} qword [r26], byte 0x05}

; --- ccmpnbe instruction ---
testcase	{0x62, 0xF4, 0x04, 0x07, 0x38, 0x0A},	{ccmpnbe{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x07, 0x39, 0x0A},	{ccmpnbe{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x07, 0x39, 0x0A},	{ccmpnbe{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x07, 0x39, 0x0A},	{ccmpnbe{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x07, 0x38, 0x0A},	{ccmpnbe{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x07, 0x39, 0x0A},	{ccmpnbe{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x07, 0x39, 0x0A},	{ccmpnbe{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x07, 0x39, 0x0A},	{ccmpnbe{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x07, 0x3A, 0x0A},	{ccmpnbe{dfv=} cl, [rdx]}
testcase	{0x62, 0xF4, 0x05, 0x07, 0x3B, 0x0A},	{ccmpnbe{dfv=} cx, [rdx]}
testcase	{0x62, 0xF4, 0x04, 0x07, 0x3B, 0x0A},	{ccmpnbe{dfv=} ecx, [rdx]}
testcase	{0x62, 0xF4, 0x84, 0x07, 0x3B, 0x0A},	{ccmpnbe{dfv=} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x04, 0x07, 0x3A, 0x0A},	{ccmpnbe{dfv=} cl, [r26]}
testcase	{0x62, 0xDC, 0x05, 0x07, 0x3B, 0x0A},	{ccmpnbe{dfv=} cx, [r26]}
testcase	{0x62, 0xDC, 0x04, 0x07, 0x3B, 0x0A},	{ccmpnbe{dfv=} ecx, [r26]}
testcase	{0x62, 0xDC, 0x84, 0x07, 0x3B, 0x0A},	{ccmpnbe{dfv=} rcx, [r26]}
testcase	{0x62, 0xF4, 0x04, 0x07, 0x80, 0x3A, 0x05},	{ccmpnbe{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x07, 0x81, 0x3A, 0x05, 0x00},	{ccmpnbe{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x07, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnbe{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x07, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnbe{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x07, 0x80, 0x3A, 0x05},	{ccmpnbe{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x07, 0x81, 0x3A, 0x05, 0x00},	{ccmpnbe{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x07, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnbe{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x07, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnbe{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x05, 0x07, 0x83, 0x3A, 0x05},	{ccmpnbe{dfv=} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x04, 0x07, 0x83, 0x3A, 0x05},	{ccmpnbe{dfv=} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x84, 0x07, 0x83, 0x3A, 0x05},	{ccmpnbe{dfv=} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x07, 0x83, 0x3A, 0x05},	{ccmpnbe{dfv=} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x04, 0x07, 0x83, 0x3A, 0x05},	{ccmpnbe{dfv=} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x84, 0x07, 0x83, 0x3A, 0x05},	{ccmpnbe{dfv=} qword [r26], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x07, 0x38, 0x0A},	{ccmpnbe{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x07, 0x39, 0x0A},	{ccmpnbe{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x07, 0x39, 0x0A},	{ccmpnbe{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x07, 0x39, 0x0A},	{ccmpnbe{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x07, 0x38, 0x0A},	{ccmpnbe{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x07, 0x39, 0x0A},	{ccmpnbe{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x07, 0x39, 0x0A},	{ccmpnbe{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x07, 0x39, 0x0A},	{ccmpnbe{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x07, 0x3A, 0x0A},	{ccmpnbe{dfv=cf,zf,sf,of} cl, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x07, 0x3B, 0x0A},	{ccmpnbe{dfv=cf,zf,sf,of} cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x07, 0x3B, 0x0A},	{ccmpnbe{dfv=cf,zf,sf,of} ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x07, 0x3B, 0x0A},	{ccmpnbe{dfv=cf,zf,sf,of} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7C, 0x07, 0x3A, 0x0A},	{ccmpnbe{dfv=cf,zf,sf,of} cl, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x07, 0x3B, 0x0A},	{ccmpnbe{dfv=cf,zf,sf,of} cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x07, 0x3B, 0x0A},	{ccmpnbe{dfv=cf,zf,sf,of} ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x07, 0x3B, 0x0A},	{ccmpnbe{dfv=cf,zf,sf,of} rcx, [r26]}
testcase	{0x62, 0xF4, 0x7C, 0x07, 0x80, 0x3A, 0x05},	{ccmpnbe{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x07, 0x81, 0x3A, 0x05, 0x00},	{ccmpnbe{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x07, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnbe{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x07, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnbe{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x07, 0x80, 0x3A, 0x05},	{ccmpnbe{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x07, 0x81, 0x3A, 0x05, 0x00},	{ccmpnbe{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x07, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnbe{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x07, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnbe{dfv=cf,zf,sf,of} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x07, 0x83, 0x3A, 0x05},	{ccmpnbe{dfv=cf,zf,sf,of} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x07, 0x83, 0x3A, 0x05},	{ccmpnbe{dfv=cf,zf,sf,of} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x07, 0x83, 0x3A, 0x05},	{ccmpnbe{dfv=cf,zf,sf,of} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x07, 0x83, 0x3A, 0x05},	{ccmpnbe{dfv=cf,zf,sf,of} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x07, 0x83, 0x3A, 0x05},	{ccmpnbe{dfv=cf,zf,sf,of} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x07, 0x83, 0x3A, 0x05},	{ccmpnbe{dfv=cf,zf,sf,of} qword [r26], byte 0x05}

; --- ccmpnl instruction ---
testcase	{0x62, 0xF4, 0x04, 0x0D, 0x38, 0x0A},	{ccmpnl{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x0D, 0x39, 0x0A},	{ccmpnl{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x0D, 0x39, 0x0A},	{ccmpnl{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x0D, 0x39, 0x0A},	{ccmpnl{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x0D, 0x38, 0x0A},	{ccmpnl{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x0D, 0x39, 0x0A},	{ccmpnl{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x0D, 0x39, 0x0A},	{ccmpnl{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x0D, 0x39, 0x0A},	{ccmpnl{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x0D, 0x3A, 0x0A},	{ccmpnl{dfv=} cl, [rdx]}
testcase	{0x62, 0xF4, 0x05, 0x0D, 0x3B, 0x0A},	{ccmpnl{dfv=} cx, [rdx]}
testcase	{0x62, 0xF4, 0x04, 0x0D, 0x3B, 0x0A},	{ccmpnl{dfv=} ecx, [rdx]}
testcase	{0x62, 0xF4, 0x84, 0x0D, 0x3B, 0x0A},	{ccmpnl{dfv=} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x04, 0x0D, 0x3A, 0x0A},	{ccmpnl{dfv=} cl, [r26]}
testcase	{0x62, 0xDC, 0x05, 0x0D, 0x3B, 0x0A},	{ccmpnl{dfv=} cx, [r26]}
testcase	{0x62, 0xDC, 0x04, 0x0D, 0x3B, 0x0A},	{ccmpnl{dfv=} ecx, [r26]}
testcase	{0x62, 0xDC, 0x84, 0x0D, 0x3B, 0x0A},	{ccmpnl{dfv=} rcx, [r26]}
testcase	{0x62, 0xF4, 0x04, 0x0D, 0x80, 0x3A, 0x05},	{ccmpnl{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x0D, 0x81, 0x3A, 0x05, 0x00},	{ccmpnl{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x0D, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnl{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x0D, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnl{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0D, 0x80, 0x3A, 0x05},	{ccmpnl{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x0D, 0x81, 0x3A, 0x05, 0x00},	{ccmpnl{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0D, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnl{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x0D, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnl{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x05, 0x0D, 0x83, 0x3A, 0x05},	{ccmpnl{dfv=} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x04, 0x0D, 0x83, 0x3A, 0x05},	{ccmpnl{dfv=} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x84, 0x0D, 0x83, 0x3A, 0x05},	{ccmpnl{dfv=} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x0D, 0x83, 0x3A, 0x05},	{ccmpnl{dfv=} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0D, 0x83, 0x3A, 0x05},	{ccmpnl{dfv=} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x84, 0x0D, 0x83, 0x3A, 0x05},	{ccmpnl{dfv=} qword [r26], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0D, 0x38, 0x0A},	{ccmpnl{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x0D, 0x39, 0x0A},	{ccmpnl{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0D, 0x39, 0x0A},	{ccmpnl{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0D, 0x39, 0x0A},	{ccmpnl{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x0D, 0x38, 0x0A},	{ccmpnl{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x0D, 0x39, 0x0A},	{ccmpnl{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0D, 0x39, 0x0A},	{ccmpnl{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0D, 0x39, 0x0A},	{ccmpnl{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x0D, 0x3A, 0x0A},	{ccmpnl{dfv=cf,zf,sf,of} cl, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0D, 0x3B, 0x0A},	{ccmpnl{dfv=cf,zf,sf,of} cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x0D, 0x3B, 0x0A},	{ccmpnl{dfv=cf,zf,sf,of} ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x0D, 0x3B, 0x0A},	{ccmpnl{dfv=cf,zf,sf,of} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7C, 0x0D, 0x3A, 0x0A},	{ccmpnl{dfv=cf,zf,sf,of} cl, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x0D, 0x3B, 0x0A},	{ccmpnl{dfv=cf,zf,sf,of} cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x0D, 0x3B, 0x0A},	{ccmpnl{dfv=cf,zf,sf,of} ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x0D, 0x3B, 0x0A},	{ccmpnl{dfv=cf,zf,sf,of} rcx, [r26]}
testcase	{0x62, 0xF4, 0x7C, 0x0D, 0x80, 0x3A, 0x05},	{ccmpnl{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x0D, 0x81, 0x3A, 0x05, 0x00},	{ccmpnl{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0D, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnl{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x0D, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnl{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0D, 0x80, 0x3A, 0x05},	{ccmpnl{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x0D, 0x81, 0x3A, 0x05, 0x00},	{ccmpnl{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0D, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnl{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x0D, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnl{dfv=cf,zf,sf,of} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x0D, 0x83, 0x3A, 0x05},	{ccmpnl{dfv=cf,zf,sf,of} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0D, 0x83, 0x3A, 0x05},	{ccmpnl{dfv=cf,zf,sf,of} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x0D, 0x83, 0x3A, 0x05},	{ccmpnl{dfv=cf,zf,sf,of} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x0D, 0x83, 0x3A, 0x05},	{ccmpnl{dfv=cf,zf,sf,of} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0D, 0x83, 0x3A, 0x05},	{ccmpnl{dfv=cf,zf,sf,of} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x0D, 0x83, 0x3A, 0x05},	{ccmpnl{dfv=cf,zf,sf,of} qword [r26], byte 0x05}

; --- ccmpnle instruction ---
testcase	{0x62, 0xF4, 0x04, 0x0F, 0x38, 0x0A},	{ccmpnle{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x0F, 0x39, 0x0A},	{ccmpnle{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x0F, 0x39, 0x0A},	{ccmpnle{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x0F, 0x39, 0x0A},	{ccmpnle{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x0F, 0x38, 0x0A},	{ccmpnle{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x0F, 0x39, 0x0A},	{ccmpnle{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x0F, 0x39, 0x0A},	{ccmpnle{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x0F, 0x39, 0x0A},	{ccmpnle{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x0F, 0x3A, 0x0A},	{ccmpnle{dfv=} cl, [rdx]}
testcase	{0x62, 0xF4, 0x05, 0x0F, 0x3B, 0x0A},	{ccmpnle{dfv=} cx, [rdx]}
testcase	{0x62, 0xF4, 0x04, 0x0F, 0x3B, 0x0A},	{ccmpnle{dfv=} ecx, [rdx]}
testcase	{0x62, 0xF4, 0x84, 0x0F, 0x3B, 0x0A},	{ccmpnle{dfv=} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x04, 0x0F, 0x3A, 0x0A},	{ccmpnle{dfv=} cl, [r26]}
testcase	{0x62, 0xDC, 0x05, 0x0F, 0x3B, 0x0A},	{ccmpnle{dfv=} cx, [r26]}
testcase	{0x62, 0xDC, 0x04, 0x0F, 0x3B, 0x0A},	{ccmpnle{dfv=} ecx, [r26]}
testcase	{0x62, 0xDC, 0x84, 0x0F, 0x3B, 0x0A},	{ccmpnle{dfv=} rcx, [r26]}
testcase	{0x62, 0xF4, 0x04, 0x0F, 0x80, 0x3A, 0x05},	{ccmpnle{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x0F, 0x81, 0x3A, 0x05, 0x00},	{ccmpnle{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x0F, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnle{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x0F, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnle{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0F, 0x80, 0x3A, 0x05},	{ccmpnle{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x0F, 0x81, 0x3A, 0x05, 0x00},	{ccmpnle{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0F, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnle{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x0F, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnle{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x05, 0x0F, 0x83, 0x3A, 0x05},	{ccmpnle{dfv=} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x04, 0x0F, 0x83, 0x3A, 0x05},	{ccmpnle{dfv=} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x84, 0x0F, 0x83, 0x3A, 0x05},	{ccmpnle{dfv=} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x0F, 0x83, 0x3A, 0x05},	{ccmpnle{dfv=} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0F, 0x83, 0x3A, 0x05},	{ccmpnle{dfv=} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x84, 0x0F, 0x83, 0x3A, 0x05},	{ccmpnle{dfv=} qword [r26], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0F, 0x38, 0x0A},	{ccmpnle{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x0F, 0x39, 0x0A},	{ccmpnle{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0F, 0x39, 0x0A},	{ccmpnle{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0F, 0x39, 0x0A},	{ccmpnle{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x0F, 0x38, 0x0A},	{ccmpnle{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x0F, 0x39, 0x0A},	{ccmpnle{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0F, 0x39, 0x0A},	{ccmpnle{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0F, 0x39, 0x0A},	{ccmpnle{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x0F, 0x3A, 0x0A},	{ccmpnle{dfv=cf,zf,sf,of} cl, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0F, 0x3B, 0x0A},	{ccmpnle{dfv=cf,zf,sf,of} cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x0F, 0x3B, 0x0A},	{ccmpnle{dfv=cf,zf,sf,of} ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x0F, 0x3B, 0x0A},	{ccmpnle{dfv=cf,zf,sf,of} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7C, 0x0F, 0x3A, 0x0A},	{ccmpnle{dfv=cf,zf,sf,of} cl, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x0F, 0x3B, 0x0A},	{ccmpnle{dfv=cf,zf,sf,of} cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x0F, 0x3B, 0x0A},	{ccmpnle{dfv=cf,zf,sf,of} ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x0F, 0x3B, 0x0A},	{ccmpnle{dfv=cf,zf,sf,of} rcx, [r26]}
testcase	{0x62, 0xF4, 0x7C, 0x0F, 0x80, 0x3A, 0x05},	{ccmpnle{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x0F, 0x81, 0x3A, 0x05, 0x00},	{ccmpnle{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0F, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnle{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x0F, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnle{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0F, 0x80, 0x3A, 0x05},	{ccmpnle{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x0F, 0x81, 0x3A, 0x05, 0x00},	{ccmpnle{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0F, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnle{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x0F, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnle{dfv=cf,zf,sf,of} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x0F, 0x83, 0x3A, 0x05},	{ccmpnle{dfv=cf,zf,sf,of} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0F, 0x83, 0x3A, 0x05},	{ccmpnle{dfv=cf,zf,sf,of} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x0F, 0x83, 0x3A, 0x05},	{ccmpnle{dfv=cf,zf,sf,of} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x0F, 0x83, 0x3A, 0x05},	{ccmpnle{dfv=cf,zf,sf,of} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0F, 0x83, 0x3A, 0x05},	{ccmpnle{dfv=cf,zf,sf,of} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x0F, 0x83, 0x3A, 0x05},	{ccmpnle{dfv=cf,zf,sf,of} qword [r26], byte 0x05}

; --- ccmpno instruction ---
testcase	{0x62, 0xF4, 0x04, 0x01, 0x38, 0x0A},	{ccmpno{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x01, 0x39, 0x0A},	{ccmpno{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x01, 0x39, 0x0A},	{ccmpno{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x01, 0x39, 0x0A},	{ccmpno{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x01, 0x38, 0x0A},	{ccmpno{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x01, 0x39, 0x0A},	{ccmpno{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x01, 0x39, 0x0A},	{ccmpno{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x01, 0x39, 0x0A},	{ccmpno{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x01, 0x3A, 0x0A},	{ccmpno{dfv=} cl, [rdx]}
testcase	{0x62, 0xF4, 0x05, 0x01, 0x3B, 0x0A},	{ccmpno{dfv=} cx, [rdx]}
testcase	{0x62, 0xF4, 0x04, 0x01, 0x3B, 0x0A},	{ccmpno{dfv=} ecx, [rdx]}
testcase	{0x62, 0xF4, 0x84, 0x01, 0x3B, 0x0A},	{ccmpno{dfv=} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x04, 0x01, 0x3A, 0x0A},	{ccmpno{dfv=} cl, [r26]}
testcase	{0x62, 0xDC, 0x05, 0x01, 0x3B, 0x0A},	{ccmpno{dfv=} cx, [r26]}
testcase	{0x62, 0xDC, 0x04, 0x01, 0x3B, 0x0A},	{ccmpno{dfv=} ecx, [r26]}
testcase	{0x62, 0xDC, 0x84, 0x01, 0x3B, 0x0A},	{ccmpno{dfv=} rcx, [r26]}
testcase	{0x62, 0xF4, 0x04, 0x01, 0x80, 0x3A, 0x05},	{ccmpno{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x01, 0x81, 0x3A, 0x05, 0x00},	{ccmpno{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x01, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpno{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x01, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpno{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x01, 0x80, 0x3A, 0x05},	{ccmpno{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x01, 0x81, 0x3A, 0x05, 0x00},	{ccmpno{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x01, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpno{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x01, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpno{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x05, 0x01, 0x83, 0x3A, 0x05},	{ccmpno{dfv=} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x04, 0x01, 0x83, 0x3A, 0x05},	{ccmpno{dfv=} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x84, 0x01, 0x83, 0x3A, 0x05},	{ccmpno{dfv=} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x01, 0x83, 0x3A, 0x05},	{ccmpno{dfv=} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x04, 0x01, 0x83, 0x3A, 0x05},	{ccmpno{dfv=} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x84, 0x01, 0x83, 0x3A, 0x05},	{ccmpno{dfv=} qword [r26], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x01, 0x38, 0x0A},	{ccmpno{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x01, 0x39, 0x0A},	{ccmpno{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x01, 0x39, 0x0A},	{ccmpno{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x01, 0x39, 0x0A},	{ccmpno{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x01, 0x38, 0x0A},	{ccmpno{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x01, 0x39, 0x0A},	{ccmpno{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x01, 0x39, 0x0A},	{ccmpno{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x01, 0x39, 0x0A},	{ccmpno{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x01, 0x3A, 0x0A},	{ccmpno{dfv=cf,zf,sf,of} cl, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x01, 0x3B, 0x0A},	{ccmpno{dfv=cf,zf,sf,of} cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x01, 0x3B, 0x0A},	{ccmpno{dfv=cf,zf,sf,of} ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x01, 0x3B, 0x0A},	{ccmpno{dfv=cf,zf,sf,of} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7C, 0x01, 0x3A, 0x0A},	{ccmpno{dfv=cf,zf,sf,of} cl, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x01, 0x3B, 0x0A},	{ccmpno{dfv=cf,zf,sf,of} cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x01, 0x3B, 0x0A},	{ccmpno{dfv=cf,zf,sf,of} ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x01, 0x3B, 0x0A},	{ccmpno{dfv=cf,zf,sf,of} rcx, [r26]}
testcase	{0x62, 0xF4, 0x7C, 0x01, 0x80, 0x3A, 0x05},	{ccmpno{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x01, 0x81, 0x3A, 0x05, 0x00},	{ccmpno{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x01, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpno{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x01, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpno{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x01, 0x80, 0x3A, 0x05},	{ccmpno{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x01, 0x81, 0x3A, 0x05, 0x00},	{ccmpno{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x01, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpno{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x01, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpno{dfv=cf,zf,sf,of} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x01, 0x83, 0x3A, 0x05},	{ccmpno{dfv=cf,zf,sf,of} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x01, 0x83, 0x3A, 0x05},	{ccmpno{dfv=cf,zf,sf,of} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x01, 0x83, 0x3A, 0x05},	{ccmpno{dfv=cf,zf,sf,of} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x01, 0x83, 0x3A, 0x05},	{ccmpno{dfv=cf,zf,sf,of} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x01, 0x83, 0x3A, 0x05},	{ccmpno{dfv=cf,zf,sf,of} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x01, 0x83, 0x3A, 0x05},	{ccmpno{dfv=cf,zf,sf,of} qword [r26], byte 0x05}

; --- ccmpns instruction ---
testcase	{0x62, 0xF4, 0x04, 0x09, 0x38, 0x0A},	{ccmpns{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x09, 0x39, 0x0A},	{ccmpns{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x09, 0x39, 0x0A},	{ccmpns{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x09, 0x39, 0x0A},	{ccmpns{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x09, 0x38, 0x0A},	{ccmpns{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x09, 0x39, 0x0A},	{ccmpns{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x09, 0x39, 0x0A},	{ccmpns{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x09, 0x39, 0x0A},	{ccmpns{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x09, 0x3A, 0x0A},	{ccmpns{dfv=} cl, [rdx]}
testcase	{0x62, 0xF4, 0x05, 0x09, 0x3B, 0x0A},	{ccmpns{dfv=} cx, [rdx]}
testcase	{0x62, 0xF4, 0x04, 0x09, 0x3B, 0x0A},	{ccmpns{dfv=} ecx, [rdx]}
testcase	{0x62, 0xF4, 0x84, 0x09, 0x3B, 0x0A},	{ccmpns{dfv=} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x04, 0x09, 0x3A, 0x0A},	{ccmpns{dfv=} cl, [r26]}
testcase	{0x62, 0xDC, 0x05, 0x09, 0x3B, 0x0A},	{ccmpns{dfv=} cx, [r26]}
testcase	{0x62, 0xDC, 0x04, 0x09, 0x3B, 0x0A},	{ccmpns{dfv=} ecx, [r26]}
testcase	{0x62, 0xDC, 0x84, 0x09, 0x3B, 0x0A},	{ccmpns{dfv=} rcx, [r26]}
testcase	{0x62, 0xF4, 0x04, 0x09, 0x80, 0x3A, 0x05},	{ccmpns{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x09, 0x81, 0x3A, 0x05, 0x00},	{ccmpns{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x09, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpns{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x09, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpns{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x09, 0x80, 0x3A, 0x05},	{ccmpns{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x09, 0x81, 0x3A, 0x05, 0x00},	{ccmpns{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x09, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpns{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x09, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpns{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x05, 0x09, 0x83, 0x3A, 0x05},	{ccmpns{dfv=} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x04, 0x09, 0x83, 0x3A, 0x05},	{ccmpns{dfv=} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x84, 0x09, 0x83, 0x3A, 0x05},	{ccmpns{dfv=} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x09, 0x83, 0x3A, 0x05},	{ccmpns{dfv=} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x04, 0x09, 0x83, 0x3A, 0x05},	{ccmpns{dfv=} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x84, 0x09, 0x83, 0x3A, 0x05},	{ccmpns{dfv=} qword [r26], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x09, 0x38, 0x0A},	{ccmpns{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x09, 0x39, 0x0A},	{ccmpns{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x09, 0x39, 0x0A},	{ccmpns{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x09, 0x39, 0x0A},	{ccmpns{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x09, 0x38, 0x0A},	{ccmpns{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x09, 0x39, 0x0A},	{ccmpns{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x09, 0x39, 0x0A},	{ccmpns{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x09, 0x39, 0x0A},	{ccmpns{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x09, 0x3A, 0x0A},	{ccmpns{dfv=cf,zf,sf,of} cl, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x09, 0x3B, 0x0A},	{ccmpns{dfv=cf,zf,sf,of} cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x09, 0x3B, 0x0A},	{ccmpns{dfv=cf,zf,sf,of} ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x09, 0x3B, 0x0A},	{ccmpns{dfv=cf,zf,sf,of} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7C, 0x09, 0x3A, 0x0A},	{ccmpns{dfv=cf,zf,sf,of} cl, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x09, 0x3B, 0x0A},	{ccmpns{dfv=cf,zf,sf,of} cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x09, 0x3B, 0x0A},	{ccmpns{dfv=cf,zf,sf,of} ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x09, 0x3B, 0x0A},	{ccmpns{dfv=cf,zf,sf,of} rcx, [r26]}
testcase	{0x62, 0xF4, 0x7C, 0x09, 0x80, 0x3A, 0x05},	{ccmpns{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x09, 0x81, 0x3A, 0x05, 0x00},	{ccmpns{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x09, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpns{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x09, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpns{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x09, 0x80, 0x3A, 0x05},	{ccmpns{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x09, 0x81, 0x3A, 0x05, 0x00},	{ccmpns{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x09, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpns{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x09, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpns{dfv=cf,zf,sf,of} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x09, 0x83, 0x3A, 0x05},	{ccmpns{dfv=cf,zf,sf,of} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x09, 0x83, 0x3A, 0x05},	{ccmpns{dfv=cf,zf,sf,of} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x09, 0x83, 0x3A, 0x05},	{ccmpns{dfv=cf,zf,sf,of} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x09, 0x83, 0x3A, 0x05},	{ccmpns{dfv=cf,zf,sf,of} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x09, 0x83, 0x3A, 0x05},	{ccmpns{dfv=cf,zf,sf,of} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x09, 0x83, 0x3A, 0x05},	{ccmpns{dfv=cf,zf,sf,of} qword [r26], byte 0x05}

; --- ccmpnz instruction ---
testcase	{0x62, 0xF4, 0x04, 0x05, 0x38, 0x0A},	{ccmpnz{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x05, 0x39, 0x0A},	{ccmpnz{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x05, 0x39, 0x0A},	{ccmpnz{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x05, 0x39, 0x0A},	{ccmpnz{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x05, 0x38, 0x0A},	{ccmpnz{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x05, 0x39, 0x0A},	{ccmpnz{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x05, 0x39, 0x0A},	{ccmpnz{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x05, 0x39, 0x0A},	{ccmpnz{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x05, 0x3A, 0x0A},	{ccmpnz{dfv=} cl, [rdx]}
testcase	{0x62, 0xF4, 0x05, 0x05, 0x3B, 0x0A},	{ccmpnz{dfv=} cx, [rdx]}
testcase	{0x62, 0xF4, 0x04, 0x05, 0x3B, 0x0A},	{ccmpnz{dfv=} ecx, [rdx]}
testcase	{0x62, 0xF4, 0x84, 0x05, 0x3B, 0x0A},	{ccmpnz{dfv=} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x04, 0x05, 0x3A, 0x0A},	{ccmpnz{dfv=} cl, [r26]}
testcase	{0x62, 0xDC, 0x05, 0x05, 0x3B, 0x0A},	{ccmpnz{dfv=} cx, [r26]}
testcase	{0x62, 0xDC, 0x04, 0x05, 0x3B, 0x0A},	{ccmpnz{dfv=} ecx, [r26]}
testcase	{0x62, 0xDC, 0x84, 0x05, 0x3B, 0x0A},	{ccmpnz{dfv=} rcx, [r26]}
testcase	{0x62, 0xF4, 0x04, 0x05, 0x80, 0x3A, 0x05},	{ccmpnz{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x05, 0x81, 0x3A, 0x05, 0x00},	{ccmpnz{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x05, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnz{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x05, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnz{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x05, 0x80, 0x3A, 0x05},	{ccmpnz{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x05, 0x81, 0x3A, 0x05, 0x00},	{ccmpnz{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x05, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnz{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x05, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnz{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x05, 0x05, 0x83, 0x3A, 0x05},	{ccmpnz{dfv=} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x04, 0x05, 0x83, 0x3A, 0x05},	{ccmpnz{dfv=} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x84, 0x05, 0x83, 0x3A, 0x05},	{ccmpnz{dfv=} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x05, 0x83, 0x3A, 0x05},	{ccmpnz{dfv=} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x04, 0x05, 0x83, 0x3A, 0x05},	{ccmpnz{dfv=} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x84, 0x05, 0x83, 0x3A, 0x05},	{ccmpnz{dfv=} qword [r26], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x05, 0x38, 0x0A},	{ccmpnz{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x05, 0x39, 0x0A},	{ccmpnz{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x05, 0x39, 0x0A},	{ccmpnz{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x05, 0x39, 0x0A},	{ccmpnz{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x05, 0x38, 0x0A},	{ccmpnz{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x05, 0x39, 0x0A},	{ccmpnz{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x05, 0x39, 0x0A},	{ccmpnz{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x05, 0x39, 0x0A},	{ccmpnz{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x05, 0x3A, 0x0A},	{ccmpnz{dfv=cf,zf,sf,of} cl, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x05, 0x3B, 0x0A},	{ccmpnz{dfv=cf,zf,sf,of} cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x05, 0x3B, 0x0A},	{ccmpnz{dfv=cf,zf,sf,of} ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x05, 0x3B, 0x0A},	{ccmpnz{dfv=cf,zf,sf,of} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7C, 0x05, 0x3A, 0x0A},	{ccmpnz{dfv=cf,zf,sf,of} cl, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x05, 0x3B, 0x0A},	{ccmpnz{dfv=cf,zf,sf,of} cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x05, 0x3B, 0x0A},	{ccmpnz{dfv=cf,zf,sf,of} ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x05, 0x3B, 0x0A},	{ccmpnz{dfv=cf,zf,sf,of} rcx, [r26]}
testcase	{0x62, 0xF4, 0x7C, 0x05, 0x80, 0x3A, 0x05},	{ccmpnz{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x05, 0x81, 0x3A, 0x05, 0x00},	{ccmpnz{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x05, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnz{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x05, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnz{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x05, 0x80, 0x3A, 0x05},	{ccmpnz{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x05, 0x81, 0x3A, 0x05, 0x00},	{ccmpnz{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x05, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnz{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x05, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpnz{dfv=cf,zf,sf,of} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x05, 0x83, 0x3A, 0x05},	{ccmpnz{dfv=cf,zf,sf,of} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x05, 0x83, 0x3A, 0x05},	{ccmpnz{dfv=cf,zf,sf,of} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x05, 0x83, 0x3A, 0x05},	{ccmpnz{dfv=cf,zf,sf,of} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x05, 0x83, 0x3A, 0x05},	{ccmpnz{dfv=cf,zf,sf,of} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x05, 0x83, 0x3A, 0x05},	{ccmpnz{dfv=cf,zf,sf,of} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x05, 0x83, 0x3A, 0x05},	{ccmpnz{dfv=cf,zf,sf,of} qword [r26], byte 0x05}

; --- ccmpo instruction ---
testcase	{0x62, 0xF4, 0x04, 0x00, 0x38, 0x0A},	{ccmpo{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x00, 0x39, 0x0A},	{ccmpo{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x00, 0x39, 0x0A},	{ccmpo{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x00, 0x39, 0x0A},	{ccmpo{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x00, 0x38, 0x0A},	{ccmpo{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x00, 0x39, 0x0A},	{ccmpo{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x00, 0x39, 0x0A},	{ccmpo{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x00, 0x39, 0x0A},	{ccmpo{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x00, 0x3A, 0x0A},	{ccmpo{dfv=} cl, [rdx]}
testcase	{0x62, 0xF4, 0x05, 0x00, 0x3B, 0x0A},	{ccmpo{dfv=} cx, [rdx]}
testcase	{0x62, 0xF4, 0x04, 0x00, 0x3B, 0x0A},	{ccmpo{dfv=} ecx, [rdx]}
testcase	{0x62, 0xF4, 0x84, 0x00, 0x3B, 0x0A},	{ccmpo{dfv=} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x04, 0x00, 0x3A, 0x0A},	{ccmpo{dfv=} cl, [r26]}
testcase	{0x62, 0xDC, 0x05, 0x00, 0x3B, 0x0A},	{ccmpo{dfv=} cx, [r26]}
testcase	{0x62, 0xDC, 0x04, 0x00, 0x3B, 0x0A},	{ccmpo{dfv=} ecx, [r26]}
testcase	{0x62, 0xDC, 0x84, 0x00, 0x3B, 0x0A},	{ccmpo{dfv=} rcx, [r26]}
testcase	{0x62, 0xF4, 0x04, 0x00, 0x80, 0x3A, 0x05},	{ccmpo{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x00, 0x81, 0x3A, 0x05, 0x00},	{ccmpo{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x00, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpo{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x00, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpo{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x00, 0x80, 0x3A, 0x05},	{ccmpo{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x00, 0x81, 0x3A, 0x05, 0x00},	{ccmpo{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x00, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpo{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x00, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpo{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x05, 0x00, 0x83, 0x3A, 0x05},	{ccmpo{dfv=} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x04, 0x00, 0x83, 0x3A, 0x05},	{ccmpo{dfv=} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x84, 0x00, 0x83, 0x3A, 0x05},	{ccmpo{dfv=} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x00, 0x83, 0x3A, 0x05},	{ccmpo{dfv=} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x04, 0x00, 0x83, 0x3A, 0x05},	{ccmpo{dfv=} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x84, 0x00, 0x83, 0x3A, 0x05},	{ccmpo{dfv=} qword [r26], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x00, 0x38, 0x0A},	{ccmpo{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x00, 0x39, 0x0A},	{ccmpo{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x00, 0x39, 0x0A},	{ccmpo{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x00, 0x39, 0x0A},	{ccmpo{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x00, 0x38, 0x0A},	{ccmpo{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x00, 0x39, 0x0A},	{ccmpo{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x00, 0x39, 0x0A},	{ccmpo{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x00, 0x39, 0x0A},	{ccmpo{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x00, 0x3A, 0x0A},	{ccmpo{dfv=cf,zf,sf,of} cl, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x00, 0x3B, 0x0A},	{ccmpo{dfv=cf,zf,sf,of} cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x00, 0x3B, 0x0A},	{ccmpo{dfv=cf,zf,sf,of} ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x00, 0x3B, 0x0A},	{ccmpo{dfv=cf,zf,sf,of} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7C, 0x00, 0x3A, 0x0A},	{ccmpo{dfv=cf,zf,sf,of} cl, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x00, 0x3B, 0x0A},	{ccmpo{dfv=cf,zf,sf,of} cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x00, 0x3B, 0x0A},	{ccmpo{dfv=cf,zf,sf,of} ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x00, 0x3B, 0x0A},	{ccmpo{dfv=cf,zf,sf,of} rcx, [r26]}
testcase	{0x62, 0xF4, 0x7C, 0x00, 0x80, 0x3A, 0x05},	{ccmpo{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x00, 0x81, 0x3A, 0x05, 0x00},	{ccmpo{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x00, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpo{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x00, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpo{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x00, 0x80, 0x3A, 0x05},	{ccmpo{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x00, 0x81, 0x3A, 0x05, 0x00},	{ccmpo{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x00, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpo{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x00, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpo{dfv=cf,zf,sf,of} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x00, 0x83, 0x3A, 0x05},	{ccmpo{dfv=cf,zf,sf,of} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x00, 0x83, 0x3A, 0x05},	{ccmpo{dfv=cf,zf,sf,of} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x00, 0x83, 0x3A, 0x05},	{ccmpo{dfv=cf,zf,sf,of} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x00, 0x83, 0x3A, 0x05},	{ccmpo{dfv=cf,zf,sf,of} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x00, 0x83, 0x3A, 0x05},	{ccmpo{dfv=cf,zf,sf,of} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x00, 0x83, 0x3A, 0x05},	{ccmpo{dfv=cf,zf,sf,of} qword [r26], byte 0x05}

; --- ccmps instruction ---
testcase	{0x62, 0xF4, 0x04, 0x08, 0x38, 0x0A},	{ccmps{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x08, 0x39, 0x0A},	{ccmps{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x08, 0x39, 0x0A},	{ccmps{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x08, 0x39, 0x0A},	{ccmps{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x08, 0x38, 0x0A},	{ccmps{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x08, 0x39, 0x0A},	{ccmps{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x08, 0x39, 0x0A},	{ccmps{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x08, 0x39, 0x0A},	{ccmps{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x08, 0x3A, 0x0A},	{ccmps{dfv=} cl, [rdx]}
testcase	{0x62, 0xF4, 0x05, 0x08, 0x3B, 0x0A},	{ccmps{dfv=} cx, [rdx]}
testcase	{0x62, 0xF4, 0x04, 0x08, 0x3B, 0x0A},	{ccmps{dfv=} ecx, [rdx]}
testcase	{0x62, 0xF4, 0x84, 0x08, 0x3B, 0x0A},	{ccmps{dfv=} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x04, 0x08, 0x3A, 0x0A},	{ccmps{dfv=} cl, [r26]}
testcase	{0x62, 0xDC, 0x05, 0x08, 0x3B, 0x0A},	{ccmps{dfv=} cx, [r26]}
testcase	{0x62, 0xDC, 0x04, 0x08, 0x3B, 0x0A},	{ccmps{dfv=} ecx, [r26]}
testcase	{0x62, 0xDC, 0x84, 0x08, 0x3B, 0x0A},	{ccmps{dfv=} rcx, [r26]}
testcase	{0x62, 0xF4, 0x04, 0x08, 0x80, 0x3A, 0x05},	{ccmps{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x08, 0x81, 0x3A, 0x05, 0x00},	{ccmps{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x08, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmps{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x08, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmps{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x08, 0x80, 0x3A, 0x05},	{ccmps{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x08, 0x81, 0x3A, 0x05, 0x00},	{ccmps{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x08, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmps{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x08, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmps{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x05, 0x08, 0x83, 0x3A, 0x05},	{ccmps{dfv=} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x04, 0x08, 0x83, 0x3A, 0x05},	{ccmps{dfv=} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x84, 0x08, 0x83, 0x3A, 0x05},	{ccmps{dfv=} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x08, 0x83, 0x3A, 0x05},	{ccmps{dfv=} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x04, 0x08, 0x83, 0x3A, 0x05},	{ccmps{dfv=} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x84, 0x08, 0x83, 0x3A, 0x05},	{ccmps{dfv=} qword [r26], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x38, 0x0A},	{ccmps{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x39, 0x0A},	{ccmps{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x39, 0x0A},	{ccmps{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x39, 0x0A},	{ccmps{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x38, 0x0A},	{ccmps{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x08, 0x39, 0x0A},	{ccmps{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x39, 0x0A},	{ccmps{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0x39, 0x0A},	{ccmps{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x3A, 0x0A},	{ccmps{dfv=cf,zf,sf,of} cl, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x3B, 0x0A},	{ccmps{dfv=cf,zf,sf,of} cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x3B, 0x0A},	{ccmps{dfv=cf,zf,sf,of} ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x3B, 0x0A},	{ccmps{dfv=cf,zf,sf,of} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x3A, 0x0A},	{ccmps{dfv=cf,zf,sf,of} cl, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x08, 0x3B, 0x0A},	{ccmps{dfv=cf,zf,sf,of} cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x3B, 0x0A},	{ccmps{dfv=cf,zf,sf,of} ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0x3B, 0x0A},	{ccmps{dfv=cf,zf,sf,of} rcx, [r26]}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x80, 0x3A, 0x05},	{ccmps{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x81, 0x3A, 0x05, 0x00},	{ccmps{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmps{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmps{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x80, 0x3A, 0x05},	{ccmps{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x08, 0x81, 0x3A, 0x05, 0x00},	{ccmps{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmps{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmps{dfv=cf,zf,sf,of} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x08, 0x83, 0x3A, 0x05},	{ccmps{dfv=cf,zf,sf,of} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x08, 0x83, 0x3A, 0x05},	{ccmps{dfv=cf,zf,sf,of} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x08, 0x83, 0x3A, 0x05},	{ccmps{dfv=cf,zf,sf,of} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x08, 0x83, 0x3A, 0x05},	{ccmps{dfv=cf,zf,sf,of} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x08, 0x83, 0x3A, 0x05},	{ccmps{dfv=cf,zf,sf,of} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x08, 0x83, 0x3A, 0x05},	{ccmps{dfv=cf,zf,sf,of} qword [r26], byte 0x05}

; --- ccmpt instruction ---
testcase	{0x62, 0xF4, 0x04, 0x0A, 0x38, 0x0A},	{ccmpt{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x0A, 0x39, 0x0A},	{ccmpt{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x0A, 0x39, 0x0A},	{ccmpt{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x0A, 0x39, 0x0A},	{ccmpt{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x0A, 0x38, 0x0A},	{ccmpt{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x0A, 0x39, 0x0A},	{ccmpt{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x0A, 0x39, 0x0A},	{ccmpt{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x0A, 0x39, 0x0A},	{ccmpt{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x0A, 0x3A, 0x0A},	{ccmpt{dfv=} cl, [rdx]}
testcase	{0x62, 0xF4, 0x05, 0x0A, 0x3B, 0x0A},	{ccmpt{dfv=} cx, [rdx]}
testcase	{0x62, 0xF4, 0x04, 0x0A, 0x3B, 0x0A},	{ccmpt{dfv=} ecx, [rdx]}
testcase	{0x62, 0xF4, 0x84, 0x0A, 0x3B, 0x0A},	{ccmpt{dfv=} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x04, 0x0A, 0x3A, 0x0A},	{ccmpt{dfv=} cl, [r26]}
testcase	{0x62, 0xDC, 0x05, 0x0A, 0x3B, 0x0A},	{ccmpt{dfv=} cx, [r26]}
testcase	{0x62, 0xDC, 0x04, 0x0A, 0x3B, 0x0A},	{ccmpt{dfv=} ecx, [r26]}
testcase	{0x62, 0xDC, 0x84, 0x0A, 0x3B, 0x0A},	{ccmpt{dfv=} rcx, [r26]}
testcase	{0x62, 0xF4, 0x04, 0x0A, 0x80, 0x3A, 0x05},	{ccmpt{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x0A, 0x81, 0x3A, 0x05, 0x00},	{ccmpt{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x0A, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpt{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x0A, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpt{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0A, 0x80, 0x3A, 0x05},	{ccmpt{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x0A, 0x81, 0x3A, 0x05, 0x00},	{ccmpt{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0A, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpt{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x0A, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpt{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x05, 0x0A, 0x83, 0x3A, 0x05},	{ccmpt{dfv=} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x04, 0x0A, 0x83, 0x3A, 0x05},	{ccmpt{dfv=} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x84, 0x0A, 0x83, 0x3A, 0x05},	{ccmpt{dfv=} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x0A, 0x83, 0x3A, 0x05},	{ccmpt{dfv=} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x04, 0x0A, 0x83, 0x3A, 0x05},	{ccmpt{dfv=} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x84, 0x0A, 0x83, 0x3A, 0x05},	{ccmpt{dfv=} qword [r26], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0A, 0x38, 0x0A},	{ccmpt{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x0A, 0x39, 0x0A},	{ccmpt{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x0A, 0x39, 0x0A},	{ccmpt{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x0A, 0x39, 0x0A},	{ccmpt{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x0A, 0x38, 0x0A},	{ccmpt{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x0A, 0x39, 0x0A},	{ccmpt{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x0A, 0x39, 0x0A},	{ccmpt{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x0A, 0x39, 0x0A},	{ccmpt{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x0A, 0x3A, 0x0A},	{ccmpt{dfv=cf,zf,sf,of} cl, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x0A, 0x3B, 0x0A},	{ccmpt{dfv=cf,zf,sf,of} cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x0A, 0x3B, 0x0A},	{ccmpt{dfv=cf,zf,sf,of} ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x0A, 0x3B, 0x0A},	{ccmpt{dfv=cf,zf,sf,of} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7C, 0x0A, 0x3A, 0x0A},	{ccmpt{dfv=cf,zf,sf,of} cl, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x0A, 0x3B, 0x0A},	{ccmpt{dfv=cf,zf,sf,of} cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x0A, 0x3B, 0x0A},	{ccmpt{dfv=cf,zf,sf,of} ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x0A, 0x3B, 0x0A},	{ccmpt{dfv=cf,zf,sf,of} rcx, [r26]}
testcase	{0x62, 0xF4, 0x7C, 0x0A, 0x80, 0x3A, 0x05},	{ccmpt{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x0A, 0x81, 0x3A, 0x05, 0x00},	{ccmpt{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0A, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpt{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x0A, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpt{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0A, 0x80, 0x3A, 0x05},	{ccmpt{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x0A, 0x81, 0x3A, 0x05, 0x00},	{ccmpt{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0A, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpt{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x0A, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpt{dfv=cf,zf,sf,of} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x0A, 0x83, 0x3A, 0x05},	{ccmpt{dfv=cf,zf,sf,of} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x0A, 0x83, 0x3A, 0x05},	{ccmpt{dfv=cf,zf,sf,of} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x0A, 0x83, 0x3A, 0x05},	{ccmpt{dfv=cf,zf,sf,of} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x0A, 0x83, 0x3A, 0x05},	{ccmpt{dfv=cf,zf,sf,of} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x0A, 0x83, 0x3A, 0x05},	{ccmpt{dfv=cf,zf,sf,of} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x0A, 0x83, 0x3A, 0x05},	{ccmpt{dfv=cf,zf,sf,of} qword [r26], byte 0x05}

; --- ccmpz instruction ---
testcase	{0x62, 0xF4, 0x04, 0x04, 0x38, 0x0A},	{ccmpz{dfv=} [rdx], cl}
testcase	{0x62, 0xF4, 0x05, 0x04, 0x39, 0x0A},	{ccmpz{dfv=} [rdx], cx}
testcase	{0x62, 0xF4, 0x04, 0x04, 0x39, 0x0A},	{ccmpz{dfv=} [rdx], ecx}
testcase	{0x62, 0xF4, 0x84, 0x04, 0x39, 0x0A},	{ccmpz{dfv=} [rdx], rcx}
testcase	{0x62, 0xDC, 0x04, 0x04, 0x38, 0x0A},	{ccmpz{dfv=} [r26], cl}
testcase	{0x62, 0xDC, 0x05, 0x04, 0x39, 0x0A},	{ccmpz{dfv=} [r26], cx}
testcase	{0x62, 0xDC, 0x04, 0x04, 0x39, 0x0A},	{ccmpz{dfv=} [r26], ecx}
testcase	{0x62, 0xDC, 0x84, 0x04, 0x39, 0x0A},	{ccmpz{dfv=} [r26], rcx}
testcase	{0x62, 0xF4, 0x04, 0x04, 0x3A, 0x0A},	{ccmpz{dfv=} cl, [rdx]}
testcase	{0x62, 0xF4, 0x05, 0x04, 0x3B, 0x0A},	{ccmpz{dfv=} cx, [rdx]}
testcase	{0x62, 0xF4, 0x04, 0x04, 0x3B, 0x0A},	{ccmpz{dfv=} ecx, [rdx]}
testcase	{0x62, 0xF4, 0x84, 0x04, 0x3B, 0x0A},	{ccmpz{dfv=} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x04, 0x04, 0x3A, 0x0A},	{ccmpz{dfv=} cl, [r26]}
testcase	{0x62, 0xDC, 0x05, 0x04, 0x3B, 0x0A},	{ccmpz{dfv=} cx, [r26]}
testcase	{0x62, 0xDC, 0x04, 0x04, 0x3B, 0x0A},	{ccmpz{dfv=} ecx, [r26]}
testcase	{0x62, 0xDC, 0x84, 0x04, 0x3B, 0x0A},	{ccmpz{dfv=} rcx, [r26]}
testcase	{0x62, 0xF4, 0x04, 0x04, 0x80, 0x3A, 0x05},	{ccmpz{dfv=} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x05, 0x04, 0x81, 0x3A, 0x05, 0x00},	{ccmpz{dfv=} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x04, 0x04, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpz{dfv=} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0x84, 0x04, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpz{dfv=} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x04, 0x04, 0x80, 0x3A, 0x05},	{ccmpz{dfv=} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x04, 0x81, 0x3A, 0x05, 0x00},	{ccmpz{dfv=} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x04, 0x04, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpz{dfv=} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0x84, 0x04, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpz{dfv=} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x05, 0x04, 0x83, 0x3A, 0x05},	{ccmpz{dfv=} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x04, 0x04, 0x83, 0x3A, 0x05},	{ccmpz{dfv=} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x84, 0x04, 0x83, 0x3A, 0x05},	{ccmpz{dfv=} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x05, 0x04, 0x83, 0x3A, 0x05},	{ccmpz{dfv=} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x04, 0x04, 0x83, 0x3A, 0x05},	{ccmpz{dfv=} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x84, 0x04, 0x83, 0x3A, 0x05},	{ccmpz{dfv=} qword [r26], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x04, 0x38, 0x0A},	{ccmpz{dfv=cf,zf,sf,of} [rdx], cl}
testcase	{0x62, 0xF4, 0x7D, 0x04, 0x39, 0x0A},	{ccmpz{dfv=cf,zf,sf,of} [rdx], cx}
testcase	{0x62, 0xF4, 0x7C, 0x04, 0x39, 0x0A},	{ccmpz{dfv=cf,zf,sf,of} [rdx], ecx}
testcase	{0x62, 0xF4, 0xFC, 0x04, 0x39, 0x0A},	{ccmpz{dfv=cf,zf,sf,of} [rdx], rcx}
testcase	{0x62, 0xDC, 0x7C, 0x04, 0x38, 0x0A},	{ccmpz{dfv=cf,zf,sf,of} [r26], cl}
testcase	{0x62, 0xDC, 0x7D, 0x04, 0x39, 0x0A},	{ccmpz{dfv=cf,zf,sf,of} [r26], cx}
testcase	{0x62, 0xDC, 0x7C, 0x04, 0x39, 0x0A},	{ccmpz{dfv=cf,zf,sf,of} [r26], ecx}
testcase	{0x62, 0xDC, 0xFC, 0x04, 0x39, 0x0A},	{ccmpz{dfv=cf,zf,sf,of} [r26], rcx}
testcase	{0x62, 0xF4, 0x7C, 0x04, 0x3A, 0x0A},	{ccmpz{dfv=cf,zf,sf,of} cl, [rdx]}
testcase	{0x62, 0xF4, 0x7D, 0x04, 0x3B, 0x0A},	{ccmpz{dfv=cf,zf,sf,of} cx, [rdx]}
testcase	{0x62, 0xF4, 0x7C, 0x04, 0x3B, 0x0A},	{ccmpz{dfv=cf,zf,sf,of} ecx, [rdx]}
testcase	{0x62, 0xF4, 0xFC, 0x04, 0x3B, 0x0A},	{ccmpz{dfv=cf,zf,sf,of} rcx, [rdx]}
testcase	{0x62, 0xDC, 0x7C, 0x04, 0x3A, 0x0A},	{ccmpz{dfv=cf,zf,sf,of} cl, [r26]}
testcase	{0x62, 0xDC, 0x7D, 0x04, 0x3B, 0x0A},	{ccmpz{dfv=cf,zf,sf,of} cx, [r26]}
testcase	{0x62, 0xDC, 0x7C, 0x04, 0x3B, 0x0A},	{ccmpz{dfv=cf,zf,sf,of} ecx, [r26]}
testcase	{0x62, 0xDC, 0xFC, 0x04, 0x3B, 0x0A},	{ccmpz{dfv=cf,zf,sf,of} rcx, [r26]}
testcase	{0x62, 0xF4, 0x7C, 0x04, 0x80, 0x3A, 0x05},	{ccmpz{dfv=cf,zf,sf,of} byte [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x04, 0x81, 0x3A, 0x05, 0x00},	{ccmpz{dfv=cf,zf,sf,of} word [rdx], word 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x04, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpz{dfv=cf,zf,sf,of} dword [rdx], dword 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x04, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpz{dfv=cf,zf,sf,of} qword [rdx], dword 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x04, 0x80, 0x3A, 0x05},	{ccmpz{dfv=cf,zf,sf,of} byte [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x04, 0x81, 0x3A, 0x05, 0x00},	{ccmpz{dfv=cf,zf,sf,of} word [r26], word 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x04, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpz{dfv=cf,zf,sf,of} dword [r26], dword 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x04, 0x81, 0x3A, 0x05, 0x00, 0x00, 0x00},	{ccmpz{dfv=cf,zf,sf,of} qword [r26], dword 0x05}
testcase	{0x62, 0xF4, 0x7D, 0x04, 0x83, 0x3A, 0x05},	{ccmpz{dfv=cf,zf,sf,of} word [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0x7C, 0x04, 0x83, 0x3A, 0x05},	{ccmpz{dfv=cf,zf,sf,of} dword [rdx], byte 0x05}
testcase	{0x62, 0xF4, 0xFC, 0x04, 0x83, 0x3A, 0x05},	{ccmpz{dfv=cf,zf,sf,of} qword [rdx], byte 0x05}
testcase	{0x62, 0xDC, 0x7D, 0x04, 0x83, 0x3A, 0x05},	{ccmpz{dfv=cf,zf,sf,of} word [r26], byte 0x05}
testcase	{0x62, 0xDC, 0x7C, 0x04, 0x83, 0x3A, 0x05},	{ccmpz{dfv=cf,zf,sf,of} dword [r26], byte 0x05}
testcase	{0x62, 0xDC, 0xFC, 0x04, 0x83, 0x3A, 0x05},	{ccmpz{dfv=cf,zf,sf,of} qword [r26], byte 0x05}

