/*
 * ircaux.h: header file for ircaux.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * @(#)$Id: ircaux.h,v 1.6 1994/07/02 02:38:10 mrg Exp $
 */

#ifndef _IRCAUX_H_
#define _IRCAUX_H_

#include "irc.h"
#include "irc_std.h"
#include <stdio.h>
#ifdef WANT_TCL
#undef USE_TCLALLOC
#include <tcl.h>
#endif

typedef int comp_len_func (char *, char *, int);
typedef int comp_func (char *, char *);

extern unsigned char stricmp_table[];


char *	check_nickname 		(char *);
char *	next_arg 		(char *, char **);
char *	new_next_arg 		(char *, char **);
char *	new_new_next_arg 	(char *, char **, char *);
char *	last_arg 		(char **);
char *	expand_twiddle 		(char *);
char *	upper 			(char *);
char *	lower 			(char *);
char *	sindex			(register char *, char *);
char *	rsindex 		(register char *, char *, char *, int);
char *	path_search 		(char *, char *);
char *	double_quote 		(const char *, const char *, char *);

char *	n_malloc_strcpy		(char **, const char *, const char *, const char *, const int);
char *	malloc_str2cpy		(char **, const char *, const char *);
char *	n_malloc_strcat 		(char **, const char *, const char *, const char *, const int);

char *	m_s3cat_s 		(char **, const char *, const char *);
char *	m_s3cat 		(char **, const char *, const char *);
char *	m_3cat 			(char **, const char *, const char *);
char *	m_e3cat 		(char **, const char *, const char *);
char *	m_2dup 			(const char *, const char *);
char *	m_3dup 			(const char *, const char *, const char *);
char *	m_opendup 		(const char *, ...);
char *	n_m_strdup 		(const char *, const char *, const char *, const int);
char *	malloc_sprintf 		(char **, const char *, ...);
char *	m_sprintf 		(const char *, ...);
int	is_number 		(const char *);
char *	my_ctime 		(time_t);

#ifdef __linux__
#define my_stricmp(x, y) strcasecmp(x, y)
#define my_strnicmp(x, y, n) strncasecmp(x, y, n)
#else
int	my_stricmp 		(const unsigned char *, unsigned const char *);
int	my_strnicmp 		(const unsigned char *, const unsigned char *, size_t);
#endif

int	my_strnstr 		(const unsigned char *, const unsigned char *, size_t);
int	scanstr 		(char *, char *);
void	really_free 		(int);
char *	chop 			(char *, int);
char *	strmcpy 		(char *, const char *, int);
char *	strmcat 		(char *, const char *, int);
char *	strmcat_ue 		(char *, const char *, int);
char *	n_m_strcat_ues 		(char **, char *, int, const char *, const char *, const int);
char *	stristr 		(const char *, const char *);
char *	rstristr 		(char *, char *);
FILE *	uzfopen 		(char **, char *, int);
int	end_strcmp 		(const char *, const char *, int);
void	ircpanic		(char *, ...) __A(1);

int	fw_strcmp 		(comp_len_func *, char *, char *);
int	lw_strcmp 		(comp_func *, char *, char *);
int	open_to 		(char *, int, off_t);
struct timeval get_time 	(struct timeval *);
double 	time_diff 		(struct timeval, struct timeval);
char *	plural 			(int);
int	time_to_next_minute 	(void);
 char *	remove_trailing_spaces 	(char *);
char *	ltoa			(long);
char *	strformat 		(char *, const char *, int, char);
char *	chop_word 		(char *);
int	splitw 			(char *, char ***);
char *	unsplitw 		(char ***, int);
int	check_val 		(char *);
 char *	strextend 		(char *, char, int);
char *	pullstr 		(char *, char *);
int 	empty 			(const char *);
char *	safe_new_next_arg 	(char *, char **);
char *	MatchingBracket 	(register char *, register char, register char);
int	word_count 		(char *);
int	parse_number 		(char **);
char *	remove_brackets 	(const char *, const char *, int *);
u_long	hashpjw 		(char *, u_long);
char *	m_dupchar 		(int);
char *	strmccat		(char *, char, int);
off_t	file_size		(char *);
int	is_root			(char *, char *, int);
size_t	streq			(const char *, const char *);
size_t	strieq			(const char *, const char *);
char *	n_m_strndup		(const char *, size_t, const char *, const char *, const int);
#ifndef HAVE_VSNPRINTF
	int	vsnprintf 		(char *, size_t, const char *, va_list);
#endif
#ifndef HAVE_SNPRINTF
	int	snprintf 		(char *, size_t, const char *, ...) __A(3);
#endif

char *	on_off (int);
char *	rfgets (char *, int, FILE *);
char *  strmopencat             (char *, int, ...);
long my_atol (char *);
char *s_next_arg (char **);
char *next_in_comma_list (char *, char **);
void	strip_control	(const char *, char *);
int	figure_out_address (char *, char **, char **, char **, char **, int *);
int	count_char		(const unsigned char *, const unsigned char);
char *	strnrchr		(char *, char, int);
void	mask_digits		(char **);
const char *strfill (char, int);
char *ov_strcpy (char *, const char *);
char *strpcat(char *, const char *, ...);
char *chomp(char *);
size_t ccspan(const char *, int);
u_char *strcpy_nocolorcodes   (u_char *, const u_char *);

u_long	random_number(u_long);
char	*get_userhost(void);


/* From words.c */
#define SOS -32767
#define EOS 32767
char	*search (register char *, char **, char *, int);
char	*move_to_abs_word (const register char *, char **, int);
char	*move_word_rel (const register char *, char **, int);
char	*extract (char *, int, int);
char	*extract2 (const char *, int, int);
int	match (register char *, register char *);
int	wild_match (register const unsigned char *, register const unsigned char *);

/* Used for connect_by_number */
#define SERVICE_SERVER 0
#define SERVICE_CLIENT 1
#define PROTOCOL_TCP 0
#define PROTOCOL_UDP 1

/* Used from network.c */
int			connect_by_number (char *, unsigned short *, int, int, int);
struct hostent *	resolv (const char *);
struct hostent *	lookup_host (const char *);
struct hostent *	lookup_ip (const char *);
char *			host_to_ip (const char *);
char *			ip_to_host (const char *);
char *			one_to_another (const char *);
int			set_blocking (int);
int			set_non_blocking (int);
int			my_accept (int, struct sockaddr *, int *);

#define my_isspace(x) \
	((x) == 9 || (x) == 10 || (x) == 11 || (x) == 12 || (x) == 13 || (x) == 32)
  
#define my_isdigit(x) \
(*x >= '0' && *x <= '9') || \
((*x == '-'  || *x == '+') && (x[1] >= '0' && x[1] <= '9'))

#define LOCAL_COPY(y) strcpy(alloca(strlen((y)) + 1), y)


#define	_1KB	(1024.0)
#define	_1MEG	(1024.0*1024.0)
#define	_1GIG	(1024.0*1024.0*1024.0)
#define	_1TER	(1024.0*1024.0*1024.0*1024.0)
#define	_1ETA	(1024.0*1024.0*1024.0*1024.0*1024.0)

#define	_GMKs(x)	( (x > _1ETA) ? "eb" : ((x > _1TER) ? "tb" : ((x > _1GIG) ? "gb" : \
			((x > _1MEG) ? "mb" : ((x > _1KB)? "kb" : "bytes")))))

#define	_GMKv(x)	((x > _1ETA) ? \
			(double)(x/_1ETA) : ((x > _1TER) ? \
			(double)(x/_1TER) : ((x > _1GIG) ? \
			(double)(x/_1GIG) : ((x > _1MEG) ? \
			(double)(x/_1MEG) : ((x > _1KB) ? \
			(double)(x/_1KB): (double)x)))) )

void	*n_malloc 	(size_t, const char *, const char *, const int);
void	*n_realloc	(void **, size_t, const char *, const char *, const int);

void	*n_free 	(void **, const char *, const char *, const int);

#define MODULENAME NULL

#define new_malloc(x) n_malloc(x, MODULENAME, __FILE__, __LINE__)
#define new_free(x) n_free((void **)(x), MODULENAME, __FILE__, __LINE__)

#define RESIZE(x, y, z) n_realloc     ((void **)& (x), sizeof(y) * (z), MODULENAME, __FILE__, __LINE__)
#define malloc_strcpy(x, y) n_malloc_strcpy((char **)x, (char *)y, MODULENAME, __FILE__, __LINE__)
#define malloc_strcat(x, y) n_malloc_strcat((char **)x, (char *)y, MODULENAME, __FILE__, __LINE__)
#define m_strdup(x) n_m_strdup(x, MODULENAME, __FILE__, __LINE__)
#define m_strcat_ues(x, y, z) n_m_strcat_ues(x, y, z, MODULENAME, __FILE__, __LINE__)
#define m_strndup(x, y) n_m_strndup(x, y, MODULENAME, __FILE__, __LINE__)

char	*encode (const char *, int);
char	*decode (const char *);
char	*cryptit(const char *);


/* Used for the inbound mangling stuff */

#define MANGLE_ESCAPES                1 << 0
#define MANGLE_ANSI_CODES     1 << 1
#define STRIP_COLOR           1 << 2
#define STRIP_REVERSE         1 << 3
#define STRIP_UNDERLINE               1 << 4
#define STRIP_BOLD            1 << 5
#define STRIP_BLINK           1 << 6
#define STRIP_ROM_CHAR                1 << 7
#define STRIP_ND_SPACE                1 << 8
#define STRIP_ALL_OFF			1 << 9
extern	int     outbound_line_mangler;
extern	int     inbound_line_mangler;
extern	int	logfile_line_mangler;

void  mangle_line             (char *, int);
int	charcount(const char *, char);
char	*stripdev(char *);
char	*convert_dos(char *str);
char	*convert_unix(char *str);
void	strip_chars(char *, char *, char);
char	*longcomma(long);
char	*ulongcomma(unsigned long);
#define SAFE(x) (((x) && *(x)) ? (x) : empty_string)


#endif /* _IRCAUX_H_ */
