#ifndef __misc_h__
#define __misc_h__

/*
************************************************************************
**  Misc.c
************************************************************************
*/

/*
**  Widget heirarchy
*/
Widget		GetToplevel(Widget);
Widget		GetShell(Widget);

/*
**  Cursor maniupulation.
*/
void 		SetIBeamCursor(Widget);
void 		SetCrossHairCursor(Widget);
void 		SetPencilCursor(Widget);

XRectangle 	*RectUnion(XRectangle *, XRectangle *);
XRectangle 	*RectIntersect(XRectangle *, XRectangle *);

void		StateSetBusy(Boolean);
void		StateSetBusyWatch(Boolean);
void		StateShellBusy(Widget, Boolean);
void		StateAddParent(Widget, Widget);
void		StateTimeStep();

/* Size of Drawable */
void 		GetPixmapWHD(Display *, Drawable, int *, int *, int *);

/*
**  GC & Pixmap caching
*/
Pixmap	GetBackgroundPixmap(Widget);
GC	GetGCX(Widget);

/*
**  Argument vector processing
*/
void     StrToArgv(char *, int *, char **);

/*
**  Argument vector processing
*/
XImage	*NewXImage(Display *, Visual *, int, int, int);

/*
************************************************************************
**  grab.c
************************************************************************
*/
void		*DoGrabImage(Widget, int, int);
void		DoGrabPixel(Widget, Pixel *, Colormap *);
XColor  	*DoGrabColor(Widget);


/*
************************************************************************
**  Dialog.c
************************************************************************
*/
/*
**  Alert boxes
*/
void 	AlertBox(Widget, char *, XtCallbackProc, XtCallbackProc, void *);
#ifdef MISSING_STDARG_H
void 	Notice(...);
#else
void 	Notice(Widget, ...);
#endif

/*
************************************************************************
**  Protocol.c
************************************************************************
*/
/*
**  WM_DESTROY  callback
*/
void AddDestroyCallback(Widget, void (*func)(Widget, void *, XEvent *), void *data);

/*
************************************************************************
**  Graphic.c
************************************************************************
*/
typedef void	(*GraphicAllProc)(Widget, void *);
void	GraphicAdd(Widget);
void	GraphicRemove(Widget, XtPointer, XtPointer);
void	GraphicAll(void (*)(Widget, void *), void *);
void	GraphicSetOp(void (*)(Widget, void *), void *(*)(Widget));
void	*GraphicGetData(Widget);
void	*GraphicGetReaderId(Widget);
void	GraphicSetReaderId(Widget, void *);

/*
************************************************************************
**  FileName.c
************************************************************************
*/
void    StdSaveAsFile(Widget, XtPointer, XtPointer);
void    StdSaveFile(Widget, XtPointer, XtPointer);
void    StdSaveRegionFile(Widget, XtPointer, XtPointer);
void 	GetFileName(Widget, int, char *, XtCallbackProc, XtPointer);
void	*GetFileNameGetLastId();

/*
************************************************************************
**  FileName.c
************************************************************************
*/
void ZoomSelect(Widget, Widget);
void SizeSelect(Widget, Widget, void (*)(Widget, int, int, int));

/*
************************************************************************
**  SelectOp.c
************************************************************************
*/
void SelectPasteSave(Widget w, void *);
void SelectPasteStart(Widget w, void *, XRectangle *);
void SelectChromaDialog(Widget w);

/*
************************************************************************
**  Color.c
************************************************************************
*/
Widget	ColorPicker(Widget, Colormap, Pixel *);
void	ColorPickerShell(Widget);
void	ColorPickerSetPixel(Widget, Pixel);
void	ColorPickerSetXColor(Widget, XColor *);
void	ColorPickerSetFunction(Widget, XtCallbackProc, XtPointer);
Pixel	ColorPickerGetPixel(Widget);
XColor  *ColorPickerGetXColor(Widget);


/*
************************************************************************
**  help.c
************************************************************************
*/
void	HelpInit(Widget);
void	HelpDialog(Widget, char *);

/*
************************************************************************
**  main.c
************************************************************************
*/
void	GetDefaultWH(int *, int *);
char	*GetDefaultRC();

/*
************************************************************************
**  colorEdit.c
************************************************************************
*/
#ifdef __palette_h__
void ColorEditor(Widget, Pixel, Palette *, Boolean, XtCallbackProc, XtPointer);
#endif

#endif /* __misc_h__ */

/*
************************************************************************
**  image.c
************************************************************************
*/
Pixmap  MaskDataToPixmap(Widget, int, int, char *, XRectangle *);


/*
************************************************************************
**  operation.c
************************************************************************
*/
#ifdef __IMAGE_H__
Image	*OperationIconImage(Widget, char *);
#endif
