#
#  fmt_info.pl
#
#  $Id: fmt_info.pl,v 1.3 2001/09/01 14:16:59 sano Exp $
#
#  GNU Info-specific driver stuff
#
#   Copyright 1996, Cees de Groot
#
package LinuxDocTools::fmt_info;
use strict;

use LinuxDocTools::Vars;

use File::Copy;
use Text::EntityMap;
use LinuxDocTools::CharEnts;
use LinuxDocTools::Lang;
use LinuxDocTools::Vars;
use LinuxDocTools::Utils qw(create_temp);

my $info = {};
$info->{NAME} = "info";
$info->{HELP} = "";
$info->{OPTIONS} = [
];
$info->{preNSGMLS} = sub {
  $global->{NsgmlsOpts} .= " -ifmtinfo ";
  $global->{NsgmlsPrePipe} =
    "cat  $global->{file}";
};

$Formats{$info->{NAME}} = $info;

# Ascii escape sub.  this is called-back by `parse_data' below in
# `info_preASP' to properly escape `\' characters coming from the SGML
# source.
my $info_escape = sub {
    my ($data) = @_;

#    $data =~ s|"| \"|g;	# Insert zero-width space in front of "
#    $data =~ s|^\.| .|;	# ditto in front of . at start of line
#    $data =~ s|\\|\\\\|g;	# Escape backslashes

    return ($data);
};

#
#  Run the file through the genertoc utility before sgmlsasp. Not necessary
#  when producing a manpage. A lot of code from FJM, untested by me.
#
$info->{preASP} = sub
{
  my ($infile, $outfile) = @_;

  my $char_maps = load_char_maps ('.2texi', [ Text::EntityMap::sdata_dirs() ]);
  if ( $global->{charset} eq "latin1" )
   {
    $char_maps = load_char_maps ('.2l1texi', [ Text::EntityMap::sdata_dirs() ]);
   }

  while ( <$infile> )
    {
      #
      #  Replace some symbols in the file before sgmlsasp.
      #  This has been done in preNSGMLS, but if the specified
      #  sgml file is devided into multiple pieces, the preNSGMLS
      #  is not enough.
      #
      s/\@/\@\@/g;
      s/{/\@{/g;
      s/}/\@}/g;
#      s/-\((.*)\)/-\'\($1\)\'/;
      s/-\((.*)\)/-\[$1\]/;
      s/\\\|urlnam\\\|/ /g;
      s/\\\|refnam\\\|/ /g;
    
      if (/^-/)
        {
         my ($str) = $';
         chop ($str);
         print $outfile "-" . 
                 parse_data ($str, $char_maps, $info_escape) . "\n";
         next;
        }
      elsif (/^A/)
        {
         /^A(\S+) (IMPLIED|CDATA|NOTATION|ENTITY|TOKEN)( (.*))?$/
             || die "bad attribute data: $_\n";
         my ($name,$type,$value) = ($1,$2,$4);
         if ($type eq "CDATA")
          {
            # CDATA attributes get translated also
            $value = parse_data ($value, $char_maps, $info_escape);
          }
         print $outfile "A$name $type $value\n";
         next;
        }
      #
      #  Default action if not skipped over with next: copy in to out.
      #
      print $outfile $_;
    }

  return 0;
};

#
#  Take the sgmlsasp output, and make something
#  useful from it.
#
$info->{postASP} = sub
{
  my $infile = shift;
  create_temp("$global->{tmpbase}.info.1");
  my $outfile = new FileHandle ">$global->{tmpbase}.info.1";
  copy ($infile, $outfile); 
  $outfile->close;
  create_temp("$global->{tmpbase}.info.2");
#  system ("gawk -v INFO=$global->{filename}.info -f $main::DataDir/info.awk $global->{tmpbase}.info.1 >$global->{tmpbase}.info.2");
  system ("$main::progs->{AWK} -v INFO=$global->{filename}.info -f $main::DataDir/info.awk $global->{tmpbase}.info.1 >$global->{tmpbase}.info.2");
  system ("makeinfo $global->{tmpbase}.info.2 -o $global->{filename}.info");

  return 0;
};

1;
