/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.modsext;

import com.sun.electric.tool.simulation.acl2.mods.Lhatom;
import com.sun.electric.tool.simulation.acl2.mods.Lhrange;
import com.sun.electric.tool.simulation.acl2.mods.Lhs;
import com.sun.electric.tool.simulation.acl2.mods.Name;
import com.sun.electric.tool.simulation.acl2.mods.Path;
import com.sun.electric.tool.simulation.acl2.mods.Util;
import com.sun.electric.tool.simulation.acl2.mods.Wire;
import com.sun.electric.tool.simulation.acl2.mods.Wiretype;
import com.sun.electric.tool.simulation.acl2.modsext.DriverExt;
import com.sun.electric.tool.simulation.acl2.modsext.ModExport;
import com.sun.electric.tool.simulation.acl2.modsext.ModuleExt;
import com.sun.electric.tool.simulation.acl2.modsext.PathExt;
import com.sun.electric.tool.simulation.acl2.svex.Svar;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;

public class WireExt
extends PathExt {
    public final Wire b;
    final int index;
    public boolean used;
    public ModExport exported;
    BigInteger assignedBits;
    final SortedMap<Lhrange<PathExt>, WireDriver> drivers = new TreeMap<Lhrange, WireDriver>(LHRANGE_COMPARATOR);
    private static final Comparator<Lhrange> LHRANGE_COMPARATOR = (o1, o2) -> Integer.compare(o1.getRsh(), o2.getRsh());

    WireExt(ModuleExt parent, Wire b, int index) {
        super(parent, new Path.Wire(b.name), b.width);
        this.b = b;
        this.index = index;
        if (!b.name.isString()) {
            Util.check(b.name.isInteger() || b.name.equals(Name.SELF));
            Util.check(parent.modName.isCoretype());
        }
        Util.check(b.delay == 0);
        Util.check(!b.revp);
    }

    public Name getName() {
        return this.b.name;
    }

    public int getLowIdx() {
        return this.b.low_idx;
    }

    public int getDelay() {
        return this.b.delay;
    }

    public boolean isRev() {
        return this.b.revp;
    }

    public Wiretype getWiretype() {
        return this.b.wiretype;
    }

    public int getFirstIndex() {
        return this.b.getFirstIndex();
    }

    public int getSecondIndex() {
        return this.b.getSecondIndex();
    }

    @Override
    public WireExt getWire() {
        return this;
    }

    @Override
    int getIndexInParent() {
        return this.index;
    }

    public void markUsed() {
        this.used = true;
    }

    public String toString(int width, int rsh) {
        return this.b.toString(width, rsh);
    }

    @Override
    public String toString(BigInteger mask) {
        return this.b.toString(mask);
    }

    public String toLispString(int width, int rsh) {
        return this.b.toLispString(width, rsh);
    }

    public boolean equals(Object o) {
        if (o instanceof WireExt) {
            WireExt that = (WireExt)o;
            return this.getName().equals(that.getName()) && this.parent == that.parent;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.b.toString();
    }

    public void markAssigned(BigInteger assignedBits) {
        if (assignedBits.signum() == 0) {
            return;
        }
        Util.check(assignedBits.signum() >= 0 && assignedBits.bitLength() <= this.getWidth());
        if (this.assignedBits == null) {
            this.assignedBits = BigInteger.ZERO;
        }
        if (assignedBits.and(this.assignedBits).signum() != 0) {
            System.out.println(this + " has multiple assignement");
        }
        this.assignedBits = this.assignedBits.or(assignedBits);
    }

    public boolean isAssigned() {
        return this.assignedBits != null;
    }

    public boolean isExport() {
        return this.exported != null;
    }

    public ModExport getExport() {
        return this.exported;
    }

    public boolean isInput() {
        return this.isExport() && !this.isAssigned();
    }

    public boolean isOutput() {
        return this.isExport() && this.isAssigned();
    }

    public BigInteger getAssignedBits() {
        return this.assignedBits != null ? this.assignedBits : BigInteger.ZERO;
    }

    public void addDriver(Lhrange<PathExt> lr, int lsh, Object driver) {
        WireDriver wd;
        Svar<PathExt> svar = lr.getVar();
        assert (svar.getDelay() == 0);
        WireExt lw = (WireExt)svar.getName();
        Util.check(lw == this);
        if (driver instanceof DriverExt) {
            wd = new WireDriver(lsh, (DriverExt)driver);
        } else if (driver instanceof PathExt.PortInst) {
            wd = new WireDriver(lsh, (PathExt.PortInst)driver);
        } else if (driver instanceof WireExt) {
            WireExt inp = (WireExt)driver;
            wd = new WireDriver(lsh, inp);
            for (int bit = 0; bit < lr.getWidth(); ++bit) {
                lw.parentBits[lr.getRsh() + bit] = inp.getBit(bit);
            }
            Lhrange<PathExt> range = new Lhrange<PathExt>(this.width, Lhatom.valueOf(inp.getVar(0), lsh));
            this.namedLhs = new Lhs(Collections.singletonList(range));
        } else {
            throw new UnsupportedOperationException();
        }
        WireDriver old = this.drivers.put(lr, wd);
        Util.check(old == null);
    }

    public static class WireDriver {
        public final int lsh;
        public final DriverExt driver;
        public final PathExt.PortInst pi;
        public final WireExt inp;

        WireDriver(int lsh, DriverExt driver) {
            this.lsh = lsh;
            this.driver = driver;
            this.pi = null;
            this.inp = null;
        }

        WireDriver(int lsh, PathExt.PortInst pi) {
            this.lsh = lsh;
            this.driver = null;
            this.pi = pi;
            this.inp = null;
        }

        WireDriver(int lsh, WireExt inp) {
            this.lsh = lsh;
            this.driver = null;
            this.pi = null;
            this.inp = inp;
        }
    }
}

