/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.12
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */

#define SWIGCSHARP


#ifdef __cplusplus
/* SwigValueWrapper is described in swig.swg */
template<typename T> class SwigValueWrapper {
  struct SwigMovePointer {
    T *ptr;
    SwigMovePointer(T *p) : ptr(p) { }
    ~SwigMovePointer() { delete ptr; }
    SwigMovePointer& operator=(SwigMovePointer& rhs) { T* oldptr = ptr; ptr = 0; delete oldptr; ptr = rhs.ptr; rhs.ptr = 0; return *this; }
  } pointer;
  SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
  SwigValueWrapper(const SwigValueWrapper<T>& rhs);
public:
  SwigValueWrapper() : pointer(0) { }
  SwigValueWrapper& operator=(const T& t) { SwigMovePointer tmp(new T(t)); pointer = tmp; return *this; }
  operator T&() const { return *pointer.ptr; }
  T *operator&() { return pointer.ptr; }
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif



#include <stdlib.h>
#include <string.h>
#include <stdio.h>


/* Support for throwing C# exceptions from C/C++. There are two types: 
 * Exceptions that take a message and ArgumentExceptions that take a message and a parameter name. */
typedef enum {
  SWIG_CSharpApplicationException,
  SWIG_CSharpArithmeticException,
  SWIG_CSharpDivideByZeroException,
  SWIG_CSharpIndexOutOfRangeException,
  SWIG_CSharpInvalidCastException,
  SWIG_CSharpInvalidOperationException,
  SWIG_CSharpIOException,
  SWIG_CSharpNullReferenceException,
  SWIG_CSharpOutOfMemoryException,
  SWIG_CSharpOverflowException,
  SWIG_CSharpSystemException
} SWIG_CSharpExceptionCodes;

typedef enum {
  SWIG_CSharpArgumentException,
  SWIG_CSharpArgumentNullException,
  SWIG_CSharpArgumentOutOfRangeException
} SWIG_CSharpExceptionArgumentCodes;

typedef void (SWIGSTDCALL* SWIG_CSharpExceptionCallback_t)(const char *);
typedef void (SWIGSTDCALL* SWIG_CSharpExceptionArgumentCallback_t)(const char *, const char *);

typedef struct {
  SWIG_CSharpExceptionCodes code;
  SWIG_CSharpExceptionCallback_t callback;
} SWIG_CSharpException_t;

typedef struct {
  SWIG_CSharpExceptionArgumentCodes code;
  SWIG_CSharpExceptionArgumentCallback_t callback;
} SWIG_CSharpExceptionArgument_t;

static SWIG_CSharpException_t SWIG_csharp_exceptions[] = {
  { SWIG_CSharpApplicationException, NULL },
  { SWIG_CSharpArithmeticException, NULL },
  { SWIG_CSharpDivideByZeroException, NULL },
  { SWIG_CSharpIndexOutOfRangeException, NULL },
  { SWIG_CSharpInvalidCastException, NULL },
  { SWIG_CSharpInvalidOperationException, NULL },
  { SWIG_CSharpIOException, NULL },
  { SWIG_CSharpNullReferenceException, NULL },
  { SWIG_CSharpOutOfMemoryException, NULL },
  { SWIG_CSharpOverflowException, NULL },
  { SWIG_CSharpSystemException, NULL }
};

static SWIG_CSharpExceptionArgument_t SWIG_csharp_exceptions_argument[] = {
  { SWIG_CSharpArgumentException, NULL },
  { SWIG_CSharpArgumentNullException, NULL },
  { SWIG_CSharpArgumentOutOfRangeException, NULL }
};

static void SWIGUNUSED SWIG_CSharpSetPendingException(SWIG_CSharpExceptionCodes code, const char *msg) {
  SWIG_CSharpExceptionCallback_t callback = SWIG_csharp_exceptions[SWIG_CSharpApplicationException].callback;
  if ((size_t)code < sizeof(SWIG_csharp_exceptions)/sizeof(SWIG_CSharpException_t)) {
    callback = SWIG_csharp_exceptions[code].callback;
  }
  callback(msg);
}

static void SWIGUNUSED SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpExceptionArgumentCodes code, const char *msg, const char *param_name) {
  SWIG_CSharpExceptionArgumentCallback_t callback = SWIG_csharp_exceptions_argument[SWIG_CSharpArgumentException].callback;
  if ((size_t)code < sizeof(SWIG_csharp_exceptions_argument)/sizeof(SWIG_CSharpExceptionArgument_t)) {
    callback = SWIG_csharp_exceptions_argument[code].callback;
  }
  callback(msg, param_name);
}


#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT void SWIGSTDCALL SWIGRegisterExceptionCallbacks_Gdal(
                                                SWIG_CSharpExceptionCallback_t applicationCallback,
                                                SWIG_CSharpExceptionCallback_t arithmeticCallback,
                                                SWIG_CSharpExceptionCallback_t divideByZeroCallback, 
                                                SWIG_CSharpExceptionCallback_t indexOutOfRangeCallback, 
                                                SWIG_CSharpExceptionCallback_t invalidCastCallback,
                                                SWIG_CSharpExceptionCallback_t invalidOperationCallback,
                                                SWIG_CSharpExceptionCallback_t ioCallback,
                                                SWIG_CSharpExceptionCallback_t nullReferenceCallback,
                                                SWIG_CSharpExceptionCallback_t outOfMemoryCallback, 
                                                SWIG_CSharpExceptionCallback_t overflowCallback, 
                                                SWIG_CSharpExceptionCallback_t systemCallback) {
  SWIG_csharp_exceptions[SWIG_CSharpApplicationException].callback = applicationCallback;
  SWIG_csharp_exceptions[SWIG_CSharpArithmeticException].callback = arithmeticCallback;
  SWIG_csharp_exceptions[SWIG_CSharpDivideByZeroException].callback = divideByZeroCallback;
  SWIG_csharp_exceptions[SWIG_CSharpIndexOutOfRangeException].callback = indexOutOfRangeCallback;
  SWIG_csharp_exceptions[SWIG_CSharpInvalidCastException].callback = invalidCastCallback;
  SWIG_csharp_exceptions[SWIG_CSharpInvalidOperationException].callback = invalidOperationCallback;
  SWIG_csharp_exceptions[SWIG_CSharpIOException].callback = ioCallback;
  SWIG_csharp_exceptions[SWIG_CSharpNullReferenceException].callback = nullReferenceCallback;
  SWIG_csharp_exceptions[SWIG_CSharpOutOfMemoryException].callback = outOfMemoryCallback;
  SWIG_csharp_exceptions[SWIG_CSharpOverflowException].callback = overflowCallback;
  SWIG_csharp_exceptions[SWIG_CSharpSystemException].callback = systemCallback;
}

#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT void SWIGSTDCALL SWIGRegisterExceptionArgumentCallbacks_Gdal(
                                                SWIG_CSharpExceptionArgumentCallback_t argumentCallback,
                                                SWIG_CSharpExceptionArgumentCallback_t argumentNullCallback,
                                                SWIG_CSharpExceptionArgumentCallback_t argumentOutOfRangeCallback) {
  SWIG_csharp_exceptions_argument[SWIG_CSharpArgumentException].callback = argumentCallback;
  SWIG_csharp_exceptions_argument[SWIG_CSharpArgumentNullException].callback = argumentNullCallback;
  SWIG_csharp_exceptions_argument[SWIG_CSharpArgumentOutOfRangeException].callback = argumentOutOfRangeCallback;
}


/* Callback for returning strings to C# without leaking memory */
typedef char * (SWIGSTDCALL* SWIG_CSharpStringHelperCallback)(const char *);
static SWIG_CSharpStringHelperCallback SWIG_csharp_string_callback = NULL;


#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT void SWIGSTDCALL SWIGRegisterStringCallback_Gdal(SWIG_CSharpStringHelperCallback callback) {
  SWIG_csharp_string_callback = callback;
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_CSharpSetPendingExceptionArgument(SWIG_CSharpArgumentOutOfRangeException, msg, ""); return nullreturn; } else

/*  Errors in SWIG */
#define  SWIG_UnknownError    	   -1
#define  SWIG_IOError        	   -2
#define  SWIG_RuntimeError   	   -3
#define  SWIG_IndexError     	   -4
#define  SWIG_TypeError      	   -5
#define  SWIG_DivisionByZero 	   -6
#define  SWIG_OverflowError  	   -7
#define  SWIG_SyntaxError    	   -8
#define  SWIG_ValueError     	   -9
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12
#define  SWIG_NullReferenceError   -13




SWIGINTERN void SWIG_CSharpException(int code, const char *msg) {
  if (code == SWIG_ValueError) {
    SWIG_CSharpExceptionArgumentCodes exception_code = SWIG_CSharpArgumentOutOfRangeException;
    SWIG_CSharpSetPendingExceptionArgument(exception_code, msg, 0);
  } else {
    SWIG_CSharpExceptionCodes exception_code = SWIG_CSharpApplicationException;
    switch(code) {
    case SWIG_MemoryError:
      exception_code = SWIG_CSharpOutOfMemoryException;
      break;
    case SWIG_IndexError:
      exception_code = SWIG_CSharpIndexOutOfRangeException;
      break;
    case SWIG_DivisionByZero:
      exception_code = SWIG_CSharpDivideByZeroException;
      break;
    case SWIG_IOError:
      exception_code = SWIG_CSharpIOException;
      break;
    case SWIG_OverflowError:
      exception_code = SWIG_CSharpOverflowException;
      break;
    case SWIG_RuntimeError:
    case SWIG_TypeError:
    case SWIG_SyntaxError:
    case SWIG_SystemError:
    case SWIG_UnknownError:
    default:
      exception_code = SWIG_CSharpApplicationException;
      break;
    }
    SWIG_CSharpSetPendingException(exception_code, msg);
  }
}


#include <stdexcept>


#include <iostream>
using namespace std;

#include "cpl_port.h"
#include "cpl_string.h"
#include "cpl_multiproc.h"
#include "cpl_http.h"
#include "cpl_vsi_error.h"

#include "gdal.h"
#include "gdal_priv.h"
#include "gdal_alg.h"
#include "gdalwarper.h"

typedef void GDALMajorObjectShadow;
typedef void GDALDriverShadow;
typedef void GDALDatasetShadow;
typedef void GDALRasterBandShadow;
typedef void GDALColorTableShadow;
typedef void GDALRasterAttributeTableShadow;
typedef void GDALTransformerInfoShadow;
typedef void GDALAsyncReaderShadow;


/* use this to not return the int returned by GDAL */
typedef int RETURN_NONE;
/* return value that is used for VSI methods that return -1 on error (and set errno) */
typedef int VSI_RETVAL;


void VeryQuietErrorHandler(CPLErr eclass, int code, const char *msg ) {
  /* If the error class is CE_Fatal, we want to have a message issued
     because the CPL support code does an abort() before any exception
     can be generated */
#if defined(SWIGPERL)
    AV* error_stack = get_av("Geo::GDAL::error", 0);
    SV *error = newSVpv(msg, 0);
    av_push(error_stack, error);
#endif
  if (eclass == CE_Fatal ) {
    CPLDefaultErrorHandler(eclass, code, msg );
  }
}


void UseExceptions() {
  CPLSetErrorHandler( (CPLErrorHandler) VeryQuietErrorHandler );
}

void DontUseExceptions() {
  CPLSetErrorHandler( CPLDefaultErrorHandler );
}


    void StringListDestroy(void *buffer_ptr) {
       CSLDestroy((char**)buffer_ptr);
    }


typedef char retStringAndCPLFree;


  void Debug( const char *msg_class, const char *message ) {
    CPLDebug( msg_class, "%s", message );
  }

  CPLErr SetErrorHandler( char const * pszCallbackName = NULL )
  {
    CPLErrorHandler pfnHandler = NULL;
    if( pszCallbackName == NULL || EQUAL(pszCallbackName,"CPLQuietErrorHandler") )
      pfnHandler = CPLQuietErrorHandler;
    else if( EQUAL(pszCallbackName,"CPLDefaultErrorHandler") )
      pfnHandler = CPLDefaultErrorHandler;
    else if( EQUAL(pszCallbackName,"CPLLoggingErrorHandler") )
      pfnHandler = CPLLoggingErrorHandler;

    if ( pfnHandler == NULL )
      return CE_Fatal;

    CPLSetErrorHandler( pfnHandler );

    return CE_None;
  }


  CPLErr PushErrorHandler( char const * pszCallbackName = NULL ) {
    CPLErrorHandler pfnHandler = NULL;
    if( pszCallbackName == NULL || EQUAL(pszCallbackName,"CPLQuietErrorHandler") )
      pfnHandler = CPLQuietErrorHandler;
    else if( EQUAL(pszCallbackName,"CPLDefaultErrorHandler") )
      pfnHandler = CPLDefaultErrorHandler;
    else if( EQUAL(pszCallbackName,"CPLLoggingErrorHandler") )
      pfnHandler = CPLLoggingErrorHandler;

    if ( pfnHandler == NULL )
      return CE_Fatal;

    CPLPushErrorHandler( pfnHandler );

    return CE_None;
  }


  void Error( CPLErr msg_class = CE_Failure, int err_code = 0, const char* msg = "error" ) {
    CPLError( msg_class, err_code, "%s", msg );
  }


retStringAndCPLFree* EscapeString(int len, char *bin_string , int scheme) {
    return CPLEscapeString((const char*)bin_string, len, scheme);
}


char **wrapper_VSIReadDirEx( const char * utf8_path, int nMaxFiles = 0 )
{
    return VSIReadDirEx(utf8_path, nMaxFiles);
}


const char *wrapper_CPLGetConfigOption( const char * pszKey, const char * pszDefault = NULL )
{
    return CPLGetConfigOption( pszKey, pszDefault );
}


void wrapper_VSIFileFromMemBuffer( const char* utf8_path, int nBytes, const GByte *pabyData)
{
    GByte* pabyDataDup = (GByte*)VSIMalloc(nBytes);
    if (pabyDataDup == NULL)
            return;
    memcpy(pabyDataDup, pabyData, nBytes);
    VSIFCloseL(VSIFileFromMemBuffer(utf8_path, (GByte*) pabyDataDup, nBytes, TRUE));
}



int wrapper_HasThreadSupport()
{
    return strcmp(CPLGetThreadingModel(), "stub") != 0;
}


VSILFILE   *wrapper_VSIFOpenL( const char *utf8_path, const char *pszMode )
{
    if (!pszMode) /* would lead to segfault */
        pszMode = "r";
    return VSIFOpenL( utf8_path, pszMode );
}


VSILFILE   *wrapper_VSIFOpenExL( const char *utf8_path, const char *pszMode, int bSetError )
{
    if (!pszMode) /* would lead to segfault */
        pszMode = "r";
    return VSIFOpenExL( utf8_path, pszMode, bSetError );
}

SWIGINTERN CPLXMLNode *new_CPLXMLNode__SWIG_0(char const *pszString){
        return CPLParseXMLString( pszString );
    }
SWIGINTERN CPLXMLNode *new_CPLXMLNode__SWIG_1(CPLXMLNodeType eType,char const *pszText){
        return CPLCreateXMLNode(NULL, eType, pszText);
    }
SWIGINTERN void delete_CPLXMLNode(CPLXMLNode *self){
        CPLDestroyXMLNode( self );
    }
SWIGINTERN retStringAndCPLFree *CPLXMLNode_SerializeXMLTree(CPLXMLNode *self){
        return CPLSerializeXMLTree( self );
    }
SWIGINTERN retStringAndCPLFree *CPLXMLNode_toString(CPLXMLNode *self){
        return CPLSerializeXMLTree( self );
    }
SWIGINTERN CPLXMLNode *CPLXMLNode_SearchXMLNode(CPLXMLNode *self,char const *pszElement){
        return CPLSearchXMLNode(self, pszElement);
    }
SWIGINTERN CPLXMLNode *CPLXMLNode_GetXMLNode(CPLXMLNode *self,char const *pszPath){
        return CPLGetXMLNode( self, pszPath );
    }
SWIGINTERN char const *CPLXMLNode_GetXMLValue(CPLXMLNode *self,char const *pszPath,char const *pszDefault){
        return CPLGetXMLValue( self, pszPath, pszDefault );
    }
SWIGINTERN void CPLXMLNode_AddXMLChild(CPLXMLNode *self,CPLXMLNode *psChild){
        CPLAddXMLChild( self, psChild );
    }
SWIGINTERN int CPLXMLNode_RemoveXMLChild(CPLXMLNode *self,CPLXMLNode *psChild){
        return CPLRemoveXMLChild( self, psChild );
    }
SWIGINTERN void CPLXMLNode_AddXMLSibling(CPLXMLNode *self,CPLXMLNode *psNewSibling){
        CPLAddXMLSibling( self, psNewSibling );
    }
SWIGINTERN CPLXMLNode *CPLXMLNode_CreateXMLElementAndValue(CPLXMLNode *self,char const *pszName,char const *pszValue){
        return CPLCreateXMLElementAndValue( self, pszName, pszValue );
    }
SWIGINTERN CPLXMLNode *CPLXMLNode_CloneXMLTree(CPLXMLNode *self,CPLXMLNode *psTree){
        return CPLCloneXMLTree( psTree );
    }
SWIGINTERN CPLXMLNode *CPLXMLNode_Clone(CPLXMLNode *self){
        return CPLCloneXMLTree( self );
    }
SWIGINTERN int CPLXMLNode_SetXMLValue(CPLXMLNode *self,char const *pszPath,char const *pszValue){
        return CPLSetXMLValue( self,  pszPath, pszValue );
    }
SWIGINTERN void CPLXMLNode_StripXMLNamespace(CPLXMLNode *self,char const *pszNamespace,int bRecurse){
        CPLStripXMLNamespace( self, pszNamespace, bRecurse );
    }
SWIGINTERN char const *GDALMajorObjectShadow_GetDescription(GDALMajorObjectShadow *self){
    return GDALGetDescription( self );
  }
SWIGINTERN void GDALMajorObjectShadow_SetDescription(GDALMajorObjectShadow *self,char const *pszNewDesc){
    GDALSetDescription( self, pszNewDesc );
  }
SWIGINTERN char **GDALMajorObjectShadow_GetMetadataDomainList(GDALMajorObjectShadow *self){
    return GDALGetMetadataDomainList( self );
  }
SWIGINTERN char **GDALMajorObjectShadow_GetMetadata_List(GDALMajorObjectShadow *self,char const *pszDomain=""){
    return GDALGetMetadata( self, pszDomain );
  }
SWIGINTERN CPLErr GDALMajorObjectShadow_SetMetadata__SWIG_0(GDALMajorObjectShadow *self,char **papszMetadata,char const *pszDomain=""){
    return GDALSetMetadata( self, papszMetadata, pszDomain );
  }
SWIGINTERN CPLErr GDALMajorObjectShadow_SetMetadata__SWIG_1(GDALMajorObjectShadow *self,char *pszMetadataString,char const *pszDomain=""){
    char *tmpList[2];
    tmpList[0] = pszMetadataString;
    tmpList[1] = 0;
    return GDALSetMetadata( self, tmpList, pszDomain );
  }
SWIGINTERN char const *GDALMajorObjectShadow_GetMetadataItem(GDALMajorObjectShadow *self,char const *pszName,char const *pszDomain=""){
    return GDALGetMetadataItem( self, pszName, pszDomain);
  }
SWIGINTERN CPLErr GDALMajorObjectShadow_SetMetadataItem(GDALMajorObjectShadow *self,char const *pszName,char const *pszValue,char const *pszDomain=""){
    return GDALSetMetadataItem( self, pszName, pszValue, pszDomain);
  }
SWIGINTERN GDALDatasetShadow *GDALDriverShadow_Create(GDALDriverShadow *self,char const *utf8_path,int xsize,int ysize,int bands=1,GDALDataType eType=GDT_Byte,char **options=0){

    GDALDatasetShadow* ds = (GDALDatasetShadow*) GDALCreate(    self,
                                                                utf8_path,
                                                                xsize,
                                                                ysize,
                                                                bands,
                                                                eType,
                                                                options );
    return ds;
  }
SWIGINTERN GDALDatasetShadow *GDALDriverShadow_CreateCopy(GDALDriverShadow *self,char const *utf8_path,GDALDatasetShadow *src,int strict=1,char **options=0,GDALProgressFunc callback=NULL,void *callback_data=NULL){

    GDALDatasetShadow *ds = (GDALDatasetShadow*) GDALCreateCopy(    self,
                                                                    utf8_path,
                                                                    src,
                                                                    strict,
                                                                    options,
                                                                    callback,
                                                                    callback_data );
    return ds;
  }
SWIGINTERN CPLErr GDALDriverShadow_Delete(GDALDriverShadow *self,char const *utf8_path){
    return GDALDeleteDataset( self, utf8_path );
  }
SWIGINTERN CPLErr GDALDriverShadow_Rename(GDALDriverShadow *self,char const *newName,char const *oldName){
    return GDALRenameDataset( self, newName, oldName );
  }
SWIGINTERN CPLErr GDALDriverShadow_CopyFiles(GDALDriverShadow *self,char const *newName,char const *oldName){
    return GDALCopyDatasetFiles( self, newName, oldName );
  }
SWIGINTERN int GDALDriverShadow_Register(GDALDriverShadow *self){
    return GDALRegisterDriver( self );
  }
SWIGINTERN void GDALDriverShadow_Deregister(GDALDriverShadow *self){
    GDALDeregisterDriver( self );
  }

char const *GDALDriverShadow_ShortName_get( GDALDriverShadow *h ) {
  return GDALGetDriverShortName( h );
}
char const *GDALDriverShadow_LongName_get( GDALDriverShadow *h ) {
  return GDALGetDriverLongName( h );
}
char const *GDALDriverShadow_HelpTopic_get( GDALDriverShadow *h ) {
  return GDALGetDriverHelpTopic( h );
}

SWIGINTERN GDAL_GCP *new_GDAL_GCP(double x=0.0,double y=0.0,double z=0.0,double pixel=0.0,double line=0.0,char const *info="",char const *id=""){

    GDAL_GCP *self = (GDAL_GCP*) CPLMalloc( sizeof( GDAL_GCP ) );
    self->dfGCPX = x;
    self->dfGCPY = y;
    self->dfGCPZ = z;
    self->dfGCPPixel = pixel;
    self->dfGCPLine = line;
    self->pszInfo =  CPLStrdup( (info == 0) ? "" : info );
    self->pszId = CPLStrdup( (id==0)? "" : id );
    return self;
  }
SWIGINTERN void delete_GDAL_GCP(GDAL_GCP *self){
    if ( self->pszInfo )
      CPLFree( self->pszInfo );
    if ( self->pszId )
      CPLFree( self->pszId );
    CPLFree( self );
  }


double GDAL_GCP_GCPX_get( GDAL_GCP *gcp ) {
  return gcp->dfGCPX;
}
void GDAL_GCP_GCPX_set( GDAL_GCP *gcp, double dfGCPX ) {
  gcp->dfGCPX = dfGCPX;
}
double GDAL_GCP_GCPY_get( GDAL_GCP *gcp ) {
  return gcp->dfGCPY;
}
void GDAL_GCP_GCPY_set( GDAL_GCP *gcp, double dfGCPY ) {
  gcp->dfGCPY = dfGCPY;
}
double GDAL_GCP_GCPZ_get( GDAL_GCP *gcp ) {
  return gcp->dfGCPZ;
}
void GDAL_GCP_GCPZ_set( GDAL_GCP *gcp, double dfGCPZ ) {
  gcp->dfGCPZ = dfGCPZ;
}
double GDAL_GCP_GCPPixel_get( GDAL_GCP *gcp ) {
  return gcp->dfGCPPixel;
}
void GDAL_GCP_GCPPixel_set( GDAL_GCP *gcp, double dfGCPPixel ) {
  gcp->dfGCPPixel = dfGCPPixel;
}
double GDAL_GCP_GCPLine_get( GDAL_GCP *gcp ) {
  return gcp->dfGCPLine;
}
void GDAL_GCP_GCPLine_set( GDAL_GCP *gcp, double dfGCPLine ) {
  gcp->dfGCPLine = dfGCPLine;
}
const char * GDAL_GCP_Info_get( GDAL_GCP *gcp ) {
  return gcp->pszInfo;
}
void GDAL_GCP_Info_set( GDAL_GCP *gcp, const char * pszInfo ) {
  if ( gcp->pszInfo )
    CPLFree( gcp->pszInfo );
  gcp->pszInfo = CPLStrdup(pszInfo);
}
const char * GDAL_GCP_Id_get( GDAL_GCP *gcp ) {
  return gcp->pszId;
}
void GDAL_GCP_Id_set( GDAL_GCP *gcp, const char * pszId ) {
  if ( gcp->pszId )
    CPLFree( gcp->pszId );
  gcp->pszId = CPLStrdup(pszId);
}


/* Duplicate, but transposed names for C# because
*  the C# module outputs backwards names
*/
double GDAL_GCP_get_GCPX( GDAL_GCP *gcp ) {
  return gcp->dfGCPX;
}
void GDAL_GCP_set_GCPX( GDAL_GCP *gcp, double dfGCPX ) {
  gcp->dfGCPX = dfGCPX;
}
double GDAL_GCP_get_GCPY( GDAL_GCP *gcp ) {
  return gcp->dfGCPY;
}
void GDAL_GCP_set_GCPY( GDAL_GCP *gcp, double dfGCPY ) {
  gcp->dfGCPY = dfGCPY;
}
double GDAL_GCP_get_GCPZ( GDAL_GCP *gcp ) {
  return gcp->dfGCPZ;
}
void GDAL_GCP_set_GCPZ( GDAL_GCP *gcp, double dfGCPZ ) {
  gcp->dfGCPZ = dfGCPZ;
}
double GDAL_GCP_get_GCPPixel( GDAL_GCP *gcp ) {
  return gcp->dfGCPPixel;
}
void GDAL_GCP_set_GCPPixel( GDAL_GCP *gcp, double dfGCPPixel ) {
  gcp->dfGCPPixel = dfGCPPixel;
}
double GDAL_GCP_get_GCPLine( GDAL_GCP *gcp ) {
  return gcp->dfGCPLine;
}
void GDAL_GCP_set_GCPLine( GDAL_GCP *gcp, double dfGCPLine ) {
  gcp->dfGCPLine = dfGCPLine;
}
const char * GDAL_GCP_get_Info( GDAL_GCP *gcp ) {
  return gcp->pszInfo;
}
void GDAL_GCP_set_Info( GDAL_GCP *gcp, const char * pszInfo ) {
  if ( gcp->pszInfo )
    CPLFree( gcp->pszInfo );
  gcp->pszInfo = CPLStrdup(pszInfo);
}
const char * GDAL_GCP_get_Id( GDAL_GCP *gcp ) {
  return gcp->pszId;
}
void GDAL_GCP_set_Id( GDAL_GCP *gcp, const char * pszId ) {
  if ( gcp->pszId )
    CPLFree( gcp->pszId );
  gcp->pszId = CPLStrdup(pszId);
}


/* Returned size is in bytes or 0 if an error occurred. */
static
GIntBig ComputeDatasetRasterIOSize (int buf_xsize, int buf_ysize, int nPixelSize,
                                int nBands, int* bandMap, int nBandMapArrayLength,
                                GIntBig nPixelSpace, GIntBig nLineSpace, GIntBig nBandSpace,
                                int bSpacingShouldBeMultipleOfPixelSize )
{
    if (buf_xsize <= 0 || buf_ysize <= 0)
    {
        CPLError(CE_Failure, CPLE_IllegalArg, "Illegal values for buffer size");
        return 0;
    }

    if (nPixelSpace < 0 || nLineSpace < 0 || nBandSpace < 0)
    {
        CPLError(CE_Failure, CPLE_IllegalArg, "Illegal values for space arguments");
        return 0;
    }

    if (nPixelSize == 0)
    {
        CPLError(CE_Failure, CPLE_IllegalArg, "Illegal value for data type");
        return 0;
    }

    if( nPixelSpace == 0 )
        nPixelSpace = nPixelSize;
    else if ( bSpacingShouldBeMultipleOfPixelSize && (nPixelSpace % nPixelSize) != 0 )
    {
        CPLError(CE_Failure, CPLE_IllegalArg, "nPixelSpace should be a multiple of nPixelSize");
        return 0;
    }

    if( nLineSpace == 0 )
    {
        nLineSpace = nPixelSpace * buf_xsize;
    }
    else if ( bSpacingShouldBeMultipleOfPixelSize && (nLineSpace % nPixelSize) != 0 )
    {
        CPLError(CE_Failure, CPLE_IllegalArg, "nLineSpace should be a multiple of nPixelSize");
        return 0;
    }

    if( nBandSpace == 0 )
    {
        nBandSpace = nLineSpace * buf_ysize;
    }
    else if ( bSpacingShouldBeMultipleOfPixelSize && (nBandSpace % nPixelSize) != 0 )
    {
        CPLError(CE_Failure, CPLE_IllegalArg, "nLineSpace should be a multiple of nPixelSize");
        return 0;
    }

    if (nBands <= 0 || (bandMap != NULL && nBands > nBandMapArrayLength))
    {
        CPLError(CE_Failure, CPLE_IllegalArg, "Invalid band count");
        return 0;
    }

    GIntBig nRet = (GIntBig)(buf_ysize - 1) * nLineSpace + (GIntBig)(buf_xsize - 1) * nPixelSpace + (GIntBig)(nBands - 1) * nBandSpace + nPixelSize;
#if SIZEOF_VOIDP == 4
    if (nRet > INT_MAX)
    {
        CPLError(CE_Failure, CPLE_IllegalArg, "Integer overflow");
        return 0;
    }
#endif

    return nRet;
}


typedef struct
{
    GDALAsyncReaderH  hAsyncReader;
    void             *pyObject;
} GDALAsyncReaderWrapper;

typedef void* GDALAsyncReaderWrapperH;

static GDALAsyncReaderH AsyncReaderWrapperGetReader(GDALAsyncReaderWrapperH hWrapper)
{
    GDALAsyncReaderWrapper* psWrapper = (GDALAsyncReaderWrapper*)hWrapper;
    if (psWrapper->hAsyncReader == NULL)
    {
        CPLError(CE_Failure, CPLE_AppDefined, "AsyncReader object is defunct");
    }
    return psWrapper->hAsyncReader;
}

#if defined(SWIGPYTHON)
static void* AsyncReaderWrapperGetPyObject(GDALAsyncReaderWrapperH hWrapper)
{
    GDALAsyncReaderWrapper* psWrapper = (GDALAsyncReaderWrapper*)hWrapper;
    return psWrapper->pyObject;
}
#endif

static void DeleteAsyncReaderWrapper(GDALAsyncReaderWrapperH hWrapper)
{
    GDALAsyncReaderWrapper* psWrapper = (GDALAsyncReaderWrapper*)hWrapper;
    if (psWrapper->hAsyncReader != NULL)
    {
        CPLError(CE_Failure, CPLE_AppDefined,
                 "Native AsyncReader object will leak. EndAsyncReader() should have been called before");
    }
    CPLFree(psWrapper);
}


SWIGINTERN void delete_GDALAsyncReaderShadow(GDALAsyncReaderShadow *self){
        DeleteAsyncReaderWrapper(self);
    }
SWIGINTERN GDALAsyncStatusType GDALAsyncReaderShadow_GetNextUpdatedRegion(GDALAsyncReaderShadow *self,double timeout,int *xoff,int *yoff,int *buf_xsize,int *buf_ysize){
        GDALAsyncReaderH hReader = AsyncReaderWrapperGetReader(self);
        if (hReader == NULL)
        {
            *xoff = 0;
            *yoff = 0;
            *buf_xsize = 0;
            *buf_ysize = 0;
            return GARIO_ERROR;
        }
        return GDALARGetNextUpdatedRegion(hReader, timeout, xoff, yoff, buf_xsize, buf_ysize );
    }
SWIGINTERN int GDALAsyncReaderShadow_LockBuffer(GDALAsyncReaderShadow *self,double timeout){
        GDALAsyncReaderH hReader = AsyncReaderWrapperGetReader(self);
        if (hReader == NULL)
        {
            return 0;
        }
        return GDALARLockBuffer(hReader,timeout);
    }
SWIGINTERN void GDALAsyncReaderShadow_UnlockBuffer(GDALAsyncReaderShadow *self){
        GDALAsyncReaderH hReader = AsyncReaderWrapperGetReader(self);
        if (hReader == NULL)
        {
            return;
        }
        GDALARUnlockBuffer(hReader);
    }
SWIGINTERN void delete_GDALDatasetShadow(GDALDatasetShadow *self){
    if ( GDALDereferenceDataset( self ) <= 0 ) {
      GDALClose(self);
    }
  }
SWIGINTERN GDALDriverShadow *GDALDatasetShadow_GetDriver(GDALDatasetShadow *self){
    return (GDALDriverShadow*) GDALGetDatasetDriver( self );
  }
SWIGINTERN GDALRasterBandShadow *GDALDatasetShadow_GetRasterBand(GDALDatasetShadow *self,int nBand){
    return (GDALRasterBandShadow*) GDALGetRasterBand( self, nBand );
  }
SWIGINTERN char const *GDALDatasetShadow_GetProjection(GDALDatasetShadow *self){
    return GDALGetProjectionRef( self );
  }
SWIGINTERN char const *GDALDatasetShadow_GetProjectionRef(GDALDatasetShadow *self){
    return GDALGetProjectionRef( self );
  }
SWIGINTERN CPLErr GDALDatasetShadow_SetProjection(GDALDatasetShadow *self,char const *prj){
    return GDALSetProjection( self, prj );
  }
SWIGINTERN void GDALDatasetShadow_GetGeoTransform(GDALDatasetShadow *self,double argout[6]){
    if ( GDALGetGeoTransform( self, argout ) != CE_None ) {
      argout[0] = 0.0;
      argout[1] = 1.0;
      argout[2] = 0.0;
      argout[3] = 0.0;
      argout[4] = 0.0;
      argout[5] = 1.0;
    }
  }
SWIGINTERN CPLErr GDALDatasetShadow_SetGeoTransform(GDALDatasetShadow *self,double argin[6]){
    return GDALSetGeoTransform( self, argin );
  }
SWIGINTERN int GDALDatasetShadow_BuildOverviews(GDALDatasetShadow *self,char const *resampling="NEAREST",int overviewlist=0,int *pOverviews=0,GDALProgressFunc callback=NULL,void *callback_data=NULL){

    return GDALBuildOverviews(  self,
                                resampling ? resampling : "NEAREST",
                                overviewlist,
                                pOverviews,
                                0,
                                0,
                                callback,
                                callback_data);
  }
SWIGINTERN int GDALDatasetShadow_GetGCPCount(GDALDatasetShadow *self){
    return GDALGetGCPCount( self );
  }
SWIGINTERN char const *GDALDatasetShadow_GetGCPProjection(GDALDatasetShadow *self){
    return GDALGetGCPProjection( self );
  }
SWIGINTERN void GDALDatasetShadow_FlushCache(GDALDatasetShadow *self){
    GDALFlushCache( self );
  }
SWIGINTERN CPLErr GDALDatasetShadow_AddBand(GDALDatasetShadow *self,GDALDataType datatype=GDT_Byte,char **options=0){
    return GDALAddBand( self, datatype, options );
  }
SWIGINTERN CPLErr GDALDatasetShadow_CreateMaskBand(GDALDatasetShadow *self,int nFlags){
      return GDALCreateDatasetMaskBand( self, nFlags );
  }
SWIGINTERN char **GDALDatasetShadow_GetFileList(GDALDatasetShadow *self){
    return GDALGetFileList( self );
  }
SWIGINTERN OGRErr GDALDatasetShadow_StartTransaction(GDALDatasetShadow *self,int force=FALSE){
    return GDALDatasetStartTransaction(self, force);
  }

static char const *
OGRErrMessages( int rc ) {
  switch( rc ) {
  case 0:
    return "OGR Error %d: None";
  case 1:
    return "OGR Error %d: Not enough data";
  case 2:
    return "OGR Error %d: Unsupported geometry type";
  case 3:
    return "OGR Error %d: Unsupported operation";
  case 4:
    return "OGR Error %d: Corrupt data";
  case 5:
    return "OGR Error %d: General Error";
  case 6:
    return "OGR Error %d: Unsupported SRS";
  default:
    return "OGR Error %d: Unknown";
  }
}

SWIGINTERN OGRErr GDALDatasetShadow_CommitTransaction(GDALDatasetShadow *self){
    return GDALDatasetCommitTransaction(self);
  }
SWIGINTERN OGRErr GDALDatasetShadow_RollbackTransaction(GDALDatasetShadow *self){
    return GDALDatasetRollbackTransaction(self);
  }
SWIGINTERN CPLErr GDALDatasetShadow_ReadRaster(GDALDatasetShadow *self,int xOff,int yOff,int xSize,int ySize,void *buffer,int buf_xSize,int buf_ySize,GDALDataType buf_type,int bandCount,int *bandMap,int pixelSpace,int lineSpace,int bandSpace){
       return GDALDatasetRasterIO( self, GF_Read, xOff, yOff, xSize, ySize,
		        buffer, buf_xSize, buf_ySize, buf_type, bandCount,
		        bandMap, pixelSpace, lineSpace, bandSpace);
    }
SWIGINTERN CPLErr GDALDatasetShadow_WriteRaster(GDALDatasetShadow *self,int xOff,int yOff,int xSize,int ySize,void *buffer,int buf_xSize,int buf_ySize,GDALDataType buf_type,int bandCount,int *bandMap,int pixelSpace,int lineSpace,int bandSpace){
       return GDALDatasetRasterIO( self, GF_Write, xOff, yOff, xSize, ySize,
		        buffer, buf_xSize, buf_ySize, buf_type, bandCount,
		        bandMap, pixelSpace, lineSpace, bandSpace);
    }
SWIGINTERN GDAL_GCP const *GDALDatasetShadow___GetGCPs(GDALDatasetShadow *self){
      return GDALGetGCPs( self );
    }
SWIGINTERN CPLErr GDALDatasetShadow___SetGCPs(GDALDatasetShadow *self,int nGCPs,GDAL_GCP const *pGCPs,char const *pszGCPProjection){
        return GDALSetGCPs( self, nGCPs, pGCPs, pszGCPProjection );
    }
SWIGINTERN void GDALDatasetShadow___WriteCArrayItem_GDAL_GCP(GDALDatasetShadow *self,GDAL_GCP *carray,int index,GDAL_GCP *value){
       carray[index] = *value;
    }
SWIGINTERN GDAL_GCP *GDALDatasetShadow___ReadCArrayItem_GDAL_GCP(GDALDatasetShadow *self,GDAL_GCP *carray,int index){
       return &carray[index];
    }
SWIGINTERN GDAL_GCP *GDALDatasetShadow___AllocCArray_GDAL_GCP(GDALDatasetShadow *self,int size){
       return (GDAL_GCP*)CPLMalloc(size * sizeof(GDAL_GCP));
    }
SWIGINTERN void GDALDatasetShadow___FreeCArray_GDAL_GCP(GDALDatasetShadow *self,GDAL_GCP *carray){
       if (carray)
        CPLFree(carray);
    }

int GDALDatasetShadow_RasterXSize_get( GDALDatasetShadow *h ) {
  return GDALGetRasterXSize( h );
}
int GDALDatasetShadow_RasterYSize_get( GDALDatasetShadow *h ) {
  return GDALGetRasterYSize( h );
}
int GDALDatasetShadow_RasterCount_get( GDALDatasetShadow *h ) {
  return GDALGetRasterCount( h );
}


/* Returned size is in bytes or 0 if an error occurred. */
static
GIntBig ComputeBandRasterIOSize (int buf_xsize, int buf_ysize, int nPixelSize,
                                 GIntBig nPixelSpace, GIntBig nLineSpace,
                                 int bSpacingShouldBeMultipleOfPixelSize )
{
    if (buf_xsize <= 0 || buf_ysize <= 0)
    {
        CPLError(CE_Failure, CPLE_IllegalArg, "Illegal values for buffer size");
        return 0;
    }

    if (nPixelSpace < 0 || nLineSpace < 0)
    {
        CPLError(CE_Failure, CPLE_IllegalArg, "Illegal values for space arguments");
        return 0;
    }

    if (nPixelSize == 0)
    {
        CPLError(CE_Failure, CPLE_IllegalArg, "Illegal value for data type");
        return 0;
    }

    if( nPixelSpace == 0 )
        nPixelSpace = nPixelSize;
    else if ( bSpacingShouldBeMultipleOfPixelSize && (nPixelSpace % nPixelSize) != 0 )
    {
        CPLError(CE_Failure, CPLE_IllegalArg, "nPixelSpace should be a multiple of nPixelSize");
        return 0;
    }

    if( nLineSpace == 0 )
    {
        nLineSpace = nPixelSpace * buf_xsize;
    }
    else if ( bSpacingShouldBeMultipleOfPixelSize && (nLineSpace % nPixelSize) != 0 )
    {
        CPLError(CE_Failure, CPLE_IllegalArg, "nLineSpace should be a multiple of nPixelSize");
        return 0;
    }

    GIntBig nRet = (GIntBig)(buf_ysize - 1) * nLineSpace + (GIntBig)(buf_xsize - 1) * nPixelSpace + nPixelSize;
#if SIZEOF_VOIDP == 4
    if (nRet > INT_MAX)
    {
        CPLError(CE_Failure, CPLE_IllegalArg, "Integer overflow");
        return 0;
    }
#endif

    return nRet;
}

SWIGINTERN GDALDatasetShadow *GDALRasterBandShadow_GetDataset(GDALRasterBandShadow *self){
    return (GDALDatasetShadow*) GDALGetBandDataset(self);
  }
SWIGINTERN int GDALRasterBandShadow_GetBand(GDALRasterBandShadow *self){
    return GDALGetBandNumber(self);
  }
SWIGINTERN void GDALRasterBandShadow_GetBlockSize(GDALRasterBandShadow *self,int *pnBlockXSize,int *pnBlockYSize){
      GDALGetBlockSize(self, pnBlockXSize, pnBlockYSize);
  }
SWIGINTERN GDALColorInterp GDALRasterBandShadow_GetColorInterpretation(GDALRasterBandShadow *self){
    return GDALGetRasterColorInterpretation( self );
  }
SWIGINTERN GDALColorInterp GDALRasterBandShadow_GetRasterColorInterpretation(GDALRasterBandShadow *self){
    return GDALGetRasterColorInterpretation( self );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_SetColorInterpretation(GDALRasterBandShadow *self,GDALColorInterp val){
    return GDALSetRasterColorInterpretation( self, val );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_SetRasterColorInterpretation(GDALRasterBandShadow *self,GDALColorInterp val){
    return GDALSetRasterColorInterpretation( self, val );
  }
SWIGINTERN void GDALRasterBandShadow_GetNoDataValue(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterNoDataValue( self, hasval );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_SetNoDataValue(GDALRasterBandShadow *self,double d){
    return GDALSetRasterNoDataValue( self, d );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_DeleteNoDataValue(GDALRasterBandShadow *self){
    return GDALDeleteRasterNoDataValue( self );
  }
SWIGINTERN char const *GDALRasterBandShadow_GetUnitType(GDALRasterBandShadow *self){
      return GDALGetRasterUnitType( self );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_SetUnitType(GDALRasterBandShadow *self,char const *val){
    return GDALSetRasterUnitType( self, val );
  }
SWIGINTERN char **GDALRasterBandShadow_GetRasterCategoryNames(GDALRasterBandShadow *self){
    return GDALGetRasterCategoryNames( self );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_SetRasterCategoryNames(GDALRasterBandShadow *self,char **names){
    return GDALSetRasterCategoryNames( self, names );
  }
SWIGINTERN void GDALRasterBandShadow_GetMinimum(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterMinimum( self, hasval );
  }
SWIGINTERN void GDALRasterBandShadow_GetMaximum(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterMaximum( self, hasval );
  }
SWIGINTERN void GDALRasterBandShadow_GetOffset(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterOffset( self, hasval );
  }
SWIGINTERN void GDALRasterBandShadow_GetScale(GDALRasterBandShadow *self,double *val,int *hasval){
    *val = GDALGetRasterScale( self, hasval );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_SetOffset(GDALRasterBandShadow *self,double val){
    return GDALSetRasterOffset( self, val );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_SetScale(GDALRasterBandShadow *self,double val){
    return GDALSetRasterScale( self, val );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_GetStatistics(GDALRasterBandShadow *self,int approx_ok,int force,double *min,double *max,double *mean,double *stddev){
    if (min) *min = 0;
    if (max) *max = 0;
    if (mean) *mean = 0;
    if (stddev) *stddev = -1; /* This is the only way to recognize from Python if GetRasterStatistics() has updated the values */
    return GDALGetRasterStatistics( self, approx_ok, force,
				    min, max, mean, stddev );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_ComputeStatistics(GDALRasterBandShadow *self,bool approx_ok,double *min=NULL,double *max=NULL,double *mean=NULL,double *stddev=NULL,GDALProgressFunc callback=NULL,void *callback_data=NULL){
    return GDALComputeRasterStatistics( self, approx_ok, min, max, mean, stddev, callback, callback_data );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_SetStatistics(GDALRasterBandShadow *self,double min,double max,double mean,double stddev){
    return GDALSetRasterStatistics( self, min, max, mean, stddev );
  }
SWIGINTERN int GDALRasterBandShadow_GetOverviewCount(GDALRasterBandShadow *self){
    return GDALGetOverviewCount( self );
  }
SWIGINTERN GDALRasterBandShadow *GDALRasterBandShadow_GetOverview(GDALRasterBandShadow *self,int i){
    return (GDALRasterBandShadow*) GDALGetOverview( self, i );
  }
SWIGINTERN int GDALRasterBandShadow_Checksum(GDALRasterBandShadow *self,int xoff=0,int yoff=0,int *xsize=0,int *ysize=0){
    int nxsize = (xsize!=0) ? *xsize : GDALGetRasterBandXSize( self );
    int nysize = (ysize!=0) ? *ysize : GDALGetRasterBandYSize( self );
    return GDALChecksumImage( self, xoff, yoff, nxsize, nysize );
  }
SWIGINTERN void GDALRasterBandShadow_ComputeRasterMinMax(GDALRasterBandShadow *self,double argout[2],int approx_ok=0){
    GDALComputeRasterMinMax( self, approx_ok, argout );
  }
SWIGINTERN void GDALRasterBandShadow_ComputeBandStats(GDALRasterBandShadow *self,double argout[2],int samplestep=1){
    GDALComputeBandStats( self, samplestep, argout+0, argout+1,
                          NULL, NULL );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_Fill(GDALRasterBandShadow *self,double real_fill,double imag_fill=0.0){
    return GDALFillRaster( self, real_fill, imag_fill );
  }
SWIGINTERN void GDALRasterBandShadow_FlushCache(GDALRasterBandShadow *self){
    GDALFlushRasterCache( self );
  }
SWIGINTERN GDALColorTableShadow *GDALRasterBandShadow_GetRasterColorTable(GDALRasterBandShadow *self){
    return (GDALColorTableShadow*) GDALGetRasterColorTable( self );
  }
SWIGINTERN GDALColorTableShadow *GDALRasterBandShadow_GetColorTable(GDALRasterBandShadow *self){
    return (GDALColorTableShadow*) GDALGetRasterColorTable( self );
  }
SWIGINTERN int GDALRasterBandShadow_SetRasterColorTable(GDALRasterBandShadow *self,GDALColorTableShadow *arg){
    return GDALSetRasterColorTable( self, arg );
  }
SWIGINTERN int GDALRasterBandShadow_SetColorTable(GDALRasterBandShadow *self,GDALColorTableShadow *arg){
    return GDALSetRasterColorTable( self, arg );
  }
SWIGINTERN GDALRasterAttributeTableShadow *GDALRasterBandShadow_GetDefaultRAT(GDALRasterBandShadow *self){
      return (GDALRasterAttributeTableShadow*) GDALGetDefaultRAT(self);
  }
SWIGINTERN int GDALRasterBandShadow_SetDefaultRAT(GDALRasterBandShadow *self,GDALRasterAttributeTableShadow *table){
      return GDALSetDefaultRAT(self, table);
  }
SWIGINTERN GDALRasterBandShadow *GDALRasterBandShadow_GetMaskBand(GDALRasterBandShadow *self){
      return (GDALRasterBandShadow *) GDALGetMaskBand( self );
  }
SWIGINTERN int GDALRasterBandShadow_GetMaskFlags(GDALRasterBandShadow *self){
      return GDALGetMaskFlags( self );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_CreateMaskBand(GDALRasterBandShadow *self,int nFlags){
      return GDALCreateMaskBand( self, nFlags );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_GetHistogram(GDALRasterBandShadow *self,double min=-0.5,double max=255.5,int buckets=256,int *panHistogram=NULL,int include_out_of_range=0,int approx_ok=1,GDALProgressFunc callback=NULL,void *callback_data=NULL){
    CPLErrorReset();
    CPLErr err = GDALGetRasterHistogram( self, min, max, buckets, panHistogram,
                                         include_out_of_range, approx_ok,
                                         callback, callback_data );
    return err;
  }
SWIGINTERN CPLErr GDALRasterBandShadow_GetDefaultHistogram(GDALRasterBandShadow *self,double *min_ret=NULL,double *max_ret=NULL,int *buckets_ret=NULL,int **ppanHistogram=NULL,int force=1,GDALProgressFunc callback=NULL,void *callback_data=NULL){
    return GDALGetDefaultHistogram( self, min_ret, max_ret, buckets_ret,
                                    ppanHistogram, force,
                                    callback, callback_data );
}
SWIGINTERN CPLErr GDALRasterBandShadow_SetDefaultHistogram(GDALRasterBandShadow *self,double min,double max,int buckets_in,int *panHistogram_in){
    return GDALSetDefaultHistogram( self, min, max,
    	   			    buckets_in, panHistogram_in );
}
SWIGINTERN bool GDALRasterBandShadow_HasArbitraryOverviews(GDALRasterBandShadow *self){
      return (GDALHasArbitraryOverviews( self ) != 0) ? true : false;
  }
SWIGINTERN char **GDALRasterBandShadow_GetCategoryNames(GDALRasterBandShadow *self){
    return GDALGetRasterCategoryNames( self );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_SetCategoryNames(GDALRasterBandShadow *self,char **papszCategoryNames){
    return GDALSetRasterCategoryNames( self, papszCategoryNames );
  }
SWIGINTERN CPLErr GDALRasterBandShadow_ReadRaster(GDALRasterBandShadow *self,int xOff,int yOff,int xSize,int ySize,void *buffer,int buf_xSize,int buf_ySize,GDALDataType buf_type,int pixelSpace,int lineSpace){
       return GDALRasterIO( self, GF_Read, xOff, yOff, xSize, ySize,
		        buffer, buf_xSize, buf_ySize, buf_type, pixelSpace, lineSpace );
    }
SWIGINTERN CPLErr GDALRasterBandShadow_WriteRaster(GDALRasterBandShadow *self,int xOff,int yOff,int xSize,int ySize,void *buffer,int buf_xSize,int buf_ySize,GDALDataType buf_type,int pixelSpace,int lineSpace){
       return GDALRasterIO( self, GF_Write, xOff, yOff, xSize, ySize,
		        buffer, buf_xSize, buf_ySize, buf_type, pixelSpace, lineSpace );
    }

GDALDataType GDALRasterBandShadow_DataType_get( GDALRasterBandShadow *h ) {
  return GDALGetRasterDataType( h );
}
int GDALRasterBandShadow_XSize_get( GDALRasterBandShadow *h ) {
  return GDALGetRasterBandXSize( h );
}
int GDALRasterBandShadow_YSize_get( GDALRasterBandShadow *h ) {
  return GDALGetRasterBandYSize( h );
}

SWIGINTERN GDALColorTableShadow *new_GDALColorTableShadow(GDALPaletteInterp palette=GPI_RGB){
        return (GDALColorTableShadow*) GDALCreateColorTable(palette);
    }
SWIGINTERN void delete_GDALColorTableShadow(GDALColorTableShadow *self){
        GDALDestroyColorTable(self);
    }
SWIGINTERN GDALColorTableShadow *GDALColorTableShadow_Clone(GDALColorTableShadow *self){
        return (GDALColorTableShadow*) GDALCloneColorTable (self);
    }
SWIGINTERN GDALPaletteInterp GDALColorTableShadow_GetPaletteInterpretation(GDALColorTableShadow *self){
        return GDALGetPaletteInterpretation(self);
    }
SWIGINTERN int GDALColorTableShadow_GetColorEntryCount(GDALColorTableShadow *self){
        return GDALGetColorEntryCount(self);
    }
SWIGINTERN GDALColorEntry *GDALColorTableShadow_GetColorEntry(GDALColorTableShadow *self,int entry){
        return (GDALColorEntry*) GDALGetColorEntry(self, entry);
    }
SWIGINTERN int GDALColorTableShadow_GetColorEntryAsRGB(GDALColorTableShadow *self,int entry,GDALColorEntry *centry){
        return GDALGetColorEntryAsRGB(self, entry, centry);
    }
SWIGINTERN void GDALColorTableShadow_SetColorEntry(GDALColorTableShadow *self,int entry,GDALColorEntry const *centry){
        GDALSetColorEntry(self, entry, centry);
    }
SWIGINTERN void GDALColorTableShadow_CreateColorRamp(GDALColorTableShadow *self,int nStartIndex,GDALColorEntry const *startcolor,int nEndIndex,GDALColorEntry const *endcolor){
        GDALCreateColorRamp(self, nStartIndex, startcolor, nEndIndex, endcolor);
    }
SWIGINTERN GDALRasterAttributeTableShadow *new_GDALRasterAttributeTableShadow(){
        return (GDALRasterAttributeTableShadow*)
		GDALCreateRasterAttributeTable();
    }
SWIGINTERN void delete_GDALRasterAttributeTableShadow(GDALRasterAttributeTableShadow *self){
        GDALDestroyRasterAttributeTable(self);
    }
SWIGINTERN GDALRasterAttributeTableShadow *GDALRasterAttributeTableShadow_Clone(GDALRasterAttributeTableShadow *self){
        return (GDALRasterAttributeTableShadow*) GDALRATClone(self);
    }
SWIGINTERN int GDALRasterAttributeTableShadow_GetColumnCount(GDALRasterAttributeTableShadow *self){
        return GDALRATGetColumnCount( self );
    }
SWIGINTERN char const *GDALRasterAttributeTableShadow_GetNameOfCol(GDALRasterAttributeTableShadow *self,int iCol){
        return GDALRATGetNameOfCol( self, iCol );
    }
SWIGINTERN GDALRATFieldUsage GDALRasterAttributeTableShadow_GetUsageOfCol(GDALRasterAttributeTableShadow *self,int iCol){
        return GDALRATGetUsageOfCol( self, iCol );
    }
SWIGINTERN GDALRATFieldType GDALRasterAttributeTableShadow_GetTypeOfCol(GDALRasterAttributeTableShadow *self,int iCol){
        return GDALRATGetTypeOfCol( self, iCol );
    }
SWIGINTERN int GDALRasterAttributeTableShadow_GetColOfUsage(GDALRasterAttributeTableShadow *self,GDALRATFieldUsage eUsage){
        return GDALRATGetColOfUsage( self, eUsage );
    }
SWIGINTERN int GDALRasterAttributeTableShadow_GetRowCount(GDALRasterAttributeTableShadow *self){
        return GDALRATGetRowCount( self );
    }
SWIGINTERN char const *GDALRasterAttributeTableShadow_GetValueAsString(GDALRasterAttributeTableShadow *self,int iRow,int iCol){
        return GDALRATGetValueAsString( self, iRow, iCol );
    }
SWIGINTERN int GDALRasterAttributeTableShadow_GetValueAsInt(GDALRasterAttributeTableShadow *self,int iRow,int iCol){
        return GDALRATGetValueAsInt( self, iRow, iCol );
    }
SWIGINTERN double GDALRasterAttributeTableShadow_GetValueAsDouble(GDALRasterAttributeTableShadow *self,int iRow,int iCol){
        return GDALRATGetValueAsDouble( self, iRow, iCol );
    }
SWIGINTERN void GDALRasterAttributeTableShadow_SetValueAsString(GDALRasterAttributeTableShadow *self,int iRow,int iCol,char const *pszValue){
        GDALRATSetValueAsString( self, iRow, iCol, pszValue );
    }
SWIGINTERN void GDALRasterAttributeTableShadow_SetValueAsInt(GDALRasterAttributeTableShadow *self,int iRow,int iCol,int nValue){
        GDALRATSetValueAsInt( self, iRow, iCol, nValue );
    }
SWIGINTERN void GDALRasterAttributeTableShadow_SetValueAsDouble(GDALRasterAttributeTableShadow *self,int iRow,int iCol,double dfValue){
        GDALRATSetValueAsDouble( self, iRow, iCol, dfValue );
    }
SWIGINTERN void GDALRasterAttributeTableShadow_SetRowCount(GDALRasterAttributeTableShadow *self,int nCount){
        GDALRATSetRowCount( self, nCount );
    }
SWIGINTERN int GDALRasterAttributeTableShadow_CreateColumn(GDALRasterAttributeTableShadow *self,char const *pszName,GDALRATFieldType eType,GDALRATFieldUsage eUsage){
        return GDALRATCreateColumn( self, pszName, eType, eUsage );
    }
SWIGINTERN bool GDALRasterAttributeTableShadow_GetLinearBinning(GDALRasterAttributeTableShadow *self,double *pdfRow0Min,double *pdfBinSize){
        return (GDALRATGetLinearBinning(self, pdfRow0Min, pdfBinSize) != 0) ? true : false;
    }
SWIGINTERN int GDALRasterAttributeTableShadow_SetLinearBinning(GDALRasterAttributeTableShadow *self,double dfRow0Min,double dfBinSize){
        return GDALRATSetLinearBinning(self, dfRow0Min, dfBinSize);
    }
SWIGINTERN int GDALRasterAttributeTableShadow_GetRowOfValue(GDALRasterAttributeTableShadow *self,double dfValue){
        return GDALRATGetRowOfValue( self, dfValue );
    }
SWIGINTERN int GDALRasterAttributeTableShadow_ChangesAreWrittenToFile(GDALRasterAttributeTableShadow *self){
        return GDALRATChangesAreWrittenToFile( self );
    }
SWIGINTERN void GDALRasterAttributeTableShadow_DumpReadable(GDALRasterAttributeTableShadow *self){
        GDALRATDumpReadable( self, NULL );
    }

#include "gdalgrid.h"

#ifdef DEBUG
typedef struct OGRLayerHS OGRLayerShadow;
typedef struct OGRGeometryHS OGRGeometryShadow;
#else
typedef void OGRLayerShadow;
typedef void OGRGeometryShadow;
#endif


int  ComputeMedianCutPCT ( GDALRasterBandShadow *red,
                              GDALRasterBandShadow *green,
                              GDALRasterBandShadow *blue,
                              int num_colors,
                              GDALColorTableShadow* colors,
                              GDALProgressFunc callback = NULL,
                              void* callback_data=NULL) {

    CPLErrorReset();

    int err = GDALComputeMedianCutPCT( red,
                                          green,
                                          blue,
                                          NULL,
                                          num_colors,
                                          colors,
                                          callback,
                                          callback_data);

    return err;
}


int  DitherRGB2PCT ( GDALRasterBandShadow *red,
                     GDALRasterBandShadow *green,
                     GDALRasterBandShadow *blue,
                     GDALRasterBandShadow *target,
                     GDALColorTableShadow *colors,
                     GDALProgressFunc callback = NULL,
                     void* callback_data=NULL) {

    CPLErrorReset();
    int err;
    err = GDALDitherRGB2PCT(  red,
                                  green,
                                  blue,
                                  target,
                                  colors,
                                  callback,
                                  callback_data);

    return err;
}


CPLErr  ReprojectImage ( GDALDatasetShadow *src_ds,
                         GDALDatasetShadow *dst_ds,
                         const char *src_wkt=NULL,
                         const char *dst_wkt=NULL,
                         GDALResampleAlg eResampleAlg=GRA_NearestNeighbour,
                         double WarpMemoryLimit=0.0,
                         double maxerror = 0.0,
			 GDALProgressFunc callback = NULL,
                     	 void* callback_data=NULL,
                         char** options = NULL ) {

    CPLErrorReset();

    GDALWarpOptions* psOptions = NULL;
    if( options != NULL )
    {
        psOptions = GDALCreateWarpOptions();
        psOptions->papszWarpOptions = CSLDuplicate(options);
    }

    CPLErr err = GDALReprojectImage( src_ds,
                                     src_wkt,
                                     dst_ds,
                                     dst_wkt,
                                     eResampleAlg,
                                     WarpMemoryLimit,
                                     maxerror,
                                     callback,
                                     callback_data,
                                     psOptions);

    if( psOptions != NULL )
        GDALDestroyWarpOptions(psOptions);

    return err;
}


int  ComputeProximity( GDALRasterBandShadow *srcBand,
                       GDALRasterBandShadow *proximityBand,
                       char **options = NULL,
                       GDALProgressFunc callback=NULL,
                       void* callback_data=NULL) {

    CPLErrorReset();

    return GDALComputeProximity( srcBand, proximityBand, options,
                                 callback, callback_data );
}


int  RasterizeLayer( GDALDatasetShadow *dataset,
                 int bands, int *band_list,
                 OGRLayerShadow *layer,
                 void *pfnTransformer = NULL,
                 void *pTransformArg = NULL,
		 int burn_values = 0, double *burn_values_list = NULL,
                 char **options = NULL,
                 GDALProgressFunc callback=NULL,
                 void* callback_data=NULL) {

    CPLErr eErr;

    CPLErrorReset();

    if( burn_values == 0 )
    {
        burn_values_list = (double *) CPLMalloc(sizeof(double)*bands);
        for( int i = 0; i < bands; i++ )
            burn_values_list[i] = 255.0;
    }
    else if( burn_values != bands )
    {
        CPLError( CE_Failure, CPLE_AppDefined,
                  "Did not get the expected number of burn values in RasterizeLayer()" );
        return CE_Failure;
    }

    eErr = GDALRasterizeLayers( dataset, bands, band_list,
                                1, &layer,
                                (GDALTransformerFunc) pfnTransformer,
                                pTransformArg,
                                burn_values_list, options,
                                callback, callback_data );

    if( burn_values == 0 )
        CPLFree( burn_values_list );

    return eErr;
}


int  Polygonize( GDALRasterBandShadow *srcBand,
     		 GDALRasterBandShadow *maskBand,
  	         OGRLayerShadow *outLayer,
                 int iPixValField,
                 char **options = NULL,
                 GDALProgressFunc callback=NULL,
                 void* callback_data=NULL) {

    CPLErrorReset();

    return GDALPolygonize( srcBand, maskBand, outLayer, iPixValField,
                           options, callback, callback_data );
}


int  FPolygonize( GDALRasterBandShadow *srcBand,
                 GDALRasterBandShadow *maskBand,
                 OGRLayerShadow *outLayer,
                 int iPixValField,
                 char **options = NULL,
                 GDALProgressFunc callback=NULL,
                 void* callback_data=NULL) {

    CPLErrorReset();

    return GDALFPolygonize( srcBand, maskBand, outLayer, iPixValField,
                           options, callback, callback_data );
}


int  FillNodata( GDALRasterBandShadow *targetBand,
     		 GDALRasterBandShadow *maskBand,
                 double maxSearchDist,
                 int smoothingIterations,
                 char **options = NULL,
                 GDALProgressFunc callback=NULL,
                 void* callback_data=NULL) {

    CPLErrorReset();

    return GDALFillNodata( targetBand, maskBand, maxSearchDist,
    	   		   0, smoothingIterations, options,
			   callback, callback_data );
}


int  SieveFilter( GDALRasterBandShadow *srcBand,
     		  GDALRasterBandShadow *maskBand,
  	          GDALRasterBandShadow *dstBand,
                  int threshold, int connectedness=4,
                  char **options = NULL,
                  GDALProgressFunc callback=NULL,
                  void* callback_data=NULL) {

    CPLErrorReset();

    return GDALSieveFilter( srcBand, maskBand, dstBand,
                            threshold, connectedness,
                            options, callback, callback_data );
}


int  RegenerateOverviews( GDALRasterBandShadow *srcBand,
     			  int overviewBandCount,
                          GDALRasterBandShadow **overviewBands,
                          const char *resampling = "average",
                          GDALProgressFunc callback=NULL,
                          void* callback_data=NULL) {

    CPLErrorReset();

    return GDALRegenerateOverviews( srcBand, overviewBandCount, overviewBands,
    	   			    resampling ? resampling : "average", callback, callback_data );
}


int  RegenerateOverview( GDALRasterBandShadow *srcBand,
                          GDALRasterBandShadow *overviewBand,
                          const char *resampling = "average",
                          GDALProgressFunc callback=NULL,
                          void* callback_data=NULL) {

    CPLErrorReset();

    return GDALRegenerateOverviews( srcBand, 1, &overviewBand,
    	   			    resampling ? resampling : "average", callback, callback_data );
}


int ContourGenerate( GDALRasterBandShadow *srcBand,
                     double contourInterval,
                     double contourBase,
                     int fixedLevelCount,
                     double *fixedLevels,
                     int useNoData,
                     double noDataValue,
                     OGRLayerShadow* dstLayer,
                     int idField,
                     int elevField,
                     GDALProgressFunc callback = NULL,
                     void* callback_data = NULL)
{
    CPLErr eErr;

    CPLErrorReset();

    eErr =  GDALContourGenerate( srcBand,
                                 contourInterval,
                                 contourBase,
                                 fixedLevelCount,
                                 fixedLevels,
                                 useNoData,
                                 noDataValue,
                                 dstLayer,
                                 idField,
                                 elevField,
                                 callback,
                                 callback_data);

    return eErr;
}


GDALDatasetShadow *AutoCreateWarpedVRT( GDALDatasetShadow *src_ds,
                                        const char *src_wkt = 0,
                                        const char *dst_wkt = 0,
                                        GDALResampleAlg eResampleAlg = GRA_NearestNeighbour,
                                        double maxerror = 0.0 ) {
  GDALDatasetShadow *ds = GDALAutoCreateWarpedVRT( src_ds, src_wkt,
                                                   dst_wkt,
                                                   eResampleAlg,
                                                   maxerror,
                                                   0 );
  if (ds == 0) {
    /*throw CPLGetLastErrorMsg(); causes a SWIG_exception later*/
  }
  return ds;

}


GDALDatasetShadow*  CreatePansharpenedVRT( const char* pszXML,
                            GDALRasterBandShadow* panchroBand,
                            int nInputSpectralBands,
                            GDALRasterBandShadow** ahInputSpectralBands )
{
    CPLErrorReset();

    return (GDALDatasetShadow*)GDALCreatePansharpenedVRT( pszXML, panchroBand,
                                      nInputSpectralBands, ahInputSpectralBands );
}

SWIGINTERN GDALTransformerInfoShadow *new_GDALTransformerInfoShadow(GDALDatasetShadow *src,GDALDatasetShadow *dst,char **options){
    GDALTransformerInfoShadow *obj = (GDALTransformerInfoShadow*)
       GDALCreateGenImgProjTransformer2( (GDALDatasetH)src, (GDALDatasetH)dst,
                                         options );
    return obj;
  }
SWIGINTERN void delete_GDALTransformerInfoShadow(GDALTransformerInfoShadow *self){
    GDALDestroyTransformer( self );
  }
SWIGINTERN int GDALTransformerInfoShadow_TransformPoint__SWIG_0(GDALTransformerInfoShadow *self,int bDstToSrc,double inout[3]){
    int nRet, nSuccess = TRUE;

    nRet = GDALUseTransformer( self, bDstToSrc,
                               1, &inout[0], &inout[1], &inout[2],
                               &nSuccess );

    return nRet && nSuccess;
  }
SWIGINTERN int GDALTransformerInfoShadow_TransformPoint__SWIG_1(GDALTransformerInfoShadow *self,double argout[3],int bDstToSrc,double x,double y,double z=0.0){
    int nRet, nSuccess = TRUE;

    argout[0] = x;
    argout[1] = y;
    argout[2] = z;
    nRet = GDALUseTransformer( self, bDstToSrc,
                               1, &argout[0], &argout[1], &argout[2],
                               &nSuccess );

    return nRet && nSuccess;
  }
SWIGINTERN int GDALTransformerInfoShadow_TransformPoints(GDALTransformerInfoShadow *self,int bDstToSrc,int nCount,double *x,double *y,double *z,int *panSuccess){
    int nRet;

    nRet = GDALUseTransformer( self, bDstToSrc, nCount, x, y, z, panSuccess );

    return nRet;
  }
SWIGINTERN int GDALTransformerInfoShadow_TransformGeolocations(GDALTransformerInfoShadow *self,GDALRasterBandShadow *xBand,GDALRasterBandShadow *yBand,GDALRasterBandShadow *zBand,GDALProgressFunc callback=NULL,void *callback_data=NULL,char **options=NULL){

    CPLErrorReset();

    return GDALTransformGeolocations( xBand, yBand, zBand,
                                      GDALUseTransformer, self,
                            	      callback, callback_data, options );
  }

GDALDatasetShadow* ApplyVerticalShiftGrid( GDALDatasetShadow *src_ds,
                                           GDALDatasetShadow *grid_ds,
                                           bool inverse = false,
                                           double srcUnitToMeter = 1.0,
                                           double dstUnitToMeter = 1.0,
                                           char** options = NULL ) {
  GDALDatasetShadow *ds = GDALApplyVerticalShiftGrid( src_ds, grid_ds,
                                                      inverse,
                                                      srcUnitToMeter,
                                                      dstUnitToMeter,
                                                      options );
  return ds;

}


int wrapper_GDALGetCacheMax()
{
    return GDALGetCacheMax();
}


int wrapper_GDALGetCacheUsed()
{
    return GDALGetCacheUsed();
}


void wrapper_GDALSetCacheMax(int nBytes)
{
    return GDALSetCacheMax(nBytes);
}


retStringAndCPLFree *GetJPEG2000StructureAsString( const char* pszFilename, char** options = NULL )
{
    CPLXMLNode* psNode = GDALGetJPEG2000Structure(pszFilename, options);
    if( psNode == NULL )
        return NULL;
    char* pszXML = CPLSerializeXMLTree(psNode);
    CPLDestroyXMLNode(psNode);
    return pszXML;
}


int GetDriverCount() {
  return GDALGetDriverCount();
}


static
GDALDriverShadow* GetDriverByName( char const *name ) {
  return (GDALDriverShadow*) GDALGetDriverByName( name );
}


GDALDriverShadow* GetDriver( int i ) {
  return (GDALDriverShadow*) GDALGetDriver( i );
}


GDALDatasetShadow* Open( char const* utf8_path, GDALAccess eAccess = GA_ReadOnly ) {
  CPLErrorReset();
  GDALDatasetShadow *ds = GDALOpen( utf8_path, eAccess );
  if( ds != NULL && CPLGetLastErrorType() == CE_Failure )
  {
      if ( GDALDereferenceDataset( ds ) <= 0 )
          GDALClose(ds);
      ds = NULL;
  }
  return (GDALDatasetShadow*) ds;
}


GDALDatasetShadow* OpenEx( char const* utf8_path, unsigned int nOpenFlags = 0,
                           char** allowed_drivers = NULL, char** open_options = NULL,
                           char** sibling_files = NULL ) {
  CPLErrorReset();
#ifdef SWIGPYTHON
  if( GetUseExceptions() )
      nOpenFlags |= GDAL_OF_VERBOSE_ERROR;
#endif
  GDALDatasetShadow *ds = GDALOpenEx( utf8_path, nOpenFlags, allowed_drivers,
                                      open_options, sibling_files );
  if( ds != NULL && CPLGetLastErrorType() == CE_Failure )
  {
      if ( GDALDereferenceDataset( ds ) <= 0 )
          GDALClose(ds);
      ds = NULL;
  }
  return (GDALDatasetShadow*) ds;
}


GDALDatasetShadow* OpenShared( char const* utf8_path, GDALAccess eAccess = GA_ReadOnly ) {
  CPLErrorReset();
  GDALDatasetShadow *ds = GDALOpenShared( utf8_path, eAccess );
  if( ds != NULL && CPLGetLastErrorType() == CE_Failure )
  {
      if ( GDALDereferenceDataset( ds ) <= 0 )
          GDALClose(ds);
      ds = NULL;
  }
  return (GDALDatasetShadow*) ds;
}


GDALDriverShadow *IdentifyDriver( const char *utf8_path,
                                  char **papszSiblings = NULL ) {
    return (GDALDriverShadow *) GDALIdentifyDriver( utf8_path,
	                                            papszSiblings );
}


GDALDriverShadow *IdentifyDriverEx( const char* utf8_path,
                                    unsigned int nIdentifyFlags = 0,
                                    char** allowed_drivers = NULL,
                                    char** sibling_files = NULL )
{
    return  (GDALDriverShadow *) GDALIdentifyDriverEx( utf8_path,
                                                nIdentifyFlags,
                                                allowed_drivers,
                                                sibling_files );
}


  char **GeneralCmdLineProcessor( char **papszArgv, int nOptions = 0 ) {
    int nResArgCount;

    if( papszArgv == NULL )
        return NULL;

    nResArgCount =
      GDALGeneralCmdLineProcessor( CSLCount(papszArgv), &papszArgv, nOptions );

    if( nResArgCount <= 0 )
        return NULL;
    else
        return papszArgv;
  }


    void __WriteCArrayItem_GDAL_GCP(GDAL_GCP* carray, int index, GDAL_GCP* value) {
       carray[index] = *value;
    }


    GDAL_GCP* __ReadCArrayItem_GDAL_GCP(GDAL_GCP* carray, int index) {
       return &carray[index];
    }


    GDAL_GCP* __AllocCArray_GDAL_GCP(int size) {
       return (GDAL_GCP*)CPLMalloc(size * sizeof(GDAL_GCP));
    }


    void __FreeCArray_GDAL_GCP(GDAL_GCP* carray) {
       if (carray)
        CPLFree(carray);
    }


#include "gdal_utils.h"

SWIGINTERN GDALInfoOptions *new_GDALInfoOptions(char **options){
        return GDALInfoOptionsNew(options, NULL);
    }
SWIGINTERN void delete_GDALInfoOptions(GDALInfoOptions *self){
        GDALInfoOptionsFree( self );
    }
SWIGINTERN GDALTranslateOptions *new_GDALTranslateOptions(char **options){
        return GDALTranslateOptionsNew(options, NULL);
    }
SWIGINTERN void delete_GDALTranslateOptions(GDALTranslateOptions *self){
        GDALTranslateOptionsFree( self );
    }

GDALDatasetShadow* wrapper_GDALTranslate( const char* dest,
                                      GDALDatasetShadow* dataset,
                                      GDALTranslateOptions* translateOptions,
                                      GDALProgressFunc callback=NULL,
                                      void* callback_data=NULL)
{
    int usageError; /* ignored */
    bool bFreeOptions = false;
    if( callback )
    {
        if( translateOptions == NULL )
        {
            bFreeOptions = true;
            translateOptions = GDALTranslateOptionsNew(NULL, NULL);
        }
        GDALTranslateOptionsSetProgress(translateOptions, callback, callback_data);
    }
    GDALDatasetH hDSRet = GDALTranslate(dest, dataset, translateOptions, &usageError);
    if( bFreeOptions )
        GDALTranslateOptionsFree(translateOptions);
    return hDSRet;
}

SWIGINTERN GDALWarpAppOptions *new_GDALWarpAppOptions(char **options){
        return GDALWarpAppOptionsNew(options, NULL);
    }
SWIGINTERN void delete_GDALWarpAppOptions(GDALWarpAppOptions *self){
        GDALWarpAppOptionsFree( self );
    }

int wrapper_GDALWarpDestDS( GDALDatasetShadow* dstDS,
                            int object_list_count, GDALDatasetShadow** poObjects,
                            GDALWarpAppOptions* warpAppOptions,
                            GDALProgressFunc callback=NULL,
                            void* callback_data=NULL)
{
    int usageError; /* ignored */
    bool bFreeOptions = false;
    if( callback )
    {
        if( warpAppOptions == NULL )
        {
            bFreeOptions = true;
            warpAppOptions = GDALWarpAppOptionsNew(NULL, NULL);
        }
        GDALWarpAppOptionsSetProgress(warpAppOptions, callback, callback_data);
    }
    int bRet = (GDALWarp(NULL, dstDS, object_list_count, poObjects, warpAppOptions, &usageError) != NULL);
    if( bFreeOptions )
        GDALWarpAppOptionsFree(warpAppOptions);
    return bRet;
}


GDALDatasetShadow* wrapper_GDALWarpDestName( const char* dest,
                                             int object_list_count, GDALDatasetShadow** poObjects,
                                             GDALWarpAppOptions* warpAppOptions,
                                             GDALProgressFunc callback=NULL,
                                             void* callback_data=NULL)
{
    int usageError; /* ignored */
    bool bFreeOptions = false;
    if( callback )
    {
        if( warpAppOptions == NULL )
        {
            bFreeOptions = true;
            warpAppOptions = GDALWarpAppOptionsNew(NULL, NULL);
        }
        GDALWarpAppOptionsSetProgress(warpAppOptions, callback, callback_data);
    }
    GDALDatasetH hDSRet = GDALWarp(dest, NULL, object_list_count, poObjects, warpAppOptions, &usageError);
    if( bFreeOptions )
        GDALWarpAppOptionsFree(warpAppOptions);
    return hDSRet;
}

SWIGINTERN GDALVectorTranslateOptions *new_GDALVectorTranslateOptions(char **options){
        return GDALVectorTranslateOptionsNew(options, NULL);
    }
SWIGINTERN void delete_GDALVectorTranslateOptions(GDALVectorTranslateOptions *self){
        GDALVectorTranslateOptionsFree( self );
    }

int wrapper_GDALVectorTranslateDestDS( GDALDatasetShadow* dstDS,
                                       GDALDatasetShadow* srcDS,
                            GDALVectorTranslateOptions* options,
                            GDALProgressFunc callback=NULL,
                            void* callback_data=NULL)
{
    int usageError; /* ignored */
    bool bFreeOptions = false;
    if( callback )
    {
        if( options == NULL )
        {
            bFreeOptions = true;
            options = GDALVectorTranslateOptionsNew(NULL, NULL);
        }
        GDALVectorTranslateOptionsSetProgress(options, callback, callback_data);
    }
    int bRet = (GDALVectorTranslate(NULL, dstDS, 1, &srcDS, options, &usageError) != NULL);
    if( bFreeOptions )
        GDALVectorTranslateOptionsFree(options);
    return bRet;
}


GDALDatasetShadow* wrapper_GDALVectorTranslateDestName( const char* dest,
                                             GDALDatasetShadow* srcDS,
                                             GDALVectorTranslateOptions* options,
                                             GDALProgressFunc callback=NULL,
                                             void* callback_data=NULL)
{
    int usageError; /* ignored */
    bool bFreeOptions = false;
    if( callback )
    {
        if( options == NULL )
        {
            bFreeOptions = true;
            options = GDALVectorTranslateOptionsNew(NULL, NULL);
        }
        GDALVectorTranslateOptionsSetProgress(options, callback, callback_data);
    }
    GDALDatasetH hDSRet = GDALVectorTranslate(dest, NULL, 1, &srcDS, options, &usageError);
    if( bFreeOptions )
        GDALVectorTranslateOptionsFree(options);
    return hDSRet;
}

SWIGINTERN GDALDEMProcessingOptions *new_GDALDEMProcessingOptions(char **options){
        return GDALDEMProcessingOptionsNew(options, NULL);
    }
SWIGINTERN void delete_GDALDEMProcessingOptions(GDALDEMProcessingOptions *self){
        GDALDEMProcessingOptionsFree( self );
    }

GDALDatasetShadow* wrapper_GDALDEMProcessing( const char* dest,
                                      GDALDatasetShadow* dataset,
                                      const char* pszProcessing,
                                      const char* pszColorFilename,
                                      GDALDEMProcessingOptions* options,
                                      GDALProgressFunc callback=NULL,
                                      void* callback_data=NULL)
{
    int usageError; /* ignored */
    bool bFreeOptions = false;
    if( callback )
    {
        if( options == NULL )
        {
            bFreeOptions = true;
            options = GDALDEMProcessingOptionsNew(NULL, NULL);
        }
        GDALDEMProcessingOptionsSetProgress(options, callback, callback_data);
    }
    GDALDatasetH hDSRet = GDALDEMProcessing(dest, dataset, pszProcessing, pszColorFilename, options, &usageError);
    if( bFreeOptions )
        GDALDEMProcessingOptionsFree(options);
    return hDSRet;
}

SWIGINTERN GDALNearblackOptions *new_GDALNearblackOptions(char **options){
        return GDALNearblackOptionsNew(options, NULL);
    }
SWIGINTERN void delete_GDALNearblackOptions(GDALNearblackOptions *self){
        GDALNearblackOptionsFree( self );
    }

int wrapper_GDALNearblackDestDS( GDALDatasetShadow* dstDS,
                            GDALDatasetShadow* srcDS,
                            GDALNearblackOptions* options,
                            GDALProgressFunc callback=NULL,
                            void* callback_data=NULL)
{
    int usageError; /* ignored */
    bool bFreeOptions = false;
    if( callback )
    {
        if( options == NULL )
        {
            bFreeOptions = true;
            options = GDALNearblackOptionsNew(NULL, NULL);
        }
        GDALNearblackOptionsSetProgress(options, callback, callback_data);
    }
    int bRet = (GDALNearblack(NULL, dstDS, srcDS, options, &usageError) != NULL);
    if( bFreeOptions )
        GDALNearblackOptionsFree(options);
    return bRet;
}


GDALDatasetShadow* wrapper_GDALNearblackDestName( const char* dest,
                                             GDALDatasetShadow* srcDS,
                                             GDALNearblackOptions* options,
                                             GDALProgressFunc callback=NULL,
                                             void* callback_data=NULL)
{
    int usageError; /* ignored */
    bool bFreeOptions = false;
    if( callback )
    {
        if( options == NULL )
        {
            bFreeOptions = true;
            options = GDALNearblackOptionsNew(NULL, NULL);
        }
        GDALNearblackOptionsSetProgress(options, callback, callback_data);
    }
    GDALDatasetH hDSRet = GDALNearblack(dest, NULL, srcDS, options, &usageError);
    if( bFreeOptions )
        GDALNearblackOptionsFree(options);
    return hDSRet;
}

SWIGINTERN GDALGridOptions *new_GDALGridOptions(char **options){
        return GDALGridOptionsNew(options, NULL);
    }
SWIGINTERN void delete_GDALGridOptions(GDALGridOptions *self){
        GDALGridOptionsFree( self );
    }

GDALDatasetShadow* wrapper_GDALGrid( const char* dest,
                                      GDALDatasetShadow* dataset,
                                      GDALGridOptions* options,
                                      GDALProgressFunc callback=NULL,
                                      void* callback_data=NULL)
{
    int usageError; /* ignored */
    bool bFreeOptions = false;
    if( callback )
    {
        if( options == NULL )
        {
            bFreeOptions = true;
            options = GDALGridOptionsNew(NULL, NULL);
        }
        GDALGridOptionsSetProgress(options, callback, callback_data);
    }
    GDALDatasetH hDSRet = GDALGrid(dest, dataset, options, &usageError);
    if( bFreeOptions )
        GDALGridOptionsFree(options);
    return hDSRet;
}

SWIGINTERN GDALRasterizeOptions *new_GDALRasterizeOptions(char **options){
        return GDALRasterizeOptionsNew(options, NULL);
    }
SWIGINTERN void delete_GDALRasterizeOptions(GDALRasterizeOptions *self){
        GDALRasterizeOptionsFree( self );
    }

int wrapper_GDALRasterizeDestDS( GDALDatasetShadow* dstDS,
                            GDALDatasetShadow* srcDS,
                            GDALRasterizeOptions* options,
                            GDALProgressFunc callback=NULL,
                            void* callback_data=NULL)
{
    int usageError; /* ignored */
    bool bFreeOptions = false;
    if( callback )
    {
        if( options == NULL )
        {
            bFreeOptions = true;
            options = GDALRasterizeOptionsNew(NULL, NULL);
        }
        GDALRasterizeOptionsSetProgress(options, callback, callback_data);
    }
    int bRet = (GDALRasterize(NULL, dstDS, srcDS, options, &usageError) != NULL);
    if( bFreeOptions )
        GDALRasterizeOptionsFree(options);
    return bRet;
}


GDALDatasetShadow* wrapper_GDALRasterizeDestName( const char* dest,
                                             GDALDatasetShadow* srcDS,
                                             GDALRasterizeOptions* options,
                                             GDALProgressFunc callback=NULL,
                                             void* callback_data=NULL)
{
    int usageError; /* ignored */
    bool bFreeOptions = false;
    if( callback )
    {
        if( options == NULL )
        {
            bFreeOptions = true;
            options = GDALRasterizeOptionsNew(NULL, NULL);
        }
        GDALRasterizeOptionsSetProgress(options, callback, callback_data);
    }
    GDALDatasetH hDSRet = GDALRasterize(dest, NULL, srcDS, options, &usageError);
    if( bFreeOptions )
        GDALRasterizeOptionsFree(options);
    return hDSRet;
}

SWIGINTERN GDALBuildVRTOptions *new_GDALBuildVRTOptions(char **options){
        return GDALBuildVRTOptionsNew(options, NULL);
    }
SWIGINTERN void delete_GDALBuildVRTOptions(GDALBuildVRTOptions *self){
        GDALBuildVRTOptionsFree( self );
    }

GDALDatasetShadow* wrapper_GDALBuildVRT_objects( const char* dest,
                                             int object_list_count, GDALDatasetShadow** poObjects,
                                             GDALBuildVRTOptions* options,
                                             GDALProgressFunc callback=NULL,
                                             void* callback_data=NULL)
{
    int usageError; /* ignored */
    bool bFreeOptions = false;
    if( callback )
    {
        if( options == NULL )
        {
            bFreeOptions = true;
            options = GDALBuildVRTOptionsNew(NULL, NULL);
        }
        GDALBuildVRTOptionsSetProgress(options, callback, callback_data);
    }
    GDALDatasetH hDSRet = GDALBuildVRT(dest, object_list_count, poObjects, NULL, options, &usageError);
    if( bFreeOptions )
        GDALBuildVRTOptionsFree(options);
    return hDSRet;
}


GDALDatasetShadow* wrapper_GDALBuildVRT_names( const char* dest,
                                         char ** source_filenames,
                                         GDALBuildVRTOptions* options,
                                         GDALProgressFunc callback=NULL,
                                         void* callback_data=NULL)
{
    int usageError; /* ignored */
    bool bFreeOptions = false;
    if( callback )
    {
        if( options == NULL )
        {
            bFreeOptions = true;
            options = GDALBuildVRTOptionsNew(NULL, NULL);
        }
        GDALBuildVRTOptionsSetProgress(options, callback, callback_data);
    }
    GDALDatasetH hDSRet = GDALBuildVRT(dest, CSLCount(source_filenames), NULL, source_filenames, options, &usageError);
    if( bFreeOptions )
        GDALBuildVRTOptionsFree(options);
    return hDSRet;
}


#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT void SWIGSTDCALL CSharp_UseExceptions() {
  UseExceptions();
}


SWIGEXPORT void SWIGSTDCALL CSharp_DontUseExceptions() {
  DontUseExceptions();
}


SWIGEXPORT void SWIGSTDCALL CSharp_StringListDestroy(void * jarg1) {
  void *arg1 = (void *) 0 ;
  
  arg1 = (void *)jarg1; 
  {
    CPLErrorReset();
    StringListDestroy(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_Debug(char * jarg1, char * jarg2) {
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    Debug((char const *)arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_SetErrorHandler(char * jarg1) {
  int jresult ;
  char *arg1 = (char *) NULL ;
  CPLErr result;
  
  arg1 = (char *)jarg1; 
  {
    CPLErrorReset();
    result = (CPLErr)SetErrorHandler((char const *)arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_PushErrorHandler__SWIG_0(char * jarg1) {
  int jresult ;
  char *arg1 = (char *) NULL ;
  CPLErr result;
  
  arg1 = (char *)jarg1; 
  {
    CPLErrorReset();
    result = (CPLErr)PushErrorHandler((char const *)arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Error(int jarg1, int jarg2, char * jarg3) {
  CPLErr arg1 = (CPLErr) CE_Failure ;
  int arg2 = (int) 0 ;
  char *arg3 = (char *) "error" ;
  
  arg1 = (CPLErr)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (char *)jarg3; 
  {
    CPLErrorReset();
    Error(arg1,arg2,(char const *)arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GOA2GetAuthorizationURL(char * jarg1) {
  char * jresult ;
  char *arg1 = (char *) 0 ;
  retStringAndCPLFree *result = 0 ;
  
  arg1 = (char *)jarg1; 
  {
    CPLErrorReset();
    result = (retStringAndCPLFree *)GOA2GetAuthorizationURL((char const *)arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  
  /* %typemap(out) (retStringAndCPLFree*) */
  if(result)
  {
    jresult = SWIG_csharp_string_callback((const char *)result);
    CPLFree(result);
  }
  else
  {
    jresult = NULL;
  }
  
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GOA2GetRefreshToken(char * jarg1, char * jarg2) {
  char * jresult ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  retStringAndCPLFree *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    result = (retStringAndCPLFree *)GOA2GetRefreshToken((char const *)arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  
  /* %typemap(out) (retStringAndCPLFree*) */
  if(result)
  {
    jresult = SWIG_csharp_string_callback((const char *)result);
    CPLFree(result);
  }
  else
  {
    jresult = NULL;
  }
  
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GOA2GetAccessToken(char * jarg1, char * jarg2) {
  char * jresult ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  retStringAndCPLFree *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    result = (retStringAndCPLFree *)GOA2GetAccessToken((char const *)arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  
  /* %typemap(out) (retStringAndCPLFree*) */
  if(result)
  {
    jresult = SWIG_csharp_string_callback((const char *)result);
    CPLFree(result);
  }
  else
  {
    jresult = NULL;
  }
  
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_PushErrorHandler__SWIG_1(void * jarg1) {
  CPLErrorHandler arg1 ;
  
  arg1 = (CPLErrorHandler)jarg1; 
  {
    CPLErrorReset();
    CPLPushErrorHandler(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_PopErrorHandler() {
  {
    CPLErrorReset();
    CPLPopErrorHandler();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_ErrorReset() {
  {
    CPLErrorReset();
    CPLErrorReset();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_EscapeString(int jarg1, char * jarg2, int jarg3) {
  char * jresult ;
  int arg1 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  retStringAndCPLFree *result = 0 ;
  
  arg1 = (int)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (int)jarg3; 
  {
    CPLErrorReset();
    result = (retStringAndCPLFree *)EscapeString(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  
  /* %typemap(out) (retStringAndCPLFree*) */
  if(result)
  {
    jresult = SWIG_csharp_string_callback((const char *)result);
    CPLFree(result);
  }
  else
  {
    jresult = NULL;
  }
  
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_GetLastErrorNo() {
  int jresult ;
  int result;
  
  {
    result = CPLGetLastErrorNo();
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_GetLastErrorType() {
  int jresult ;
  int result;
  
  {
    result = CPLGetLastErrorType();
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GetLastErrorMsg() {
  char * jresult ;
  char *result = 0 ;
  
  {
    result = (char*)CPLGetLastErrorMsg();
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_VSIGetLastErrorNo() {
  int jresult ;
  int result;
  
  {
    CPLErrorReset();
    result = (int)VSIGetLastErrorNo();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_VSIGetLastErrorMsg() {
  char * jresult ;
  char *result = 0 ;
  
  {
    CPLErrorReset();
    result = (char *)VSIGetLastErrorMsg();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_PushFinderLocation(char * jarg1) {
  char *arg1 = (char *) 0 ;
  
  arg1 = (char *)jarg1; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return ; 
      };
    }
  }
  {
    CPLErrorReset();
    CPLPushFinderLocation((char const *)arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_PopFinderLocation() {
  {
    CPLErrorReset();
    CPLPopFinderLocation();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_FinderClean() {
  {
    CPLErrorReset();
    CPLFinderClean();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_FindFile(char * jarg1, char * jarg2) {
  char * jresult ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  char *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    if (!arg2) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (char *)CPLFindFile((char const *)arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_ReadDir(char * jarg1, int jarg2) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  int arg2 = (int) 0 ;
  char **result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (int)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (char **)wrapper_VSIReadDirEx((char const *)arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_ReadDirRecursive(char * jarg1) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  char **result = 0 ;
  
  arg1 = (char *)jarg1; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (char **)VSIReadDirRecursive((char const *)arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_SetConfigOption(char * jarg1, char * jarg2) {
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return ; 
      };
    }
  }
  {
    CPLErrorReset();
    CPLSetConfigOption((char const *)arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GetConfigOption(char * jarg1, char * jarg2) {
  char * jresult ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) NULL ;
  char *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (char *)wrapper_CPLGetConfigOption((char const *)arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_CPLBinaryToHex(int jarg1, void * jarg2) {
  char * jresult ;
  int arg1 ;
  GByte *arg2 = (GByte *) 0 ;
  retStringAndCPLFree *result = 0 ;
  
  arg1 = (int)jarg1; 
  arg2 = (GByte *)jarg2; 
  {
    CPLErrorReset();
    result = (retStringAndCPLFree *)CPLBinaryToHex(arg1,(GByte const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  
  /* %typemap(out) (retStringAndCPLFree*) */
  if(result)
  {
    jresult = SWIG_csharp_string_callback((const char *)result);
    CPLFree(result);
  }
  else
  {
    jresult = NULL;
  }
  
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_CPLHexToBinary(char * jarg1, void * jarg2) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  int *arg2 = (int *) 0 ;
  GByte *result = 0 ;
  
  arg1 = (char *)jarg1; 
  {
    /* %typemap(in) (int *hasval) */
    arg2 = (int *)jarg2;
  }
  {
    CPLErrorReset();
    result = (GByte *)CPLHexToBinary((char const *)arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_FileFromMemBuffer(char * jarg1, int jarg2, void * jarg3) {
  char *arg1 = (char *) 0 ;
  int arg2 ;
  GByte *arg3 = (GByte *) 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (GByte *)jarg3; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return ; 
      };
    }
  }
  {
    CPLErrorReset();
    wrapper_VSIFileFromMemBuffer((char const *)arg1,arg2,(GByte const *)arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_Unlink(char * jarg1) {
  int jresult ;
  char *arg1 = (char *) 0 ;
  VSI_RETVAL result;
  
  arg1 = (char *)jarg1; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = VSIUnlink((char const *)arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_HasThreadSupport() {
  int jresult ;
  int result;
  
  {
    CPLErrorReset();
    result = (int)wrapper_HasThreadSupport();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Mkdir(char * jarg1, int jarg2) {
  int jresult ;
  char *arg1 = (char *) 0 ;
  int arg2 ;
  VSI_RETVAL result;
  
  arg1 = (char *)jarg1; 
  arg2 = (int)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = VSIMkdir((char const *)arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Rmdir(char * jarg1) {
  int jresult ;
  char *arg1 = (char *) 0 ;
  VSI_RETVAL result;
  
  arg1 = (char *)jarg1; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = VSIRmdir((char const *)arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Rename(char * jarg1, char * jarg2) {
  int jresult ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  VSI_RETVAL result;
  
  arg1 = (char *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg2) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = VSIRename((char const *)arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_VSIFOpenL(char * jarg1, char * jarg2) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  VSILFILE *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (VSILFILE *)wrapper_VSIFOpenL((char const *)arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_VSIFOpenExL(char * jarg1, char * jarg2, int jarg3) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  VSILFILE *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (int)jarg3; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (VSILFILE *)wrapper_VSIFOpenExL((char const *)arg1,(char const *)arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_VSIFCloseL(void * jarg1) {
  int jresult ;
  VSILFILE *arg1 = (VSILFILE *) 0 ;
  VSI_RETVAL result;
  
  arg1 = (VSILFILE *)jarg1; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = VSIFCloseL(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_VSIFSeekL(void * jarg1, long jarg2, int jarg3) {
  int jresult ;
  VSILFILE *arg1 = (VSILFILE *) 0 ;
  long arg2 ;
  int arg3 ;
  VSI_RETVAL result;
  
  arg1 = (VSILFILE *)jarg1; 
  arg2 = (long)jarg2; 
  arg3 = (int)jarg3; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = VSIFSeekL(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT long SWIGSTDCALL CSharp_VSIFTellL(void * jarg1) {
  long jresult ;
  VSILFILE *arg1 = (VSILFILE *) 0 ;
  long result;
  
  arg1 = (VSILFILE *)jarg1; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (long)VSIFTellL(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_VSIFTruncateL(void * jarg1, long jarg2) {
  int jresult ;
  VSILFILE *arg1 = (VSILFILE *) 0 ;
  long arg2 ;
  VSI_RETVAL result;
  
  arg1 = (VSILFILE *)jarg1; 
  arg2 = (long)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = VSIFTruncateL(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_VSIFWriteL(char * jarg1, int jarg2, int jarg3, void * jarg4) {
  int jresult ;
  char *arg1 = (char *) 0 ;
  int arg2 ;
  int arg3 ;
  VSILFILE *arg4 = (VSILFILE *) 0 ;
  int result;
  
  arg1 = (char *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (VSILFILE *)jarg4; 
  {
    if (!arg4) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (int)VSIFWriteL((char const *)arg1,arg2,arg3,arg4);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_ParseCommandLine(char * jarg1) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  char **result = 0 ;
  
  arg1 = (char *)jarg1; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (char **)CSLParseCommandLine((char const *)arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_XMLNode_Type_get(void * jarg1) {
  int jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  CPLXMLNodeType result;
  
  arg1 = (CPLXMLNode *)jarg1; 
  result = (CPLXMLNodeType) ((arg1)->eType);
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_XMLNode_Value_get(void * jarg1) {
  char * jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  char *result = 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  result = (char *) ((arg1)->pszValue);
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_XMLNode_Next_get(void * jarg1) {
  void * jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  CPLXMLNode *result = 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  result = (CPLXMLNode *) ((arg1)->psNext);
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_XMLNode_Child_get(void * jarg1) {
  void * jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  CPLXMLNode *result = 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  result = (CPLXMLNode *) ((arg1)->psChild);
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_XMLNode__SWIG_0(char * jarg1) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  CPLXMLNode *result = 0 ;
  
  arg1 = (char *)jarg1; 
  {
    CPLErrorReset();
    result = (CPLXMLNode *)new_CPLXMLNode__SWIG_0((char const *)arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_XMLNode__SWIG_1(int jarg1, char * jarg2) {
  void * jresult ;
  CPLXMLNodeType arg1 ;
  char *arg2 = (char *) 0 ;
  CPLXMLNode *result = 0 ;
  
  arg1 = (CPLXMLNodeType)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    result = (CPLXMLNode *)new_CPLXMLNode__SWIG_1(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_XMLNode(void * jarg1) {
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  {
    CPLErrorReset();
    delete_CPLXMLNode(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_XMLNode_SerializeXMLTree(void * jarg1) {
  char * jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  retStringAndCPLFree *result = 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  {
    CPLErrorReset();
    result = (retStringAndCPLFree *)CPLXMLNode_SerializeXMLTree(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  
  /* %typemap(out) (retStringAndCPLFree*) */
  if(result)
  {
    jresult = SWIG_csharp_string_callback((const char *)result);
    CPLFree(result);
  }
  else
  {
    jresult = NULL;
  }
  
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_XMLNode_toString(void * jarg1) {
  char * jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  retStringAndCPLFree *result = 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  {
    CPLErrorReset();
    result = (retStringAndCPLFree *)CPLXMLNode_toString(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  
  /* %typemap(out) (retStringAndCPLFree*) */
  if(result)
  {
    jresult = SWIG_csharp_string_callback((const char *)result);
    CPLFree(result);
  }
  else
  {
    jresult = NULL;
  }
  
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_XMLNode_SearchXMLNode(void * jarg1, char * jarg2) {
  void * jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  char *arg2 = (char *) 0 ;
  CPLXMLNode *result = 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    result = (CPLXMLNode *)CPLXMLNode_SearchXMLNode(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_XMLNode_GetXMLNode(void * jarg1, char * jarg2) {
  void * jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  char *arg2 = (char *) 0 ;
  CPLXMLNode *result = 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    result = (CPLXMLNode *)CPLXMLNode_GetXMLNode(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_XMLNode_GetXMLValue(void * jarg1, char * jarg2, char * jarg3) {
  char * jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *result = 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (char *)jarg3; 
  {
    CPLErrorReset();
    result = (char *)CPLXMLNode_GetXMLValue(arg1,(char const *)arg2,(char const *)arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_XMLNode_AddXMLChild(void * jarg1, void * jarg2) {
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  CPLXMLNode *arg2 = (CPLXMLNode *) 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  arg2 = (CPLXMLNode *)jarg2; 
  {
    CPLErrorReset();
    CPLXMLNode_AddXMLChild(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_XMLNode_RemoveXMLChild(void * jarg1, void * jarg2) {
  int jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  CPLXMLNode *arg2 = (CPLXMLNode *) 0 ;
  int result;
  
  arg1 = (CPLXMLNode *)jarg1; 
  arg2 = (CPLXMLNode *)jarg2; 
  {
    CPLErrorReset();
    result = (int)CPLXMLNode_RemoveXMLChild(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_XMLNode_AddXMLSibling(void * jarg1, void * jarg2) {
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  CPLXMLNode *arg2 = (CPLXMLNode *) 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  arg2 = (CPLXMLNode *)jarg2; 
  {
    CPLErrorReset();
    CPLXMLNode_AddXMLSibling(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_XMLNode_CreateXMLElementAndValue(void * jarg1, char * jarg2, char * jarg3) {
  void * jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  CPLXMLNode *result = 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (char *)jarg3; 
  {
    CPLErrorReset();
    result = (CPLXMLNode *)CPLXMLNode_CreateXMLElementAndValue(arg1,(char const *)arg2,(char const *)arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_XMLNode_CloneXMLTree(void * jarg1, void * jarg2) {
  void * jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  CPLXMLNode *arg2 = (CPLXMLNode *) 0 ;
  CPLXMLNode *result = 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  arg2 = (CPLXMLNode *)jarg2; 
  {
    CPLErrorReset();
    result = (CPLXMLNode *)CPLXMLNode_CloneXMLTree(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_XMLNode_Clone(void * jarg1) {
  void * jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  CPLXMLNode *result = 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  {
    CPLErrorReset();
    result = (CPLXMLNode *)CPLXMLNode_Clone(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_XMLNode_SetXMLValue(void * jarg1, char * jarg2, char * jarg3) {
  int jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  int result;
  
  arg1 = (CPLXMLNode *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (char *)jarg3; 
  {
    CPLErrorReset();
    result = (int)CPLXMLNode_SetXMLValue(arg1,(char const *)arg2,(char const *)arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_XMLNode_StripXMLNamespace(void * jarg1, char * jarg2, int jarg3) {
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (int)jarg3; 
  {
    CPLErrorReset();
    CPLXMLNode_StripXMLNamespace(arg1,(char const *)arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_MajorObject_GetDescription(void * jarg1) {
  char * jresult ;
  GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDALMajorObjectShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDALMajorObjectShadow_GetDescription(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_MajorObject_SetDescription(void * jarg1, char * jarg2) {
  GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  
  arg1 = (GDALMajorObjectShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    if (!arg2) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return ; 
      };
    }
  }
  {
    CPLErrorReset();
    GDALMajorObjectShadow_SetDescription(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_MajorObject_GetMetadataDomainList(void * jarg1) {
  void * jresult ;
  GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
  char **result = 0 ;
  
  arg1 = (GDALMajorObjectShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (char **)GDALMajorObjectShadow_GetMetadataDomainList(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_MajorObject_GetMetadata(void * jarg1, char * jarg2) {
  void * jresult ;
  GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
  char *arg2 = (char *) "" ;
  char **result = 0 ;
  
  arg1 = (GDALMajorObjectShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    result = (char **)GDALMajorObjectShadow_GetMetadata_List(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_MajorObject_SetMetadata__SWIG_0(void * jarg1, void * jarg2, char * jarg3) {
  int jresult ;
  GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
  char **arg2 = (char **) 0 ;
  char *arg3 = (char *) "" ;
  CPLErr result;
  
  arg1 = (GDALMajorObjectShadow *)jarg1; 
  arg2 = (char **)jarg2; 
  arg3 = (char *)jarg3; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALMajorObjectShadow_SetMetadata__SWIG_0(arg1,arg2,(char const *)arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_MajorObject_SetMetadata__SWIG_1(void * jarg1, char * jarg2, char * jarg3) {
  int jresult ;
  GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) "" ;
  CPLErr result;
  
  arg1 = (GDALMajorObjectShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (char *)jarg3; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALMajorObjectShadow_SetMetadata__SWIG_1(arg1,arg2,(char const *)arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_MajorObject_GetMetadataItem(void * jarg1, char * jarg2, char * jarg3) {
  char * jresult ;
  GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) "" ;
  char *result = 0 ;
  
  arg1 = (GDALMajorObjectShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (char *)jarg3; 
  {
    if (!arg2) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (char *)GDALMajorObjectShadow_GetMetadataItem(arg1,(char const *)arg2,(char const *)arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_MajorObject_SetMetadataItem(void * jarg1, char * jarg2, char * jarg3, char * jarg4) {
  int jresult ;
  GDALMajorObjectShadow *arg1 = (GDALMajorObjectShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) "" ;
  CPLErr result;
  
  arg1 = (GDALMajorObjectShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (char *)jarg3; 
  arg4 = (char *)jarg4; 
  {
    if (!arg2) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (CPLErr)GDALMajorObjectShadow_SetMetadataItem(arg1,(char const *)arg2,(char const *)arg3,(char const *)arg4);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Driver_ShortName_get(void * jarg1) {
  char * jresult ;
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDALDriverShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDALDriverShadow_ShortName_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Driver_LongName_get(void * jarg1) {
  char * jresult ;
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDALDriverShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDALDriverShadow_LongName_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Driver_HelpTopic_get(void * jarg1) {
  char * jresult ;
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDALDriverShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDALDriverShadow_HelpTopic_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Driver_Create(void * jarg1, char * jarg2, int jarg3, int jarg4, int jarg5, int jarg6, void * jarg7) {
  void * jresult ;
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  int arg3 ;
  int arg4 ;
  int arg5 = (int) 1 ;
  GDALDataType arg6 = (GDALDataType) GDT_Byte ;
  char **arg7 = (char **) 0 ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (GDALDriverShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (GDALDataType)jarg6; 
  arg7 = (char **)jarg7; 
  {
    if (!arg2) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)GDALDriverShadow_Create(arg1,(char const *)arg2,arg3,arg4,arg5,arg6,arg7);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Driver_CreateCopy(void * jarg1, char * jarg2, void * jarg3, int jarg4, void * jarg5, void * jarg6, void * jarg7) {
  void * jresult ;
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  GDALDatasetShadow *arg3 = (GDALDatasetShadow *) 0 ;
  int arg4 = (int) 1 ;
  char **arg5 = (char **) 0 ;
  GDALProgressFunc arg6 = (GDALProgressFunc) NULL ;
  void *arg7 = (void *) NULL ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (GDALDriverShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (GDALDatasetShadow *)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (char **)jarg5; 
  arg6 = (GDALProgressFunc)jarg6; 
  arg7 = (void *)jarg7; 
  {
    if (!arg2) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg3) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)GDALDriverShadow_CreateCopy(arg1,(char const *)arg2,arg3,arg4,arg5,arg6,arg7);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Driver_Delete(void * jarg1, char * jarg2) {
  int jresult ;
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  CPLErr result;
  
  arg1 = (GDALDriverShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    if (!arg2) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (CPLErr)GDALDriverShadow_Delete(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Driver_Rename(void * jarg1, char * jarg2, char * jarg3) {
  int jresult ;
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  CPLErr result;
  
  arg1 = (GDALDriverShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (char *)jarg3; 
  {
    if (!arg2) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg3) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (CPLErr)GDALDriverShadow_Rename(arg1,(char const *)arg2,(char const *)arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Driver_CopyFiles(void * jarg1, char * jarg2, char * jarg3) {
  int jresult ;
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  CPLErr result;
  
  arg1 = (GDALDriverShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (char *)jarg3; 
  {
    if (!arg2) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg3) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (CPLErr)GDALDriverShadow_CopyFiles(arg1,(char const *)arg2,(char const *)arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Driver_Register(void * jarg1) {
  int jresult ;
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  int result;
  
  arg1 = (GDALDriverShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALDriverShadow_Register(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Driver_Deregister(void * jarg1) {
  GDALDriverShadow *arg1 = (GDALDriverShadow *) 0 ;
  
  arg1 = (GDALDriverShadow *)jarg1; 
  {
    CPLErrorReset();
    GDALDriverShadow_Deregister(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_ColorEntry_c1_set(void * jarg1, short jarg2) {
  GDALColorEntry *arg1 = (GDALColorEntry *) 0 ;
  short arg2 ;
  
  arg1 = (GDALColorEntry *)jarg1; 
  arg2 = (short)jarg2; 
  if (arg1) (arg1)->c1 = arg2;
}


SWIGEXPORT short SWIGSTDCALL CSharp_ColorEntry_c1_get(void * jarg1) {
  short jresult ;
  GDALColorEntry *arg1 = (GDALColorEntry *) 0 ;
  short result;
  
  arg1 = (GDALColorEntry *)jarg1; 
  result = (short) ((arg1)->c1);
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_ColorEntry_c2_set(void * jarg1, short jarg2) {
  GDALColorEntry *arg1 = (GDALColorEntry *) 0 ;
  short arg2 ;
  
  arg1 = (GDALColorEntry *)jarg1; 
  arg2 = (short)jarg2; 
  if (arg1) (arg1)->c2 = arg2;
}


SWIGEXPORT short SWIGSTDCALL CSharp_ColorEntry_c2_get(void * jarg1) {
  short jresult ;
  GDALColorEntry *arg1 = (GDALColorEntry *) 0 ;
  short result;
  
  arg1 = (GDALColorEntry *)jarg1; 
  result = (short) ((arg1)->c2);
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_ColorEntry_c3_set(void * jarg1, short jarg2) {
  GDALColorEntry *arg1 = (GDALColorEntry *) 0 ;
  short arg2 ;
  
  arg1 = (GDALColorEntry *)jarg1; 
  arg2 = (short)jarg2; 
  if (arg1) (arg1)->c3 = arg2;
}


SWIGEXPORT short SWIGSTDCALL CSharp_ColorEntry_c3_get(void * jarg1) {
  short jresult ;
  GDALColorEntry *arg1 = (GDALColorEntry *) 0 ;
  short result;
  
  arg1 = (GDALColorEntry *)jarg1; 
  result = (short) ((arg1)->c3);
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_ColorEntry_c4_set(void * jarg1, short jarg2) {
  GDALColorEntry *arg1 = (GDALColorEntry *) 0 ;
  short arg2 ;
  
  arg1 = (GDALColorEntry *)jarg1; 
  arg2 = (short)jarg2; 
  if (arg1) (arg1)->c4 = arg2;
}


SWIGEXPORT short SWIGSTDCALL CSharp_ColorEntry_c4_get(void * jarg1) {
  short jresult ;
  GDALColorEntry *arg1 = (GDALColorEntry *) 0 ;
  short result;
  
  arg1 = (GDALColorEntry *)jarg1; 
  result = (short) ((arg1)->c4);
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ColorEntry() {
  void * jresult ;
  GDALColorEntry *result = 0 ;
  
  {
    CPLErrorReset();
    result = (GDALColorEntry *)new GDALColorEntry();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ColorEntry(void * jarg1) {
  GDALColorEntry *arg1 = (GDALColorEntry *) 0 ;
  
  arg1 = (GDALColorEntry *)jarg1; 
  {
    CPLErrorReset();
    delete arg1;
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_GCP_GCPX_set(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_GCPX_set(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GCP_GCPX_get(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_GCPX_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GCP_GCPY_set(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_GCPY_set(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GCP_GCPY_get(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_GCPY_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GCP_GCPZ_set(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_GCPZ_set(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GCP_GCPZ_get(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_GCPZ_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GCP_GCPPixel_set(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_GCPPixel_set(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GCP_GCPPixel_get(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_GCPPixel_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GCP_GCPLine_set(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_GCPLine_set(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GCP_GCPLine_get(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_GCPLine_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GCP_Info_set(void * jarg1, char * jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *arg2 = (char *) 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_Info_set(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GCP_Info_get(void * jarg1) {
  char * jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDAL_GCP_Info_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GCP_Id_set(void * jarg1, char * jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *arg2 = (char *) 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    GDAL_GCP_Id_set(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GCP_Id_get(void * jarg1) {
  char * jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDAL_GCP_Id_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_GCP(double jarg1, double jarg2, double jarg3, double jarg4, double jarg5, char * jarg6, char * jarg7) {
  void * jresult ;
  double arg1 = (double) 0.0 ;
  double arg2 = (double) 0.0 ;
  double arg3 = (double) 0.0 ;
  double arg4 = (double) 0.0 ;
  double arg5 = (double) 0.0 ;
  char *arg6 = (char *) "" ;
  char *arg7 = (char *) "" ;
  GDAL_GCP *result = 0 ;
  
  arg1 = (double)jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (char *)jarg6; 
  arg7 = (char *)jarg7; 
  {
    CPLErrorReset();
    result = (GDAL_GCP *)new_GDAL_GCP(arg1,arg2,arg3,arg4,arg5,(char const *)arg6,(char const *)arg7);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_GCP(void * jarg1) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    delete_GDAL_GCP(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GDAL_GCP_GCPX_get(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_GCPX_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_GCPX_set(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return ; 
      };
    }
  }
  {
    CPLErrorReset();
    GDAL_GCP_GCPX_set(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GDAL_GCP_GCPY_get(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_GCPY_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_GCPY_set(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return ; 
      };
    }
  }
  {
    CPLErrorReset();
    GDAL_GCP_GCPY_set(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GDAL_GCP_GCPZ_get(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_GCPZ_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_GCPZ_set(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return ; 
      };
    }
  }
  {
    CPLErrorReset();
    GDAL_GCP_GCPZ_set(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GDAL_GCP_GCPPixel_get(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_GCPPixel_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_GCPPixel_set(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return ; 
      };
    }
  }
  {
    CPLErrorReset();
    GDAL_GCP_GCPPixel_set(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GDAL_GCP_GCPLine_get(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_GCPLine_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_GCPLine_set(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return ; 
      };
    }
  }
  {
    CPLErrorReset();
    GDAL_GCP_GCPLine_set(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GDAL_GCP_Info_get(void * jarg1) {
  char * jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (char *)GDAL_GCP_Info_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_Info_set(void * jarg1, char * jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *arg2 = (char *) 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return ; 
      };
    }
  }
  {
    CPLErrorReset();
    GDAL_GCP_Info_set(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GDAL_GCP_Id_get(void * jarg1) {
  char * jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (char *)GDAL_GCP_Id_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_Id_set(void * jarg1, char * jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *arg2 = (char *) 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return ; 
      };
    }
  }
  {
    CPLErrorReset();
    GDAL_GCP_Id_set(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GDAL_GCP_get_GCPX(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_get_GCPX(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_set_GCPX(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return ; 
      };
    }
  }
  {
    CPLErrorReset();
    GDAL_GCP_set_GCPX(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GDAL_GCP_get_GCPY(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_get_GCPY(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_set_GCPY(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return ; 
      };
    }
  }
  {
    CPLErrorReset();
    GDAL_GCP_set_GCPY(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GDAL_GCP_get_GCPZ(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_get_GCPZ(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_set_GCPZ(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return ; 
      };
    }
  }
  {
    CPLErrorReset();
    GDAL_GCP_set_GCPZ(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GDAL_GCP_get_GCPPixel(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_get_GCPPixel(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_set_GCPPixel(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return ; 
      };
    }
  }
  {
    CPLErrorReset();
    GDAL_GCP_set_GCPPixel(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT double SWIGSTDCALL CSharp_GDAL_GCP_get_GCPLine(void * jarg1) {
  double jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double result;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (double)GDAL_GCP_get_GCPLine(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_set_GCPLine(void * jarg1, double jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  double arg2 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (double)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return ; 
      };
    }
  }
  {
    CPLErrorReset();
    GDAL_GCP_set_GCPLine(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GDAL_GCP_get_Info(void * jarg1) {
  char * jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (char *)GDAL_GCP_get_Info(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_set_Info(void * jarg1, char * jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *arg2 = (char *) 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return ; 
      };
    }
  }
  {
    CPLErrorReset();
    GDAL_GCP_set_Info(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GDAL_GCP_get_Id(void * jarg1) {
  char * jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (char *)GDAL_GCP_get_Id(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDAL_GCP_set_Id(void * jarg1, char * jarg2) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  char *arg2 = (char *) 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return ; 
      };
    }
  }
  {
    CPLErrorReset();
    GDAL_GCP_set_Id(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_GCPsToGeoTransform(int jarg1, void * jarg2, void * jarg3, int jarg4) {
  int jresult ;
  int arg1 ;
  GDAL_GCP *arg2 = (GDAL_GCP *) 0 ;
  double *arg3 ;
  int arg4 = (int) 1 ;
  RETURN_NONE result;
  
  arg1 = (int)jarg1; 
  arg2 = (GDAL_GCP *)jarg2; 
  {
    /* %typemap(in) (double argout[ANY]) */
    arg3 = (double *)jarg3;
  }
  arg4 = (int)jarg4; 
  {
    CPLErrorReset();
    result = (RETURN_NONE)GDALGCPsToGeoTransform(arg1,(GDAL_GCP const *)arg2,arg3,arg4);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_AsyncReader(void * jarg1) {
  GDALAsyncReaderShadow *arg1 = (GDALAsyncReaderShadow *) 0 ;
  
  arg1 = (GDALAsyncReaderShadow *)jarg1; 
  {
    CPLErrorReset();
    delete_GDALAsyncReaderShadow(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_AsyncReader_GetNextUpdatedRegion(void * jarg1, double jarg2, int * jarg3, int * jarg4, int * jarg5, int * jarg6) {
  int jresult ;
  GDALAsyncReaderShadow *arg1 = (GDALAsyncReaderShadow *) 0 ;
  double arg2 ;
  int *arg3 = (int *) 0 ;
  int *arg4 = (int *) 0 ;
  int *arg5 = (int *) 0 ;
  int *arg6 = (int *) 0 ;
  GDALAsyncStatusType result;
  
  arg1 = (GDALAsyncReaderShadow *)jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (int *)jarg3; 
  arg4 = (int *)jarg4; 
  arg5 = (int *)jarg5; 
  arg6 = (int *)jarg6; 
  {
    CPLErrorReset();
    result = (GDALAsyncStatusType)GDALAsyncReaderShadow_GetNextUpdatedRegion(arg1,arg2,arg3,arg4,arg5,arg6);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_AsyncReader_LockBuffer(void * jarg1, double jarg2) {
  int jresult ;
  GDALAsyncReaderShadow *arg1 = (GDALAsyncReaderShadow *) 0 ;
  double arg2 ;
  int result;
  
  arg1 = (GDALAsyncReaderShadow *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    result = (int)GDALAsyncReaderShadow_LockBuffer(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_AsyncReader_UnlockBuffer(void * jarg1) {
  GDALAsyncReaderShadow *arg1 = (GDALAsyncReaderShadow *) 0 ;
  
  arg1 = (GDALAsyncReaderShadow *)jarg1; 
  {
    CPLErrorReset();
    GDALAsyncReaderShadow_UnlockBuffer(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_RasterXSize_get(void * jarg1) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALDatasetShadow_RasterXSize_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_RasterYSize_get(void * jarg1) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALDatasetShadow_RasterYSize_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_RasterCount_get(void * jarg1) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALDatasetShadow_RasterCount_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Dataset(void * jarg1) {
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    delete_GDALDatasetShadow(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Dataset_GetDriver(void * jarg1) {
  void * jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  GDALDriverShadow *result = 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (GDALDriverShadow *)GDALDatasetShadow_GetDriver(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Dataset_GetRasterBand(void * jarg1, int jarg2) {
  void * jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int arg2 ;
  GDALRasterBandShadow *result = 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (int)jarg2; 
  {
    CPLErrorReset();
    result = (GDALRasterBandShadow *)GDALDatasetShadow_GetRasterBand(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Dataset_GetProjection(void * jarg1) {
  char * jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDALDatasetShadow_GetProjection(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Dataset_GetProjectionRef(void * jarg1) {
  char * jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDALDatasetShadow_GetProjectionRef(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_SetProjection(void * jarg1, char * jarg2) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  CPLErr result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    if (!arg2) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (CPLErr)GDALDatasetShadow_SetProjection(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Dataset_GetGeoTransform(void * jarg1, void * jarg2) {
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  double *arg2 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    /* %typemap(in) (double argout[ANY]) */
    arg2 = (double *)jarg2;
  }
  {
    CPLErrorReset();
    GDALDatasetShadow_GetGeoTransform(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_SetGeoTransform(void * jarg1, void * jarg2) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  double *arg2 ;
  CPLErr result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    /* %typemap(in) (double argin[ANY]) */
    arg2 = (double *)jarg2;
  }
  {
    CPLErrorReset();
    result = (CPLErr)GDALDatasetShadow_SetGeoTransform(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_BuildOverviews(void * jarg1, char * jarg2, int jarg3, void * jarg4, void * jarg5, void * jarg6) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  char *arg2 = (char *) "NEAREST" ;
  int arg3 = (int) 0 ;
  int *arg4 = (int *) 0 ;
  GDALProgressFunc arg5 = (GDALProgressFunc) NULL ;
  void *arg6 = (void *) NULL ;
  int result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int *)jarg4; 
  arg5 = (GDALProgressFunc)jarg5; 
  arg6 = (void *)jarg6; 
  {
    CPLErrorReset();
    result = (int)GDALDatasetShadow_BuildOverviews(arg1,(char const *)arg2,arg3,arg4,arg5,arg6);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_GetGCPCount(void * jarg1) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALDatasetShadow_GetGCPCount(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Dataset_GetGCPProjection(void * jarg1) {
  char * jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDALDatasetShadow_GetGCPProjection(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Dataset_FlushCache(void * jarg1) {
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    GDALDatasetShadow_FlushCache(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_AddBand(void * jarg1, int jarg2, void * jarg3) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  GDALDataType arg2 = (GDALDataType) GDT_Byte ;
  char **arg3 = (char **) 0 ;
  CPLErr result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (GDALDataType)jarg2; 
  arg3 = (char **)jarg3; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALDatasetShadow_AddBand(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_CreateMaskBand(void * jarg1, int jarg2) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int arg2 ;
  CPLErr result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (int)jarg2; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALDatasetShadow_CreateMaskBand(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Dataset_GetFileList(void * jarg1) {
  void * jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  char **result = 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (char **)GDALDatasetShadow_GetFileList(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_StartTransaction(void * jarg1, int jarg2) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int arg2 = (int) FALSE ;
  OGRErr result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (int)jarg2; 
  {
    CPLErrorReset();
    result = (OGRErr)GDALDatasetShadow_StartTransaction(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  {
    /* %typemap(out,fragment="OGRErrMessages",canthrow=1) OGRErr */
    jresult = result;
  }
  {
    /* %typemap(ret) OGRErr */
    
  }
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_CommitTransaction(void * jarg1) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  OGRErr result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (OGRErr)GDALDatasetShadow_CommitTransaction(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  {
    /* %typemap(out,fragment="OGRErrMessages",canthrow=1) OGRErr */
    jresult = result;
  }
  {
    /* %typemap(ret) OGRErr */
    
  }
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_RollbackTransaction(void * jarg1) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  OGRErr result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (OGRErr)GDALDatasetShadow_RollbackTransaction(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  {
    /* %typemap(out,fragment="OGRErrMessages",canthrow=1) OGRErr */
    jresult = result;
  }
  {
    /* %typemap(ret) OGRErr */
    
  }
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_ReadRaster(void * jarg1, int jarg2, int jarg3, int jarg4, int jarg5, void * jarg6, int jarg7, int jarg8, int jarg9, int jarg10, void * jarg11, int jarg12, int jarg13, int jarg14) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  void *arg6 = (void *) 0 ;
  int arg7 ;
  int arg8 ;
  GDALDataType arg9 ;
  int arg10 ;
  int *arg11 = (int *) 0 ;
  int arg12 ;
  int arg13 ;
  int arg14 ;
  CPLErr result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (void *)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (int)jarg8; 
  arg9 = (GDALDataType)jarg9; 
  arg10 = (int)jarg10; 
  {
    /* %typemap(in) (int argin[ANY]) */
    arg11 = (int *)jarg11;
  }
  arg12 = (int)jarg12; 
  arg13 = (int)jarg13; 
  arg14 = (int)jarg14; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALDatasetShadow_ReadRaster(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset_WriteRaster(void * jarg1, int jarg2, int jarg3, int jarg4, int jarg5, void * jarg6, int jarg7, int jarg8, int jarg9, int jarg10, void * jarg11, int jarg12, int jarg13, int jarg14) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  void *arg6 = (void *) 0 ;
  int arg7 ;
  int arg8 ;
  GDALDataType arg9 ;
  int arg10 ;
  int *arg11 = (int *) 0 ;
  int arg12 ;
  int arg13 ;
  int arg14 ;
  CPLErr result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (void *)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (int)jarg8; 
  arg9 = (GDALDataType)jarg9; 
  arg10 = (int)jarg10; 
  {
    /* %typemap(in) (int argin[ANY]) */
    arg11 = (int *)jarg11;
  }
  arg12 = (int)jarg12; 
  arg13 = (int)jarg13; 
  arg14 = (int)jarg14; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALDatasetShadow_WriteRaster(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12,arg13,arg14);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Dataset___GetGCPs(void * jarg1) {
  void * jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  GDAL_GCP *result = 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (GDAL_GCP *)GDALDatasetShadow___GetGCPs(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Dataset___SetGCPs(void * jarg1, int jarg2, void * jarg3, char * jarg4) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int arg2 ;
  GDAL_GCP *arg3 = (GDAL_GCP *) 0 ;
  char *arg4 = (char *) 0 ;
  CPLErr result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (GDAL_GCP *)jarg3; 
  arg4 = (char *)jarg4; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALDatasetShadow___SetGCPs(arg1,arg2,(GDAL_GCP const *)arg3,(char const *)arg4);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Dataset___WriteCArrayItem_GDAL_GCP(void * jarg1, void * jarg2, int jarg3, void * jarg4) {
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  GDAL_GCP *arg2 = (GDAL_GCP *) 0 ;
  int arg3 ;
  GDAL_GCP *arg4 = (GDAL_GCP *) 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (GDAL_GCP *)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (GDAL_GCP *)jarg4; 
  {
    CPLErrorReset();
    GDALDatasetShadow___WriteCArrayItem_GDAL_GCP(arg1,arg2,arg3,arg4);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Dataset___ReadCArrayItem_GDAL_GCP(void * jarg1, void * jarg2, int jarg3) {
  void * jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  GDAL_GCP *arg2 = (GDAL_GCP *) 0 ;
  int arg3 ;
  GDAL_GCP *result = 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (GDAL_GCP *)jarg2; 
  arg3 = (int)jarg3; 
  {
    CPLErrorReset();
    result = (GDAL_GCP *)GDALDatasetShadow___ReadCArrayItem_GDAL_GCP(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Dataset___AllocCArray_GDAL_GCP(void * jarg1, int jarg2) {
  void * jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int arg2 ;
  GDAL_GCP *result = 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (int)jarg2; 
  {
    CPLErrorReset();
    result = (GDAL_GCP *)GDALDatasetShadow___AllocCArray_GDAL_GCP(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Dataset___FreeCArray_GDAL_GCP(void * jarg1, void * jarg2) {
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  GDAL_GCP *arg2 = (GDAL_GCP *) 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (GDAL_GCP *)jarg2; 
  {
    CPLErrorReset();
    GDALDatasetShadow___FreeCArray_GDAL_GCP(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_XSize_get(void * jarg1) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALRasterBandShadow_XSize_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_YSize_get(void * jarg1) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALRasterBandShadow_YSize_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_DataType_get(void * jarg1) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALDataType result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (GDALDataType)GDALRasterBandShadow_DataType_get(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Band_GetDataset(void * jarg1) {
  void * jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)GDALRasterBandShadow_GetDataset(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_GetBand(void * jarg1) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALRasterBandShadow_GetBand(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Band_GetBlockSize(void * jarg1, int * jarg2, int * jarg3) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int *arg2 = (int *) 0 ;
  int *arg3 = (int *) 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (int *)jarg2; 
  arg3 = (int *)jarg3; 
  {
    CPLErrorReset();
    GDALRasterBandShadow_GetBlockSize(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_GetColorInterpretation(void * jarg1) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALColorInterp result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (GDALColorInterp)GDALRasterBandShadow_GetColorInterpretation(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_GetRasterColorInterpretation(void * jarg1) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALColorInterp result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (GDALColorInterp)GDALRasterBandShadow_GetRasterColorInterpretation(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_SetColorInterpretation(void * jarg1, int jarg2) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALColorInterp arg2 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (GDALColorInterp)jarg2; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_SetColorInterpretation(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_SetRasterColorInterpretation(void * jarg1, int jarg2) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALColorInterp arg2 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (GDALColorInterp)jarg2; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_SetRasterColorInterpretation(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Band_GetNoDataValue(void * jarg1, void * jarg2, void * jarg3) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double *arg2 = (double *) 0 ;
  int *arg3 = (int *) 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    /* %typemap(in) (double *val) */
    arg2 = (double *)jarg2;
  }
  {
    /* %typemap(in) (int *hasval) */
    arg3 = (int *)jarg3;
  }
  {
    CPLErrorReset();
    GDALRasterBandShadow_GetNoDataValue(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_SetNoDataValue(void * jarg1, double jarg2) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double arg2 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_SetNoDataValue(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_DeleteNoDataValue(void * jarg1) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_DeleteNoDataValue(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_Band_GetUnitType(void * jarg1) {
  char * jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  char *result = 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDALRasterBandShadow_GetUnitType(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_SetUnitType(void * jarg1, char * jarg2) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_SetUnitType(arg1,(char const *)arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Band_GetRasterCategoryNames(void * jarg1) {
  void * jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  char **result = 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (char **)GDALRasterBandShadow_GetRasterCategoryNames(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_SetRasterCategoryNames(void * jarg1, void * jarg2) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  char **arg2 = (char **) 0 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (char **)jarg2; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_SetRasterCategoryNames(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Band_GetMinimum(void * jarg1, void * jarg2, void * jarg3) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double *arg2 = (double *) 0 ;
  int *arg3 = (int *) 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    /* %typemap(in) (double *val) */
    arg2 = (double *)jarg2;
  }
  {
    /* %typemap(in) (int *hasval) */
    arg3 = (int *)jarg3;
  }
  {
    CPLErrorReset();
    GDALRasterBandShadow_GetMinimum(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_Band_GetMaximum(void * jarg1, void * jarg2, void * jarg3) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double *arg2 = (double *) 0 ;
  int *arg3 = (int *) 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    /* %typemap(in) (double *val) */
    arg2 = (double *)jarg2;
  }
  {
    /* %typemap(in) (int *hasval) */
    arg3 = (int *)jarg3;
  }
  {
    CPLErrorReset();
    GDALRasterBandShadow_GetMaximum(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_Band_GetOffset(void * jarg1, void * jarg2, void * jarg3) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double *arg2 = (double *) 0 ;
  int *arg3 = (int *) 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    /* %typemap(in) (double *val) */
    arg2 = (double *)jarg2;
  }
  {
    /* %typemap(in) (int *hasval) */
    arg3 = (int *)jarg3;
  }
  {
    CPLErrorReset();
    GDALRasterBandShadow_GetOffset(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_Band_GetScale(void * jarg1, void * jarg2, void * jarg3) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double *arg2 = (double *) 0 ;
  int *arg3 = (int *) 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    /* %typemap(in) (double *val) */
    arg2 = (double *)jarg2;
  }
  {
    /* %typemap(in) (int *hasval) */
    arg3 = (int *)jarg3;
  }
  {
    CPLErrorReset();
    GDALRasterBandShadow_GetScale(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_SetOffset(void * jarg1, double jarg2) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double arg2 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_SetOffset(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_SetScale(void * jarg1, double jarg2) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double arg2 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_SetScale(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_GetStatistics(void * jarg1, int jarg2, int jarg3, double * jarg4, double * jarg5, double * jarg6, double * jarg7) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  double *arg4 = (double *) 0 ;
  double *arg5 = (double *) 0 ;
  double *arg6 = (double *) 0 ;
  double *arg7 = (double *) 0 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    /* %typemap(in) (double *val) */
    arg4 = (double *)jarg4;
  }
  {
    /* %typemap(in) (double *val) */
    arg5 = (double *)jarg5;
  }
  {
    /* %typemap(in) (double *val) */
    arg6 = (double *)jarg6;
  }
  {
    /* %typemap(in) (double *val) */
    arg7 = (double *)jarg7;
  }
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_GetStatistics(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_ComputeStatistics(void * jarg1, unsigned int jarg2, double * jarg3, double * jarg4, double * jarg5, double * jarg6, void * jarg7, void * jarg8) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  bool arg2 ;
  double *arg3 = (double *) NULL ;
  double *arg4 = (double *) NULL ;
  double *arg5 = (double *) NULL ;
  double *arg6 = (double *) NULL ;
  GDALProgressFunc arg7 = (GDALProgressFunc) NULL ;
  void *arg8 = (void *) NULL ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = jarg2 ? true : false; 
  {
    /* %typemap(in) (double *val) */
    arg3 = (double *)jarg3;
  }
  {
    /* %typemap(in) (double *val) */
    arg4 = (double *)jarg4;
  }
  {
    /* %typemap(in) (double *val) */
    arg5 = (double *)jarg5;
  }
  {
    /* %typemap(in) (double *val) */
    arg6 = (double *)jarg6;
  }
  arg7 = (GDALProgressFunc)jarg7; 
  arg8 = (void *)jarg8; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_ComputeStatistics(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_SetStatistics(void * jarg1, double jarg2, double jarg3, double jarg4, double jarg5) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_SetStatistics(arg1,arg2,arg3,arg4,arg5);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_GetOverviewCount(void * jarg1) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALRasterBandShadow_GetOverviewCount(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Band_GetOverview(void * jarg1, int jarg2) {
  void * jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int arg2 ;
  GDALRasterBandShadow *result = 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (int)jarg2; 
  {
    CPLErrorReset();
    result = (GDALRasterBandShadow *)GDALRasterBandShadow_GetOverview(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_Checksum(void * jarg1, int jarg2, int jarg3, void * jarg4, void * jarg5) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int arg2 = (int) 0 ;
  int arg3 = (int) 0 ;
  int *arg4 = (int *) 0 ;
  int *arg5 = (int *) 0 ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    /* %typemap(in) (type *optional_##int) */
    arg4 = (int *)jarg4;
  }
  {
    /* %typemap(in) (type *optional_##int) */
    arg5 = (int *)jarg5;
  }
  {
    CPLErrorReset();
    result = (int)GDALRasterBandShadow_Checksum(arg1,arg2,arg3,arg4,arg5);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Band_ComputeRasterMinMax(void * jarg1, void * jarg2, int jarg3) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double *arg2 ;
  int arg3 = (int) 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    /* %typemap(in) (double argout[ANY]) */
    arg2 = (double *)jarg2;
  }
  arg3 = (int)jarg3; 
  {
    CPLErrorReset();
    GDALRasterBandShadow_ComputeRasterMinMax(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_Band_ComputeBandStats(void * jarg1, void * jarg2, int jarg3) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double *arg2 ;
  int arg3 = (int) 1 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    /* %typemap(in) (double argout[ANY]) */
    arg2 = (double *)jarg2;
  }
  arg3 = (int)jarg3; 
  {
    CPLErrorReset();
    GDALRasterBandShadow_ComputeBandStats(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_Fill(void * jarg1, double jarg2, double jarg3) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double arg2 ;
  double arg3 = (double) 0.0 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_Fill(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_Band_FlushCache(void * jarg1) {
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    GDALRasterBandShadow_FlushCache(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Band_GetRasterColorTable(void * jarg1) {
  void * jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALColorTableShadow *result = 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (GDALColorTableShadow *)GDALRasterBandShadow_GetRasterColorTable(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Band_GetColorTable(void * jarg1) {
  void * jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALColorTableShadow *result = 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (GDALColorTableShadow *)GDALRasterBandShadow_GetColorTable(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_SetRasterColorTable(void * jarg1, void * jarg2) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALColorTableShadow *arg2 = (GDALColorTableShadow *) 0 ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (GDALColorTableShadow *)jarg2; 
  {
    CPLErrorReset();
    result = (int)GDALRasterBandShadow_SetRasterColorTable(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_SetColorTable(void * jarg1, void * jarg2) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALColorTableShadow *arg2 = (GDALColorTableShadow *) 0 ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (GDALColorTableShadow *)jarg2; 
  {
    CPLErrorReset();
    result = (int)GDALRasterBandShadow_SetColorTable(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Band_GetDefaultRAT(void * jarg1) {
  void * jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALRasterAttributeTableShadow *result = 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (GDALRasterAttributeTableShadow *)GDALRasterBandShadow_GetDefaultRAT(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_SetDefaultRAT(void * jarg1, void * jarg2) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALRasterAttributeTableShadow *arg2 = (GDALRasterAttributeTableShadow *) 0 ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (GDALRasterAttributeTableShadow *)jarg2; 
  {
    CPLErrorReset();
    result = (int)GDALRasterBandShadow_SetDefaultRAT(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Band_GetMaskBand(void * jarg1) {
  void * jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALRasterBandShadow *result = 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (GDALRasterBandShadow *)GDALRasterBandShadow_GetMaskBand(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_GetMaskFlags(void * jarg1) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALRasterBandShadow_GetMaskFlags(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_CreateMaskBand(void * jarg1, int jarg2) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int arg2 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (int)jarg2; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_CreateMaskBand(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_GetHistogram(void * jarg1, double jarg2, double jarg3, int jarg4, void * jarg5, int jarg6, int jarg7, void * jarg8, void * jarg9) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double arg2 = (double) -0.5 ;
  double arg3 = (double) 255.5 ;
  int arg4 = (int) 256 ;
  int *arg5 = (int *) NULL ;
  int arg6 = (int) 0 ;
  int arg7 = (int) 1 ;
  GDALProgressFunc arg8 = (GDALProgressFunc) NULL ;
  void *arg9 = (void *) NULL ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (int)jarg4; 
  {
    /* %typemap(in) (int inout[ANY]) */
    arg5 = (int *)jarg5;
  }
  arg6 = (int)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (GDALProgressFunc)jarg8; 
  arg9 = (void *)jarg9; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_GetHistogram(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_GetDefaultHistogram(void * jarg1, double * jarg2, double * jarg3, void * jarg4, void * jarg5, int jarg6, void * jarg7, void * jarg8) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double *arg2 = (double *) NULL ;
  double *arg3 = (double *) NULL ;
  int *arg4 = (int *) NULL ;
  int **arg5 = (int **) NULL ;
  int arg6 = (int) 1 ;
  GDALProgressFunc arg7 = (GDALProgressFunc) NULL ;
  void *arg8 = (void *) NULL ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    /* %typemap(in) (double *val) */
    arg2 = (double *)jarg2;
  }
  {
    /* %typemap(in) (double *val) */
    arg3 = (double *)jarg3;
  }
  {
    /* %typemap(in) (int *hasval) */
    arg4 = (int *)jarg4;
  }
  {
    /* %typemap(in) (int **array_argout) */
    arg5 = (int **)jarg5;
  }
  arg6 = (int)jarg6; 
  arg7 = (GDALProgressFunc)jarg7; 
  arg8 = (void *)jarg8; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_GetDefaultHistogram(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_SetDefaultHistogram(void * jarg1, double jarg2, double jarg3, int jarg4, void * jarg5) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double arg2 ;
  double arg3 ;
  int arg4 ;
  int *arg5 = (int *) 0 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (int)jarg4; 
  {
    /* %typemap(in) (int inout[ANY]) */
    arg5 = (int *)jarg5;
  }
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_SetDefaultHistogram(arg1,arg2,arg3,arg4,arg5);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_Band_HasArbitraryOverviews(void * jarg1) {
  unsigned int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  bool result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (bool)GDALRasterBandShadow_HasArbitraryOverviews(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Band_GetCategoryNames(void * jarg1) {
  void * jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  char **result = 0 ;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (char **)GDALRasterBandShadow_GetCategoryNames(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_SetCategoryNames(void * jarg1, void * jarg2) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  char **arg2 = (char **) 0 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (char **)jarg2; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_SetCategoryNames(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_ReadRaster(void * jarg1, int jarg2, int jarg3, int jarg4, int jarg5, void * jarg6, int jarg7, int jarg8, int jarg9, int jarg10, int jarg11) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  void *arg6 = (void *) 0 ;
  int arg7 ;
  int arg8 ;
  GDALDataType arg9 ;
  int arg10 ;
  int arg11 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (void *)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (int)jarg8; 
  arg9 = (GDALDataType)jarg9; 
  arg10 = (int)jarg10; 
  arg11 = (int)jarg11; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_ReadRaster(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Band_WriteRaster(void * jarg1, int jarg2, int jarg3, int jarg4, int jarg5, void * jarg6, int jarg7, int jarg8, int jarg9, int jarg10, int jarg11) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  int arg5 ;
  void *arg6 = (void *) 0 ;
  int arg7 ;
  int arg8 ;
  GDALDataType arg9 ;
  int arg10 ;
  int arg11 ;
  CPLErr result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (void *)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (int)jarg8; 
  arg9 = (GDALDataType)jarg9; 
  arg10 = (int)jarg10; 
  arg11 = (int)jarg11; 
  {
    CPLErrorReset();
    result = (CPLErr)GDALRasterBandShadow_WriteRaster(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_ColorTable(int jarg1) {
  void * jresult ;
  GDALPaletteInterp arg1 = (GDALPaletteInterp) GPI_RGB ;
  GDALColorTableShadow *result = 0 ;
  
  arg1 = (GDALPaletteInterp)jarg1; 
  {
    CPLErrorReset();
    result = (GDALColorTableShadow *)new_GDALColorTableShadow(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_ColorTable(void * jarg1) {
  GDALColorTableShadow *arg1 = (GDALColorTableShadow *) 0 ;
  
  arg1 = (GDALColorTableShadow *)jarg1; 
  {
    CPLErrorReset();
    delete_GDALColorTableShadow(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_ColorTable_Clone(void * jarg1) {
  void * jresult ;
  GDALColorTableShadow *arg1 = (GDALColorTableShadow *) 0 ;
  GDALColorTableShadow *result = 0 ;
  
  arg1 = (GDALColorTableShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (GDALColorTableShadow *)GDALColorTableShadow_Clone(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_ColorTable_GetPaletteInterpretation(void * jarg1) {
  int jresult ;
  GDALColorTableShadow *arg1 = (GDALColorTableShadow *) 0 ;
  GDALPaletteInterp result;
  
  arg1 = (GDALColorTableShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (GDALPaletteInterp)GDALColorTableShadow_GetPaletteInterpretation(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_ColorTable_GetCount(void * jarg1) {
  int jresult ;
  GDALColorTableShadow *arg1 = (GDALColorTableShadow *) 0 ;
  int result;
  
  arg1 = (GDALColorTableShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALColorTableShadow_GetColorEntryCount(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_ColorTable_GetColorEntry(void * jarg1, int jarg2) {
  void * jresult ;
  GDALColorTableShadow *arg1 = (GDALColorTableShadow *) 0 ;
  int arg2 ;
  GDALColorEntry *result = 0 ;
  
  arg1 = (GDALColorTableShadow *)jarg1; 
  arg2 = (int)jarg2; 
  {
    CPLErrorReset();
    result = (GDALColorEntry *)GDALColorTableShadow_GetColorEntry(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_ColorTable_GetColorEntryAsRGB(void * jarg1, int jarg2, void * jarg3) {
  int jresult ;
  GDALColorTableShadow *arg1 = (GDALColorTableShadow *) 0 ;
  int arg2 ;
  GDALColorEntry *arg3 = (GDALColorEntry *) 0 ;
  int result;
  
  arg1 = (GDALColorTableShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (GDALColorEntry *)jarg3; 
  {
    CPLErrorReset();
    result = (int)GDALColorTableShadow_GetColorEntryAsRGB(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_ColorTable_SetColorEntry(void * jarg1, int jarg2, void * jarg3) {
  GDALColorTableShadow *arg1 = (GDALColorTableShadow *) 0 ;
  int arg2 ;
  GDALColorEntry *arg3 = (GDALColorEntry *) 0 ;
  
  arg1 = (GDALColorTableShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (GDALColorEntry *)jarg3; 
  {
    CPLErrorReset();
    GDALColorTableShadow_SetColorEntry(arg1,arg2,(GDALColorEntry const *)arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_ColorTable_CreateColorRamp(void * jarg1, int jarg2, void * jarg3, int jarg4, void * jarg5) {
  GDALColorTableShadow *arg1 = (GDALColorTableShadow *) 0 ;
  int arg2 ;
  GDALColorEntry *arg3 = (GDALColorEntry *) 0 ;
  int arg4 ;
  GDALColorEntry *arg5 = (GDALColorEntry *) 0 ;
  
  arg1 = (GDALColorTableShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (GDALColorEntry *)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (GDALColorEntry *)jarg5; 
  {
    CPLErrorReset();
    GDALColorTableShadow_CreateColorRamp(arg1,arg2,(GDALColorEntry const *)arg3,arg4,(GDALColorEntry const *)arg5);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_RasterAttributeTable() {
  void * jresult ;
  GDALRasterAttributeTableShadow *result = 0 ;
  
  {
    CPLErrorReset();
    result = (GDALRasterAttributeTableShadow *)new_GDALRasterAttributeTableShadow();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_RasterAttributeTable(void * jarg1) {
  GDALRasterAttributeTableShadow *arg1 = (GDALRasterAttributeTableShadow *) 0 ;
  
  arg1 = (GDALRasterAttributeTableShadow *)jarg1; 
  {
    CPLErrorReset();
    delete_GDALRasterAttributeTableShadow(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_RasterAttributeTable_Clone(void * jarg1) {
  void * jresult ;
  GDALRasterAttributeTableShadow *arg1 = (GDALRasterAttributeTableShadow *) 0 ;
  GDALRasterAttributeTableShadow *result = 0 ;
  
  arg1 = (GDALRasterAttributeTableShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (GDALRasterAttributeTableShadow *)GDALRasterAttributeTableShadow_Clone(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_RasterAttributeTable_GetColumnCount(void * jarg1) {
  int jresult ;
  GDALRasterAttributeTableShadow *arg1 = (GDALRasterAttributeTableShadow *) 0 ;
  int result;
  
  arg1 = (GDALRasterAttributeTableShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALRasterAttributeTableShadow_GetColumnCount(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_RasterAttributeTable_GetNameOfCol(void * jarg1, int jarg2) {
  char * jresult ;
  GDALRasterAttributeTableShadow *arg1 = (GDALRasterAttributeTableShadow *) 0 ;
  int arg2 ;
  char *result = 0 ;
  
  arg1 = (GDALRasterAttributeTableShadow *)jarg1; 
  arg2 = (int)jarg2; 
  {
    CPLErrorReset();
    result = (char *)GDALRasterAttributeTableShadow_GetNameOfCol(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_RasterAttributeTable_GetUsageOfCol(void * jarg1, int jarg2) {
  int jresult ;
  GDALRasterAttributeTableShadow *arg1 = (GDALRasterAttributeTableShadow *) 0 ;
  int arg2 ;
  GDALRATFieldUsage result;
  
  arg1 = (GDALRasterAttributeTableShadow *)jarg1; 
  arg2 = (int)jarg2; 
  {
    CPLErrorReset();
    result = (GDALRATFieldUsage)GDALRasterAttributeTableShadow_GetUsageOfCol(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_RasterAttributeTable_GetTypeOfCol(void * jarg1, int jarg2) {
  int jresult ;
  GDALRasterAttributeTableShadow *arg1 = (GDALRasterAttributeTableShadow *) 0 ;
  int arg2 ;
  GDALRATFieldType result;
  
  arg1 = (GDALRasterAttributeTableShadow *)jarg1; 
  arg2 = (int)jarg2; 
  {
    CPLErrorReset();
    result = (GDALRATFieldType)GDALRasterAttributeTableShadow_GetTypeOfCol(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_RasterAttributeTable_GetColOfUsage(void * jarg1, int jarg2) {
  int jresult ;
  GDALRasterAttributeTableShadow *arg1 = (GDALRasterAttributeTableShadow *) 0 ;
  GDALRATFieldUsage arg2 ;
  int result;
  
  arg1 = (GDALRasterAttributeTableShadow *)jarg1; 
  arg2 = (GDALRATFieldUsage)jarg2; 
  {
    CPLErrorReset();
    result = (int)GDALRasterAttributeTableShadow_GetColOfUsage(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_RasterAttributeTable_GetRowCount(void * jarg1) {
  int jresult ;
  GDALRasterAttributeTableShadow *arg1 = (GDALRasterAttributeTableShadow *) 0 ;
  int result;
  
  arg1 = (GDALRasterAttributeTableShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALRasterAttributeTableShadow_GetRowCount(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_RasterAttributeTable_GetValueAsString(void * jarg1, int jarg2, int jarg3) {
  char * jresult ;
  GDALRasterAttributeTableShadow *arg1 = (GDALRasterAttributeTableShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  char *result = 0 ;
  
  arg1 = (GDALRasterAttributeTableShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    CPLErrorReset();
    result = (char *)GDALRasterAttributeTableShadow_GetValueAsString(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_RasterAttributeTable_GetValueAsInt(void * jarg1, int jarg2, int jarg3) {
  int jresult ;
  GDALRasterAttributeTableShadow *arg1 = (GDALRasterAttributeTableShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  int result;
  
  arg1 = (GDALRasterAttributeTableShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    CPLErrorReset();
    result = (int)GDALRasterAttributeTableShadow_GetValueAsInt(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_RasterAttributeTable_GetValueAsDouble(void * jarg1, int jarg2, int jarg3) {
  double jresult ;
  GDALRasterAttributeTableShadow *arg1 = (GDALRasterAttributeTableShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  double result;
  
  arg1 = (GDALRasterAttributeTableShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    CPLErrorReset();
    result = (double)GDALRasterAttributeTableShadow_GetValueAsDouble(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_RasterAttributeTable_SetValueAsString(void * jarg1, int jarg2, int jarg3, char * jarg4) {
  GDALRasterAttributeTableShadow *arg1 = (GDALRasterAttributeTableShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  char *arg4 = (char *) 0 ;
  string str4 ;
  
  arg1 = (GDALRasterAttributeTableShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    /* %typemap(in) (tostring argin) */
    arg4 = (char *)jarg4;
  }
  {
    CPLErrorReset();
    GDALRasterAttributeTableShadow_SetValueAsString(arg1,arg2,arg3,(char const *)arg4);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_RasterAttributeTable_SetValueAsInt(void * jarg1, int jarg2, int jarg3, int jarg4) {
  GDALRasterAttributeTableShadow *arg1 = (GDALRasterAttributeTableShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  int arg4 ;
  
  arg1 = (GDALRasterAttributeTableShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (int)jarg4; 
  {
    CPLErrorReset();
    GDALRasterAttributeTableShadow_SetValueAsInt(arg1,arg2,arg3,arg4);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_RasterAttributeTable_SetValueAsDouble(void * jarg1, int jarg2, int jarg3, double jarg4) {
  GDALRasterAttributeTableShadow *arg1 = (GDALRasterAttributeTableShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  double arg4 ;
  
  arg1 = (GDALRasterAttributeTableShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (double)jarg4; 
  {
    CPLErrorReset();
    GDALRasterAttributeTableShadow_SetValueAsDouble(arg1,arg2,arg3,arg4);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_RasterAttributeTable_SetRowCount(void * jarg1, int jarg2) {
  GDALRasterAttributeTableShadow *arg1 = (GDALRasterAttributeTableShadow *) 0 ;
  int arg2 ;
  
  arg1 = (GDALRasterAttributeTableShadow *)jarg1; 
  arg2 = (int)jarg2; 
  {
    CPLErrorReset();
    GDALRasterAttributeTableShadow_SetRowCount(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_RasterAttributeTable_CreateColumn(void * jarg1, char * jarg2, int jarg3, int jarg4) {
  int jresult ;
  GDALRasterAttributeTableShadow *arg1 = (GDALRasterAttributeTableShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  GDALRATFieldType arg3 ;
  GDALRATFieldUsage arg4 ;
  int result;
  
  arg1 = (GDALRasterAttributeTableShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (GDALRATFieldType)jarg3; 
  arg4 = (GDALRATFieldUsage)jarg4; 
  {
    CPLErrorReset();
    result = (int)GDALRasterAttributeTableShadow_CreateColumn(arg1,(char const *)arg2,arg3,arg4);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT unsigned int SWIGSTDCALL CSharp_RasterAttributeTable_GetLinearBinning(void * jarg1, double * jarg2, double * jarg3) {
  unsigned int jresult ;
  GDALRasterAttributeTableShadow *arg1 = (GDALRasterAttributeTableShadow *) 0 ;
  double *arg2 = (double *) 0 ;
  double *arg3 = (double *) 0 ;
  bool result;
  
  arg1 = (GDALRasterAttributeTableShadow *)jarg1; 
  {
    /* %typemap(in) (double *val) */
    arg2 = (double *)jarg2;
  }
  {
    /* %typemap(in) (double *val) */
    arg3 = (double *)jarg3;
  }
  {
    CPLErrorReset();
    result = (bool)GDALRasterAttributeTableShadow_GetLinearBinning(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_RasterAttributeTable_SetLinearBinning(void * jarg1, double jarg2, double jarg3) {
  int jresult ;
  GDALRasterAttributeTableShadow *arg1 = (GDALRasterAttributeTableShadow *) 0 ;
  double arg2 ;
  double arg3 ;
  int result;
  
  arg1 = (GDALRasterAttributeTableShadow *)jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  {
    CPLErrorReset();
    result = (int)GDALRasterAttributeTableShadow_SetLinearBinning(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_RasterAttributeTable_GetRowOfValue(void * jarg1, double jarg2) {
  int jresult ;
  GDALRasterAttributeTableShadow *arg1 = (GDALRasterAttributeTableShadow *) 0 ;
  double arg2 ;
  int result;
  
  arg1 = (GDALRasterAttributeTableShadow *)jarg1; 
  arg2 = (double)jarg2; 
  {
    CPLErrorReset();
    result = (int)GDALRasterAttributeTableShadow_GetRowOfValue(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_RasterAttributeTable_ChangesAreWrittenToFile(void * jarg1) {
  int jresult ;
  GDALRasterAttributeTableShadow *arg1 = (GDALRasterAttributeTableShadow *) 0 ;
  int result;
  
  arg1 = (GDALRasterAttributeTableShadow *)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALRasterAttributeTableShadow_ChangesAreWrittenToFile(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_RasterAttributeTable_DumpReadable(void * jarg1) {
  GDALRasterAttributeTableShadow *arg1 = (GDALRasterAttributeTableShadow *) 0 ;
  
  arg1 = (GDALRasterAttributeTableShadow *)jarg1; 
  {
    CPLErrorReset();
    GDALRasterAttributeTableShadow_DumpReadable(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_ComputeMedianCutPCT(void * jarg1, void * jarg2, void * jarg3, int jarg4, void * jarg5, void * jarg6, void * jarg7) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALRasterBandShadow *arg2 = (GDALRasterBandShadow *) 0 ;
  GDALRasterBandShadow *arg3 = (GDALRasterBandShadow *) 0 ;
  int arg4 ;
  GDALColorTableShadow *arg5 = (GDALColorTableShadow *) 0 ;
  GDALProgressFunc arg6 = (GDALProgressFunc) NULL ;
  void *arg7 = (void *) NULL ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (GDALRasterBandShadow *)jarg2; 
  arg3 = (GDALRasterBandShadow *)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (GDALColorTableShadow *)jarg5; 
  arg6 = (GDALProgressFunc)jarg6; 
  arg7 = (void *)jarg7; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg2) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg3) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg5) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (int)ComputeMedianCutPCT(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_DitherRGB2PCT(void * jarg1, void * jarg2, void * jarg3, void * jarg4, void * jarg5, void * jarg6, void * jarg7) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALRasterBandShadow *arg2 = (GDALRasterBandShadow *) 0 ;
  GDALRasterBandShadow *arg3 = (GDALRasterBandShadow *) 0 ;
  GDALRasterBandShadow *arg4 = (GDALRasterBandShadow *) 0 ;
  GDALColorTableShadow *arg5 = (GDALColorTableShadow *) 0 ;
  GDALProgressFunc arg6 = (GDALProgressFunc) NULL ;
  void *arg7 = (void *) NULL ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (GDALRasterBandShadow *)jarg2; 
  arg3 = (GDALRasterBandShadow *)jarg3; 
  arg4 = (GDALRasterBandShadow *)jarg4; 
  arg5 = (GDALColorTableShadow *)jarg5; 
  arg6 = (GDALProgressFunc)jarg6; 
  arg7 = (void *)jarg7; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg2) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg3) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg4) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg5) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (int)DitherRGB2PCT(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_ReprojectImage(void * jarg1, void * jarg2, char * jarg3, char * jarg4, int jarg5, double jarg6, double jarg7, void * jarg8, void * jarg9, void * jarg10) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  GDALDatasetShadow *arg2 = (GDALDatasetShadow *) 0 ;
  char *arg3 = (char *) NULL ;
  char *arg4 = (char *) NULL ;
  GDALResampleAlg arg5 = (GDALResampleAlg) GRA_NearestNeighbour ;
  double arg6 = (double) 0.0 ;
  double arg7 = (double) 0.0 ;
  GDALProgressFunc arg8 = (GDALProgressFunc) NULL ;
  void *arg9 = (void *) NULL ;
  char **arg10 = (char **) NULL ;
  CPLErr result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (GDALDatasetShadow *)jarg2; 
  arg3 = (char *)jarg3; 
  arg4 = (char *)jarg4; 
  arg5 = (GDALResampleAlg)jarg5; 
  arg6 = (double)jarg6; 
  arg7 = (double)jarg7; 
  arg8 = (GDALProgressFunc)jarg8; 
  arg9 = (void *)jarg9; 
  arg10 = (char **)jarg10; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg2) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (CPLErr)ReprojectImage(arg1,arg2,(char const *)arg3,(char const *)arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_ComputeProximity(void * jarg1, void * jarg2, void * jarg3, void * jarg4, void * jarg5) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALRasterBandShadow *arg2 = (GDALRasterBandShadow *) 0 ;
  char **arg3 = (char **) NULL ;
  GDALProgressFunc arg4 = (GDALProgressFunc) NULL ;
  void *arg5 = (void *) NULL ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (GDALRasterBandShadow *)jarg2; 
  arg3 = (char **)jarg3; 
  arg4 = (GDALProgressFunc)jarg4; 
  arg5 = (void *)jarg5; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg2) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (int)ComputeProximity(arg1,arg2,arg3,arg4,arg5);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_RasterizeLayer(void * jarg1, int jarg2, void * jarg3, void * jarg4, void * jarg5, void * jarg6, int jarg7, void * jarg8, void * jarg9, void * jarg10, void * jarg11) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int arg2 ;
  int *arg3 = (int *) 0 ;
  OGRLayerShadow *arg4 = (OGRLayerShadow *) 0 ;
  void *arg5 = (void *) NULL ;
  void *arg6 = (void *) NULL ;
  int arg7 = (int) 0 ;
  double *arg8 = (double *) NULL ;
  char **arg9 = (char **) NULL ;
  GDALProgressFunc arg10 = (GDALProgressFunc) NULL ;
  void *arg11 = (void *) NULL ;
  int result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (int)jarg2; 
  {
    /* %typemap(in) (int inout[ANY]) */
    arg3 = (int *)jarg3;
  }
  arg4 = (OGRLayerShadow *)jarg4; 
  arg5 = (void *)jarg5; 
  arg6 = (void *)jarg6; 
  arg7 = (int)jarg7; 
  {
    /* %typemap(in) (double inout[ANY]) */
    arg8 = (double *)jarg8;
  }
  arg9 = (char **)jarg9; 
  arg10 = (GDALProgressFunc)jarg10; 
  arg11 = (void *)jarg11; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg4) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (int)RasterizeLayer(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Polygonize(void * jarg1, void * jarg2, void * jarg3, int jarg4, void * jarg5, void * jarg6, void * jarg7) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALRasterBandShadow *arg2 = (GDALRasterBandShadow *) 0 ;
  OGRLayerShadow *arg3 = (OGRLayerShadow *) 0 ;
  int arg4 ;
  char **arg5 = (char **) NULL ;
  GDALProgressFunc arg6 = (GDALProgressFunc) NULL ;
  void *arg7 = (void *) NULL ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (GDALRasterBandShadow *)jarg2; 
  arg3 = (OGRLayerShadow *)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (char **)jarg5; 
  arg6 = (GDALProgressFunc)jarg6; 
  arg7 = (void *)jarg7; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg3) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (int)Polygonize(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_FPolygonize(void * jarg1, void * jarg2, void * jarg3, int jarg4, void * jarg5, void * jarg6, void * jarg7) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALRasterBandShadow *arg2 = (GDALRasterBandShadow *) 0 ;
  OGRLayerShadow *arg3 = (OGRLayerShadow *) 0 ;
  int arg4 ;
  char **arg5 = (char **) NULL ;
  GDALProgressFunc arg6 = (GDALProgressFunc) NULL ;
  void *arg7 = (void *) NULL ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (GDALRasterBandShadow *)jarg2; 
  arg3 = (OGRLayerShadow *)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (char **)jarg5; 
  arg6 = (GDALProgressFunc)jarg6; 
  arg7 = (void *)jarg7; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg3) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (int)FPolygonize(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_FillNodata(void * jarg1, void * jarg2, double jarg3, int jarg4, void * jarg5, void * jarg6, void * jarg7) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALRasterBandShadow *arg2 = (GDALRasterBandShadow *) 0 ;
  double arg3 ;
  int arg4 ;
  char **arg5 = (char **) NULL ;
  GDALProgressFunc arg6 = (GDALProgressFunc) NULL ;
  void *arg7 = (void *) NULL ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (GDALRasterBandShadow *)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (char **)jarg5; 
  arg6 = (GDALProgressFunc)jarg6; 
  arg7 = (void *)jarg7; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (int)FillNodata(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_SieveFilter(void * jarg1, void * jarg2, void * jarg3, int jarg4, int jarg5, void * jarg6, void * jarg7, void * jarg8) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALRasterBandShadow *arg2 = (GDALRasterBandShadow *) 0 ;
  GDALRasterBandShadow *arg3 = (GDALRasterBandShadow *) 0 ;
  int arg4 ;
  int arg5 = (int) 4 ;
  char **arg6 = (char **) NULL ;
  GDALProgressFunc arg7 = (GDALProgressFunc) NULL ;
  void *arg8 = (void *) NULL ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (GDALRasterBandShadow *)jarg2; 
  arg3 = (GDALRasterBandShadow *)jarg3; 
  arg4 = (int)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (char **)jarg6; 
  arg7 = (GDALProgressFunc)jarg7; 
  arg8 = (void *)jarg8; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg3) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (int)SieveFilter(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_RegenerateOverviews(void * jarg1, int jarg2, void * jarg3, char * jarg4, void * jarg5, void * jarg6) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  int arg2 ;
  GDALRasterBandShadow **arg3 = (GDALRasterBandShadow **) 0 ;
  char *arg4 = (char *) "average" ;
  GDALProgressFunc arg5 = (GDALProgressFunc) NULL ;
  void *arg6 = (void *) NULL ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (GDALRasterBandShadow **)jarg3; 
  arg4 = (char *)jarg4; 
  arg5 = (GDALProgressFunc)jarg5; 
  arg6 = (void *)jarg6; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (int)RegenerateOverviews(arg1,arg2,arg3,(char const *)arg4,arg5,arg6);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_RegenerateOverview(void * jarg1, void * jarg2, char * jarg3, void * jarg4, void * jarg5) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  GDALRasterBandShadow *arg2 = (GDALRasterBandShadow *) 0 ;
  char *arg3 = (char *) "average" ;
  GDALProgressFunc arg4 = (GDALProgressFunc) NULL ;
  void *arg5 = (void *) NULL ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (GDALRasterBandShadow *)jarg2; 
  arg3 = (char *)jarg3; 
  arg4 = (GDALProgressFunc)jarg4; 
  arg5 = (void *)jarg5; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg2) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (int)RegenerateOverview(arg1,arg2,(char const *)arg3,arg4,arg5);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_ContourGenerate(void * jarg1, double jarg2, double jarg3, int jarg4, void * jarg5, int jarg6, double jarg7, void * jarg8, int jarg9, int jarg10, void * jarg11, void * jarg12) {
  int jresult ;
  GDALRasterBandShadow *arg1 = (GDALRasterBandShadow *) 0 ;
  double arg2 ;
  double arg3 ;
  int arg4 ;
  double *arg5 = (double *) 0 ;
  int arg6 ;
  double arg7 ;
  OGRLayerShadow *arg8 = (OGRLayerShadow *) 0 ;
  int arg9 ;
  int arg10 ;
  GDALProgressFunc arg11 = (GDALProgressFunc) NULL ;
  void *arg12 = (void *) NULL ;
  int result;
  
  arg1 = (GDALRasterBandShadow *)jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (int)jarg4; 
  {
    /* %typemap(in) (double inout[ANY]) */
    arg5 = (double *)jarg5;
  }
  arg6 = (int)jarg6; 
  arg7 = (double)jarg7; 
  arg8 = (OGRLayerShadow *)jarg8; 
  arg9 = (int)jarg9; 
  arg10 = (int)jarg10; 
  arg11 = (GDALProgressFunc)jarg11; 
  arg12 = (void *)jarg12; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg8) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (int)ContourGenerate(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_AutoCreateWarpedVRT(void * jarg1, char * jarg2, char * jarg3, int jarg4, double jarg5) {
  void * jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  char *arg2 = (char *) 0 ;
  char *arg3 = (char *) 0 ;
  GDALResampleAlg arg4 = (GDALResampleAlg) GRA_NearestNeighbour ;
  double arg5 = (double) 0.0 ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (char *)jarg3; 
  arg4 = (GDALResampleAlg)jarg4; 
  arg5 = (double)jarg5; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)AutoCreateWarpedVRT(arg1,(char const *)arg2,(char const *)arg3,arg4,arg5);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_CreatePansharpenedVRT(char * jarg1, void * jarg2, int jarg3, void * jarg4) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  GDALRasterBandShadow *arg2 = (GDALRasterBandShadow *) 0 ;
  int arg3 ;
  GDALRasterBandShadow **arg4 = (GDALRasterBandShadow **) 0 ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (GDALRasterBandShadow *)jarg2; 
  arg3 = (int)jarg3; 
  arg4 = (GDALRasterBandShadow **)jarg4; 
  {
    if (!arg2) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)CreatePansharpenedVRT((char const *)arg1,arg2,arg3,arg4);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_Transformer(void * jarg1, void * jarg2, void * jarg3) {
  void * jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  GDALDatasetShadow *arg2 = (GDALDatasetShadow *) 0 ;
  char **arg3 = (char **) 0 ;
  GDALTransformerInfoShadow *result = 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (GDALDatasetShadow *)jarg2; 
  arg3 = (char **)jarg3; 
  {
    CPLErrorReset();
    result = (GDALTransformerInfoShadow *)new_GDALTransformerInfoShadow(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_Transformer(void * jarg1) {
  GDALTransformerInfoShadow *arg1 = (GDALTransformerInfoShadow *) 0 ;
  
  arg1 = (GDALTransformerInfoShadow *)jarg1; 
  {
    CPLErrorReset();
    delete_GDALTransformerInfoShadow(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_Transformer_TransformPoint__SWIG_0(void * jarg1, int jarg2, void * jarg3) {
  int jresult ;
  GDALTransformerInfoShadow *arg1 = (GDALTransformerInfoShadow *) 0 ;
  int arg2 ;
  double *arg3 ;
  int result;
  
  arg1 = (GDALTransformerInfoShadow *)jarg1; 
  arg2 = (int)jarg2; 
  {
    /* %typemap(in) (double argin[ANY]) */
    arg3 = (double *)jarg3;
  }
  {
    CPLErrorReset();
    result = (int)GDALTransformerInfoShadow_TransformPoint__SWIG_0(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Transformer_TransformPoint__SWIG_1(void * jarg1, void * jarg2, int jarg3, double jarg4, double jarg5, double jarg6) {
  int jresult ;
  GDALTransformerInfoShadow *arg1 = (GDALTransformerInfoShadow *) 0 ;
  double *arg2 ;
  int arg3 ;
  double arg4 ;
  double arg5 ;
  double arg6 = (double) 0.0 ;
  int result;
  
  arg1 = (GDALTransformerInfoShadow *)jarg1; 
  {
    /* %typemap(in) (double argout[ANY]) */
    arg2 = (double *)jarg2;
  }
  arg3 = (int)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (double)jarg6; 
  {
    CPLErrorReset();
    result = (int)GDALTransformerInfoShadow_TransformPoint__SWIG_1(arg1,arg2,arg3,arg4,arg5,arg6);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Transformer_TransformPoints(void * jarg1, int jarg2, int jarg3, void * jarg4, void * jarg5, void * jarg6, void * jarg7) {
  int jresult ;
  GDALTransformerInfoShadow *arg1 = (GDALTransformerInfoShadow *) 0 ;
  int arg2 ;
  int arg3 ;
  double *arg4 = (double *) 0 ;
  double *arg5 = (double *) 0 ;
  double *arg6 = (double *) 0 ;
  int *arg7 = (int *) 0 ;
  int result;
  
  arg1 = (GDALTransformerInfoShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (int)jarg3; 
  {
    /* %typemap(in) (double argout[ANY]) */
    arg4 = (double *)jarg4;
  }
  {
    /* %typemap(in) (double argout[ANY]) */
    arg5 = (double *)jarg5;
  }
  {
    /* %typemap(in) (double argout[ANY]) */
    arg6 = (double *)jarg6;
  }
  {
    /* %typemap(in) (double argout[ANY]) */
    arg7 = (int *)jarg7;
  }
  {
    CPLErrorReset();
    result = (int)GDALTransformerInfoShadow_TransformPoints(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_Transformer_TransformGeolocations(void * jarg1, void * jarg2, void * jarg3, void * jarg4, void * jarg5, void * jarg6, void * jarg7) {
  int jresult ;
  GDALTransformerInfoShadow *arg1 = (GDALTransformerInfoShadow *) 0 ;
  GDALRasterBandShadow *arg2 = (GDALRasterBandShadow *) 0 ;
  GDALRasterBandShadow *arg3 = (GDALRasterBandShadow *) 0 ;
  GDALRasterBandShadow *arg4 = (GDALRasterBandShadow *) 0 ;
  GDALProgressFunc arg5 = (GDALProgressFunc) NULL ;
  void *arg6 = (void *) NULL ;
  char **arg7 = (char **) NULL ;
  int result;
  
  arg1 = (GDALTransformerInfoShadow *)jarg1; 
  arg2 = (GDALRasterBandShadow *)jarg2; 
  arg3 = (GDALRasterBandShadow *)jarg3; 
  arg4 = (GDALRasterBandShadow *)jarg4; 
  arg5 = (GDALProgressFunc)jarg5; 
  arg6 = (void *)jarg6; 
  arg7 = (char **)jarg7; 
  {
    if (!arg2) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg3) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg4) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (int)GDALTransformerInfoShadow_TransformGeolocations(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_ApplyVerticalShiftGrid(void * jarg1, void * jarg2, unsigned int jarg3, double jarg4, double jarg5, void * jarg6) {
  void * jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  GDALDatasetShadow *arg2 = (GDALDatasetShadow *) 0 ;
  bool arg3 = (bool) false ;
  double arg4 = (double) 1.0 ;
  double arg5 = (double) 1.0 ;
  char **arg6 = (char **) NULL ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (GDALDatasetShadow *)jarg2; 
  arg3 = jarg3 ? true : false; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (char **)jarg6; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg2) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)ApplyVerticalShiftGrid(arg1,arg2,arg3,arg4,arg5,arg6);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_ApplyGeoTransform(void * jarg1, double jarg2, double jarg3, double * jarg4, double * jarg5) {
  double *arg1 ;
  double arg2 ;
  double arg3 ;
  double *arg4 = (double *) 0 ;
  double *arg5 = (double *) 0 ;
  
  {
    /* %typemap(in) (double argin[ANY]) */
    arg1 = (double *)jarg1;
  }
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  {
    /* %typemap(in) (double *val) */
    arg4 = (double *)jarg4;
  }
  {
    /* %typemap(in) (double *val) */
    arg5 = (double *)jarg5;
  }
  {
    CPLErrorReset();
    GDALApplyGeoTransform(arg1,arg2,arg3,arg4,arg5);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_InvGeoTransform(void * jarg1, void * jarg2) {
  int jresult ;
  double *arg1 ;
  double *arg2 ;
  RETURN_NONE result;
  
  {
    /* %typemap(in) (double argin[ANY]) */
    arg1 = (double *)jarg1;
  }
  {
    /* %typemap(in) (double argout[ANY]) */
    arg2 = (double *)jarg2;
  }
  {
    CPLErrorReset();
    result = (RETURN_NONE)GDALInvGeoTransform(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_VersionInfo(char * jarg1) {
  char * jresult ;
  char *arg1 = (char *) "VERSION_NUM" ;
  char *result = 0 ;
  
  arg1 = (char *)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDALVersionInfo((char const *)arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_AllRegister() {
  {
    CPLErrorReset();
    GDALAllRegister();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void SWIGSTDCALL CSharp_GDALDestroyDriverManager() {
  {
    CPLErrorReset();
    GDALDestroyDriverManager();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_GetCacheMax() {
  int jresult ;
  int result;
  
  {
    CPLErrorReset();
    result = (int)wrapper_GDALGetCacheMax();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_GetCacheUsed() {
  int jresult ;
  int result;
  
  {
    CPLErrorReset();
    result = (int)wrapper_GDALGetCacheUsed();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_SetCacheMax(int jarg1) {
  int arg1 ;
  
  arg1 = (int)jarg1; 
  {
    CPLErrorReset();
    wrapper_GDALSetCacheMax(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_GetDataTypeSize(int jarg1) {
  int jresult ;
  GDALDataType arg1 ;
  int result;
  
  arg1 = (GDALDataType)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALGetDataTypeSize(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_DataTypeIsComplex(int jarg1) {
  int jresult ;
  GDALDataType arg1 ;
  int result;
  
  arg1 = (GDALDataType)jarg1; 
  {
    CPLErrorReset();
    result = (int)GDALDataTypeIsComplex(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GetDataTypeName(int jarg1) {
  char * jresult ;
  GDALDataType arg1 ;
  char *result = 0 ;
  
  arg1 = (GDALDataType)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDALGetDataTypeName(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_GetDataTypeByName(char * jarg1) {
  int jresult ;
  char *arg1 = (char *) 0 ;
  GDALDataType result;
  
  arg1 = (char *)jarg1; 
  {
    CPLErrorReset();
    result = (GDALDataType)GDALGetDataTypeByName((char const *)arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GetColorInterpretationName(int jarg1) {
  char * jresult ;
  GDALColorInterp arg1 ;
  char *result = 0 ;
  
  arg1 = (GDALColorInterp)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDALGetColorInterpretationName(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GetPaletteInterpretationName(int jarg1) {
  char * jresult ;
  GDALPaletteInterp arg1 ;
  char *result = 0 ;
  
  arg1 = (GDALPaletteInterp)jarg1; 
  {
    CPLErrorReset();
    result = (char *)GDALGetPaletteInterpretationName(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_DecToDMS(double jarg1, char * jarg2, int jarg3) {
  char * jresult ;
  double arg1 ;
  char *arg2 = (char *) 0 ;
  int arg3 = (int) 2 ;
  char *result = 0 ;
  
  arg1 = (double)jarg1; 
  arg2 = (char *)jarg2; 
  arg3 = (int)jarg3; 
  {
    CPLErrorReset();
    result = (char *)GDALDecToDMS(arg1,(char const *)arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = SWIG_csharp_string_callback((const char *)result); 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_PackedDMSToDec(double jarg1) {
  double jresult ;
  double arg1 ;
  double result;
  
  arg1 = (double)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDALPackedDMSToDec(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT double SWIGSTDCALL CSharp_DecToPackedDMS(double jarg1) {
  double jresult ;
  double arg1 ;
  double result;
  
  arg1 = (double)jarg1; 
  {
    CPLErrorReset();
    result = (double)GDALDecToPackedDMS(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_ParseXMLString(char * jarg1) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  CPLXMLNode *result = 0 ;
  
  arg1 = (char *)jarg1; 
  {
    CPLErrorReset();
    result = (CPLXMLNode *)CPLParseXMLString(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_SerializeXMLTree(void * jarg1) {
  char * jresult ;
  CPLXMLNode *arg1 = (CPLXMLNode *) 0 ;
  retStringAndCPLFree *result = 0 ;
  
  arg1 = (CPLXMLNode *)jarg1; 
  {
    CPLErrorReset();
    result = (retStringAndCPLFree *)CPLSerializeXMLTree(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  
  /* %typemap(out) (retStringAndCPLFree*) */
  if(result)
  {
    jresult = SWIG_csharp_string_callback((const char *)result);
    CPLFree(result);
  }
  else
  {
    jresult = NULL;
  }
  
  return jresult;
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GetJPEG2000StructureAsString(char * jarg1, void * jarg2) {
  char * jresult ;
  char *arg1 = (char *) 0 ;
  char **arg2 = (char **) NULL ;
  retStringAndCPLFree *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (char **)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (retStringAndCPLFree *)GetJPEG2000StructureAsString((char const *)arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  
  /* %typemap(out) (retStringAndCPLFree*) */
  if(result)
  {
    jresult = SWIG_csharp_string_callback((const char *)result);
    CPLFree(result);
  }
  else
  {
    jresult = NULL;
  }
  
  return jresult;
}


SWIGEXPORT int SWIGSTDCALL CSharp_GetDriverCount() {
  int jresult ;
  int result;
  
  {
    CPLErrorReset();
    result = (int)GetDriverCount();
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_GetDriverByName(char * jarg1) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  GDALDriverShadow *result = 0 ;
  
  arg1 = (char *)jarg1; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (GDALDriverShadow *)GetDriverByName((char const *)arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_GetDriver(int jarg1) {
  void * jresult ;
  int arg1 ;
  GDALDriverShadow *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    CPLErrorReset();
    result = (GDALDriverShadow *)GetDriver(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_Open(char * jarg1, int jarg2) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  GDALAccess arg2 = (GDALAccess) GA_ReadOnly ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (GDALAccess)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)Open((char const *)arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_OpenEx(char * jarg1, unsigned int jarg2, void * jarg3, void * jarg4, void * jarg5) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  unsigned int arg2 = (unsigned int) 0 ;
  char **arg3 = (char **) NULL ;
  char **arg4 = (char **) NULL ;
  char **arg5 = (char **) NULL ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = (char **)jarg3; 
  arg4 = (char **)jarg4; 
  arg5 = (char **)jarg5; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)OpenEx((char const *)arg1,arg2,arg3,arg4,arg5);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_OpenShared(char * jarg1, int jarg2) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  GDALAccess arg2 = (GDALAccess) GA_ReadOnly ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (GDALAccess)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)OpenShared((char const *)arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_IdentifyDriver(char * jarg1, void * jarg2) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  char **arg2 = (char **) NULL ;
  GDALDriverShadow *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (char **)jarg2; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (GDALDriverShadow *)IdentifyDriver((char const *)arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_IdentifyDriverEx(char * jarg1, unsigned int jarg2, void * jarg3, void * jarg4) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  unsigned int arg2 = (unsigned int) 0 ;
  char **arg3 = (char **) NULL ;
  char **arg4 = (char **) NULL ;
  GDALDriverShadow *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (unsigned int)jarg2; 
  arg3 = (char **)jarg3; 
  arg4 = (char **)jarg4; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (GDALDriverShadow *)IdentifyDriverEx((char const *)arg1,arg2,arg3,arg4);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_GeneralCmdLineProcessor(void * jarg1, int jarg2) {
  void * jresult ;
  char **arg1 = (char **) 0 ;
  int arg2 = (int) 0 ;
  char **result = 0 ;
  
  arg1 = (char **)jarg1; 
  arg2 = (int)jarg2; 
  {
    CPLErrorReset();
    result = (char **)GeneralCmdLineProcessor(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp___WriteCArrayItem_GDAL_GCP(void * jarg1, int jarg2, void * jarg3) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  int arg2 ;
  GDAL_GCP *arg3 = (GDAL_GCP *) 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (GDAL_GCP *)jarg3; 
  {
    CPLErrorReset();
    __WriteCArrayItem_GDAL_GCP(arg1,arg2,arg3);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp___ReadCArrayItem_GDAL_GCP(void * jarg1, int jarg2) {
  void * jresult ;
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  int arg2 ;
  GDAL_GCP *result = 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  arg2 = (int)jarg2; 
  {
    CPLErrorReset();
    result = (GDAL_GCP *)__ReadCArrayItem_GDAL_GCP(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp___AllocCArray_GDAL_GCP(int jarg1) {
  void * jresult ;
  int arg1 ;
  GDAL_GCP *result = 0 ;
  
  arg1 = (int)jarg1; 
  {
    CPLErrorReset();
    result = (GDAL_GCP *)__AllocCArray_GDAL_GCP(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp___FreeCArray_GDAL_GCP(void * jarg1) {
  GDAL_GCP *arg1 = (GDAL_GCP *) 0 ;
  
  arg1 = (GDAL_GCP *)jarg1; 
  {
    CPLErrorReset();
    __FreeCArray_GDAL_GCP(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_GDALInfoOptions(void * jarg1) {
  void * jresult ;
  char **arg1 = (char **) 0 ;
  GDALInfoOptions *result = 0 ;
  
  arg1 = (char **)jarg1; 
  {
    CPLErrorReset();
    result = (GDALInfoOptions *)new_GDALInfoOptions(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_GDALInfoOptions(void * jarg1) {
  GDALInfoOptions *arg1 = (GDALInfoOptions *) 0 ;
  
  arg1 = (GDALInfoOptions *)jarg1; 
  {
    CPLErrorReset();
    delete_GDALInfoOptions(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT char * SWIGSTDCALL CSharp_GDALInfo(void * jarg1, void * jarg2) {
  char * jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  GDALInfoOptions *arg2 = (GDALInfoOptions *) 0 ;
  retStringAndCPLFree *result = 0 ;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (GDALInfoOptions *)jarg2; 
  {
    CPLErrorReset();
    result = (retStringAndCPLFree *)GDALInfo(arg1,arg2);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  
  /* %typemap(out) (retStringAndCPLFree*) */
  if(result)
  {
    jresult = SWIG_csharp_string_callback((const char *)result);
    CPLFree(result);
  }
  else
  {
    jresult = NULL;
  }
  
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_GDALTranslateOptions(void * jarg1) {
  void * jresult ;
  char **arg1 = (char **) 0 ;
  GDALTranslateOptions *result = 0 ;
  
  arg1 = (char **)jarg1; 
  {
    CPLErrorReset();
    result = (GDALTranslateOptions *)new_GDALTranslateOptions(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_GDALTranslateOptions(void * jarg1) {
  GDALTranslateOptions *arg1 = (GDALTranslateOptions *) 0 ;
  
  arg1 = (GDALTranslateOptions *)jarg1; 
  {
    CPLErrorReset();
    delete_GDALTranslateOptions(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_wrapper_GDALTranslate(char * jarg1, void * jarg2, void * jarg3, void * jarg4, void * jarg5) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  GDALDatasetShadow *arg2 = (GDALDatasetShadow *) 0 ;
  GDALTranslateOptions *arg3 = (GDALTranslateOptions *) 0 ;
  GDALProgressFunc arg4 = (GDALProgressFunc) NULL ;
  void *arg5 = (void *) NULL ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (GDALDatasetShadow *)jarg2; 
  arg3 = (GDALTranslateOptions *)jarg3; 
  arg4 = (GDALProgressFunc)jarg4; 
  arg5 = (void *)jarg5; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg2) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)wrapper_GDALTranslate((char const *)arg1,arg2,arg3,arg4,arg5);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_GDALWarpAppOptions(void * jarg1) {
  void * jresult ;
  char **arg1 = (char **) 0 ;
  GDALWarpAppOptions *result = 0 ;
  
  arg1 = (char **)jarg1; 
  {
    CPLErrorReset();
    result = (GDALWarpAppOptions *)new_GDALWarpAppOptions(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_GDALWarpAppOptions(void * jarg1) {
  GDALWarpAppOptions *arg1 = (GDALWarpAppOptions *) 0 ;
  
  arg1 = (GDALWarpAppOptions *)jarg1; 
  {
    CPLErrorReset();
    delete_GDALWarpAppOptions(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_wrapper_GDALWarpDestDS(void * jarg1, int jarg2, void * jarg3, void * jarg4, void * jarg5, void * jarg6) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  int arg2 ;
  GDALDatasetShadow **arg3 = (GDALDatasetShadow **) 0 ;
  GDALWarpAppOptions *arg4 = (GDALWarpAppOptions *) 0 ;
  GDALProgressFunc arg5 = (GDALProgressFunc) NULL ;
  void *arg6 = (void *) NULL ;
  int result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (GDALDatasetShadow **)jarg3; 
  arg4 = (GDALWarpAppOptions *)jarg4; 
  arg5 = (GDALProgressFunc)jarg5; 
  arg6 = (void *)jarg6; 
  {
    CPLErrorReset();
    result = (int)wrapper_GDALWarpDestDS(arg1,arg2,arg3,arg4,arg5,arg6);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_wrapper_GDALWarpDestName(char * jarg1, int jarg2, void * jarg3, void * jarg4, void * jarg5, void * jarg6) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  int arg2 ;
  GDALDatasetShadow **arg3 = (GDALDatasetShadow **) 0 ;
  GDALWarpAppOptions *arg4 = (GDALWarpAppOptions *) 0 ;
  GDALProgressFunc arg5 = (GDALProgressFunc) NULL ;
  void *arg6 = (void *) NULL ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (GDALDatasetShadow **)jarg3; 
  arg4 = (GDALWarpAppOptions *)jarg4; 
  arg5 = (GDALProgressFunc)jarg5; 
  arg6 = (void *)jarg6; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)wrapper_GDALWarpDestName((char const *)arg1,arg2,arg3,arg4,arg5,arg6);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_GDALVectorTranslateOptions(void * jarg1) {
  void * jresult ;
  char **arg1 = (char **) 0 ;
  GDALVectorTranslateOptions *result = 0 ;
  
  arg1 = (char **)jarg1; 
  {
    CPLErrorReset();
    result = (GDALVectorTranslateOptions *)new_GDALVectorTranslateOptions(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_GDALVectorTranslateOptions(void * jarg1) {
  GDALVectorTranslateOptions *arg1 = (GDALVectorTranslateOptions *) 0 ;
  
  arg1 = (GDALVectorTranslateOptions *)jarg1; 
  {
    CPLErrorReset();
    delete_GDALVectorTranslateOptions(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_wrapper_GDALVectorTranslateDestDS(void * jarg1, void * jarg2, void * jarg3, void * jarg4, void * jarg5) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  GDALDatasetShadow *arg2 = (GDALDatasetShadow *) 0 ;
  GDALVectorTranslateOptions *arg3 = (GDALVectorTranslateOptions *) 0 ;
  GDALProgressFunc arg4 = (GDALProgressFunc) NULL ;
  void *arg5 = (void *) NULL ;
  int result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (GDALDatasetShadow *)jarg2; 
  arg3 = (GDALVectorTranslateOptions *)jarg3; 
  arg4 = (GDALProgressFunc)jarg4; 
  arg5 = (void *)jarg5; 
  {
    CPLErrorReset();
    result = (int)wrapper_GDALVectorTranslateDestDS(arg1,arg2,arg3,arg4,arg5);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_wrapper_GDALVectorTranslateDestName(char * jarg1, void * jarg2, void * jarg3, void * jarg4, void * jarg5) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  GDALDatasetShadow *arg2 = (GDALDatasetShadow *) 0 ;
  GDALVectorTranslateOptions *arg3 = (GDALVectorTranslateOptions *) 0 ;
  GDALProgressFunc arg4 = (GDALProgressFunc) NULL ;
  void *arg5 = (void *) NULL ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (GDALDatasetShadow *)jarg2; 
  arg3 = (GDALVectorTranslateOptions *)jarg3; 
  arg4 = (GDALProgressFunc)jarg4; 
  arg5 = (void *)jarg5; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)wrapper_GDALVectorTranslateDestName((char const *)arg1,arg2,arg3,arg4,arg5);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_GDALDEMProcessingOptions(void * jarg1) {
  void * jresult ;
  char **arg1 = (char **) 0 ;
  GDALDEMProcessingOptions *result = 0 ;
  
  arg1 = (char **)jarg1; 
  {
    CPLErrorReset();
    result = (GDALDEMProcessingOptions *)new_GDALDEMProcessingOptions(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_GDALDEMProcessingOptions(void * jarg1) {
  GDALDEMProcessingOptions *arg1 = (GDALDEMProcessingOptions *) 0 ;
  
  arg1 = (GDALDEMProcessingOptions *)jarg1; 
  {
    CPLErrorReset();
    delete_GDALDEMProcessingOptions(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_wrapper_GDALDEMProcessing(char * jarg1, void * jarg2, char * jarg3, char * jarg4, void * jarg5, void * jarg6, void * jarg7) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  GDALDatasetShadow *arg2 = (GDALDatasetShadow *) 0 ;
  char *arg3 = (char *) 0 ;
  char *arg4 = (char *) 0 ;
  GDALDEMProcessingOptions *arg5 = (GDALDEMProcessingOptions *) 0 ;
  GDALProgressFunc arg6 = (GDALProgressFunc) NULL ;
  void *arg7 = (void *) NULL ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (GDALDatasetShadow *)jarg2; 
  arg3 = (char *)jarg3; 
  arg4 = (char *)jarg4; 
  arg5 = (GDALDEMProcessingOptions *)jarg5; 
  arg6 = (GDALProgressFunc)jarg6; 
  arg7 = (void *)jarg7; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg2) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg3) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)wrapper_GDALDEMProcessing((char const *)arg1,arg2,(char const *)arg3,(char const *)arg4,arg5,arg6,arg7);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_GDALNearblackOptions(void * jarg1) {
  void * jresult ;
  char **arg1 = (char **) 0 ;
  GDALNearblackOptions *result = 0 ;
  
  arg1 = (char **)jarg1; 
  {
    CPLErrorReset();
    result = (GDALNearblackOptions *)new_GDALNearblackOptions(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_GDALNearblackOptions(void * jarg1) {
  GDALNearblackOptions *arg1 = (GDALNearblackOptions *) 0 ;
  
  arg1 = (GDALNearblackOptions *)jarg1; 
  {
    CPLErrorReset();
    delete_GDALNearblackOptions(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_wrapper_GDALNearblackDestDS(void * jarg1, void * jarg2, void * jarg3, void * jarg4, void * jarg5) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  GDALDatasetShadow *arg2 = (GDALDatasetShadow *) 0 ;
  GDALNearblackOptions *arg3 = (GDALNearblackOptions *) 0 ;
  GDALProgressFunc arg4 = (GDALProgressFunc) NULL ;
  void *arg5 = (void *) NULL ;
  int result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (GDALDatasetShadow *)jarg2; 
  arg3 = (GDALNearblackOptions *)jarg3; 
  arg4 = (GDALProgressFunc)jarg4; 
  arg5 = (void *)jarg5; 
  {
    CPLErrorReset();
    result = (int)wrapper_GDALNearblackDestDS(arg1,arg2,arg3,arg4,arg5);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_wrapper_GDALNearblackDestName(char * jarg1, void * jarg2, void * jarg3, void * jarg4, void * jarg5) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  GDALDatasetShadow *arg2 = (GDALDatasetShadow *) 0 ;
  GDALNearblackOptions *arg3 = (GDALNearblackOptions *) 0 ;
  GDALProgressFunc arg4 = (GDALProgressFunc) NULL ;
  void *arg5 = (void *) NULL ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (GDALDatasetShadow *)jarg2; 
  arg3 = (GDALNearblackOptions *)jarg3; 
  arg4 = (GDALProgressFunc)jarg4; 
  arg5 = (void *)jarg5; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)wrapper_GDALNearblackDestName((char const *)arg1,arg2,arg3,arg4,arg5);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_GDALGridOptions(void * jarg1) {
  void * jresult ;
  char **arg1 = (char **) 0 ;
  GDALGridOptions *result = 0 ;
  
  arg1 = (char **)jarg1; 
  {
    CPLErrorReset();
    result = (GDALGridOptions *)new_GDALGridOptions(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_GDALGridOptions(void * jarg1) {
  GDALGridOptions *arg1 = (GDALGridOptions *) 0 ;
  
  arg1 = (GDALGridOptions *)jarg1; 
  {
    CPLErrorReset();
    delete_GDALGridOptions(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_wrapper_GDALGrid(char * jarg1, void * jarg2, void * jarg3, void * jarg4, void * jarg5) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  GDALDatasetShadow *arg2 = (GDALDatasetShadow *) 0 ;
  GDALGridOptions *arg3 = (GDALGridOptions *) 0 ;
  GDALProgressFunc arg4 = (GDALProgressFunc) NULL ;
  void *arg5 = (void *) NULL ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (GDALDatasetShadow *)jarg2; 
  arg3 = (GDALGridOptions *)jarg3; 
  arg4 = (GDALProgressFunc)jarg4; 
  arg5 = (void *)jarg5; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    if (!arg2) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)wrapper_GDALGrid((char const *)arg1,arg2,arg3,arg4,arg5);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_GDALRasterizeOptions(void * jarg1) {
  void * jresult ;
  char **arg1 = (char **) 0 ;
  GDALRasterizeOptions *result = 0 ;
  
  arg1 = (char **)jarg1; 
  {
    CPLErrorReset();
    result = (GDALRasterizeOptions *)new_GDALRasterizeOptions(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_GDALRasterizeOptions(void * jarg1) {
  GDALRasterizeOptions *arg1 = (GDALRasterizeOptions *) 0 ;
  
  arg1 = (GDALRasterizeOptions *)jarg1; 
  {
    CPLErrorReset();
    delete_GDALRasterizeOptions(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT int SWIGSTDCALL CSharp_wrapper_GDALRasterizeDestDS(void * jarg1, void * jarg2, void * jarg3, void * jarg4, void * jarg5) {
  int jresult ;
  GDALDatasetShadow *arg1 = (GDALDatasetShadow *) 0 ;
  GDALDatasetShadow *arg2 = (GDALDatasetShadow *) 0 ;
  GDALRasterizeOptions *arg3 = (GDALRasterizeOptions *) 0 ;
  GDALProgressFunc arg4 = (GDALProgressFunc) NULL ;
  void *arg5 = (void *) NULL ;
  int result;
  
  arg1 = (GDALDatasetShadow *)jarg1; 
  arg2 = (GDALDatasetShadow *)jarg2; 
  arg3 = (GDALRasterizeOptions *)jarg3; 
  arg4 = (GDALProgressFunc)jarg4; 
  arg5 = (void *)jarg5; 
  {
    CPLErrorReset();
    result = (int)wrapper_GDALRasterizeDestDS(arg1,arg2,arg3,arg4,arg5);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_wrapper_GDALRasterizeDestName(char * jarg1, void * jarg2, void * jarg3, void * jarg4, void * jarg5) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  GDALDatasetShadow *arg2 = (GDALDatasetShadow *) 0 ;
  GDALRasterizeOptions *arg3 = (GDALRasterizeOptions *) 0 ;
  GDALProgressFunc arg4 = (GDALProgressFunc) NULL ;
  void *arg5 = (void *) NULL ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (GDALDatasetShadow *)jarg2; 
  arg3 = (GDALRasterizeOptions *)jarg3; 
  arg4 = (GDALProgressFunc)jarg4; 
  arg5 = (void *)jarg5; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)wrapper_GDALRasterizeDestName((char const *)arg1,arg2,arg3,arg4,arg5);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_new_GDALBuildVRTOptions(void * jarg1) {
  void * jresult ;
  char **arg1 = (char **) 0 ;
  GDALBuildVRTOptions *result = 0 ;
  
  arg1 = (char **)jarg1; 
  {
    CPLErrorReset();
    result = (GDALBuildVRTOptions *)new_GDALBuildVRTOptions(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void SWIGSTDCALL CSharp_delete_GDALBuildVRTOptions(void * jarg1) {
  GDALBuildVRTOptions *arg1 = (GDALBuildVRTOptions *) 0 ;
  
  arg1 = (GDALBuildVRTOptions *)jarg1; 
  {
    CPLErrorReset();
    delete_GDALBuildVRTOptions(arg1);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
}


SWIGEXPORT void * SWIGSTDCALL CSharp_wrapper_GDALBuildVRT_objects(char * jarg1, int jarg2, void * jarg3, void * jarg4, void * jarg5, void * jarg6) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  int arg2 ;
  GDALDatasetShadow **arg3 = (GDALDatasetShadow **) 0 ;
  GDALBuildVRTOptions *arg4 = (GDALBuildVRTOptions *) 0 ;
  GDALProgressFunc arg5 = (GDALProgressFunc) NULL ;
  void *arg6 = (void *) NULL ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (GDALDatasetShadow **)jarg3; 
  arg4 = (GDALBuildVRTOptions *)jarg4; 
  arg5 = (GDALProgressFunc)jarg5; 
  arg6 = (void *)jarg6; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)wrapper_GDALBuildVRT_objects((char const *)arg1,arg2,arg3,arg4,arg5,arg6);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT void * SWIGSTDCALL CSharp_wrapper_GDALBuildVRT_names(char * jarg1, void * jarg2, void * jarg3, void * jarg4, void * jarg5) {
  void * jresult ;
  char *arg1 = (char *) 0 ;
  char **arg2 = (char **) 0 ;
  GDALBuildVRTOptions *arg3 = (GDALBuildVRTOptions *) 0 ;
  GDALProgressFunc arg4 = (GDALProgressFunc) NULL ;
  void *arg5 = (void *) NULL ;
  GDALDatasetShadow *result = 0 ;
  
  arg1 = (char *)jarg1; 
  arg2 = (char **)jarg2; 
  arg3 = (GDALBuildVRTOptions *)jarg3; 
  arg4 = (GDALProgressFunc)jarg4; 
  arg5 = (void *)jarg5; 
  {
    if (!arg1) {
      {
        SWIG_CSharpException(SWIG_ValueError, "Received a NULL pointer."); return 0; 
      };
    }
  }
  {
    CPLErrorReset();
    result = (GDALDatasetShadow *)wrapper_GDALBuildVRT_names((char const *)arg1,arg2,arg3,arg4,arg5);
    CPLErr eclass = CPLGetLastErrorType();
    if ( eclass == CE_Failure || eclass == CE_Fatal ) {
      SWIG_CSharpException(SWIG_RuntimeError, CPLGetLastErrorMsg());
      
      
      
    }
    
    
    
    
    
    
    
    
    
    
    
  }
  jresult = (void *)result; 
  return jresult;
}


SWIGEXPORT GDALMajorObjectShadow * SWIGSTDCALL CSharp_Driver_SWIGUpcast(GDALDriverShadow *jarg1) {
    return (GDALMajorObjectShadow *)jarg1;
}

SWIGEXPORT GDALMajorObjectShadow * SWIGSTDCALL CSharp_Dataset_SWIGUpcast(GDALDatasetShadow *jarg1) {
    return (GDALMajorObjectShadow *)jarg1;
}

SWIGEXPORT GDALMajorObjectShadow * SWIGSTDCALL CSharp_Band_SWIGUpcast(GDALRasterBandShadow *jarg1) {
    return (GDALMajorObjectShadow *)jarg1;
}

#ifdef __cplusplus
}
#endif

