
/**
 * This is an additional file to export and import classes used by other projects
 * so we don't need to modify the original Scintilla code.
 */

#ifndef _SCINTILLAIMPORTEXPORT_H_
#define _SCINTILLAIMPORTEXPORT_H_

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <assert.h>

#include "Scintilla.h"
#include "ILexer.h"
#include "LexerModule.h"
#include "WordList.h"
#include "Catalogue.h"
#include "PropSetSimple.h"
#include "LexAccessor.h"
#include "Accessor.h"

#pragma warning (disable: 4275) // Use of dll-interface for a class derived from one without dll-interfac.

#ifdef DECL_SCI_EXPORT
  #define SCI_IMPORT_EXPORT __declspec(dllexport)
#else
  #define SCI_IMPORT_EXPORT __declspec(dllimport)
#endif

namespace ScintillaWrapper {

class SCI_IMPORT_EXPORT LexerModule : public Scintilla::LexerModule {};
class SCI_IMPORT_EXPORT PropSetSimple : public Scintilla::PropSetSimple {};

class SCI_IMPORT_EXPORT WordList : public Scintilla::WordList
{
public:
  void Set(const char *s) { Scintilla::WordList::Set(s); };
  void Clear() { Scintilla::WordList::Clear(); };
};

class SCI_IMPORT_EXPORT Catalogue : public Scintilla::Catalogue
{
public:
  static const Scintilla::LexerModule *Find(const char *languageName)
  {
    return Scintilla::Catalogue::Find(languageName);
  };
};

class SCI_IMPORT_EXPORT Accessor : public Scintilla::Accessor
{
public:
  Accessor(Scintilla::IDocument *pAccess_, Scintilla::PropSetSimple *pprops_)
    : Scintilla::Accessor(pAccess_, pprops_) {};
};

} // namespace ScintillaWrapper

#endif // _SCINTILLAIMPORTEXPORT_H_